/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.message;

import io.netty.buffer.ByteBuf;
import net.ilexiconn.llibrary.server.network.AbstractMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jurassicraft.server.entity.vehicle.HelicopterBaseEntity;
import org.jurassicraft.server.message.HelicopterMessages;
import org.jurassicraft.server.util.MutableVec3;

public class HelicopterDirectionMessage
extends AbstractMessage<HelicopterDirectionMessage> {
    private int heliID;
    private MutableVec3 direction;

    public HelicopterDirectionMessage() {
        this.direction = new MutableVec3(0.0, 0.0, 0.0);
    }

    public HelicopterDirectionMessage(int heliID, MutableVec3 direction) {
        this.heliID = heliID;
        this.direction = direction;
    }

    public void onClientReceived(Minecraft minecraft, HelicopterDirectionMessage message, EntityPlayer entityPlayer, MessageContext messageContext) {
        HelicopterBaseEntity helicopter = HelicopterMessages.getHeli(entityPlayer.field_70170_p, message.heliID);
        if (helicopter != null) {
            helicopter.setDirection(message.direction);
        }
    }

    public void onServerReceived(MinecraftServer minecraftServer, HelicopterDirectionMessage message, EntityPlayer entityPlayer, MessageContext messageContext) {
        HelicopterBaseEntity helicopter = HelicopterMessages.getHeli(entityPlayer.field_70170_p, message.heliID);
        if (helicopter != null) {
            helicopter.setDirection(message.direction);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.heliID = buf.readInt();
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        this.direction.set(x, y, z);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.heliID);
        buf.writeDouble(this.direction.xCoord);
        buf.writeDouble(this.direction.yCoord);
        buf.writeDouble(this.direction.zCoord);
    }
}

