/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.item;

import java.util.List;
import java.util.Random;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.server.api.SynthesizableItem;
import org.jurassicraft.server.genetics.StorageType;
import org.jurassicraft.server.genetics.StorageTypeRegistry;
import org.jurassicraft.server.item.ItemHandler;
import org.jurassicraft.server.tab.TabHandler;

public class StorageDiscItem
extends Item
implements SynthesizableItem {
    public StorageDiscItem() {
        this.func_77637_a(TabHandler.ITEMS);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null) {
            String storageId = nbt.func_74779_i("StorageId");
            StorageType type = StorageTypeRegistry.getStorageType(storageId);
            if (type != null) {
                type.readFromNBT(nbt);
                type.addInformation(stack, tooltip);
            }
        } else {
            tooltip.add(TextFormatting.RED + I18n.func_135052_a((String)"cage.empty.name", (Object[])new Object[0]));
        }
    }

    @Override
    public boolean isSynthesizable(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        return tagCompound != null && tagCompound.func_74764_b("DNAQuality") && tagCompound.func_74762_e("DNAQuality") == 100;
    }

    @Override
    public ItemStack getSynthesizedItem(ItemStack stack, Random random) {
        ItemStack output = !stack.func_77978_p().func_74779_i("StorageId").equalsIgnoreCase("PlantDNA") ? new ItemStack((Item)ItemHandler.DNA, 1, stack.func_77952_i()) : new ItemStack((Item)ItemHandler.PLANT_DNA, 1, stack.func_77952_i());
        output.func_77982_d(stack.func_77978_p());
        return output;
    }
}

