/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.item;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.server.plant.Plant;
import org.jurassicraft.server.plant.PlantHandler;
import org.jurassicraft.server.tab.TabHandler;
import org.jurassicraft.server.util.LangHelper;

public class PlantDNAItem
extends Item {
    public PlantDNAItem() {
        this.func_77637_a(TabHandler.PLANTS);
        this.func_77627_a(true);
    }

    public String func_77653_i(ItemStack stack) {
        String plantName = this.getPlant(stack).getName().toLowerCase(Locale.ENGLISH).replaceAll(" ", "_");
        return new LangHelper("item.plant_dna.name").withProperty("plant", "plants." + plantName + ".name").build();
    }

    public Plant getPlant(ItemStack stack) {
        Plant plant = PlantHandler.getPlantById(stack.func_77952_i());
        if (plant == null) {
            plant = PlantHandler.SMALL_ROYAL_FERN;
        }
        return plant;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> subtypes) {
        LinkedList<Plant> plants = new LinkedList<Plant>(PlantHandler.getPrehistoricPlants());
        HashMap<Plant, Integer> ids = new HashMap<Plant, Integer>();
        for (Plant plant : plants) {
            ids.put(plant, PlantHandler.getPlantId(plant));
        }
        Collections.sort(plants);
        for (Plant plant : plants) {
            if (!plant.shouldRegister()) continue;
            subtypes.add(new ItemStack(item, 1, ((Integer)ids.get(plant)).intValue()));
        }
    }

    public int getDNAQuality(EntityPlayer player, ItemStack stack) {
        int quality = player.field_71075_bZ.field_75098_d ? 100 : 0;
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        if (nbt.func_74764_b("DNAQuality")) {
            quality = nbt.func_74762_e("DNAQuality");
        } else {
            nbt.func_74768_a("DNAQuality", quality);
        }
        stack.func_77982_d(nbt);
        return quality;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> lore, boolean advanced) {
        int quality = this.getDNAQuality(player, stack);
        TextFormatting formatting = quality > 75 ? TextFormatting.GREEN : (quality > 50 ? TextFormatting.YELLOW : (quality > 25 ? TextFormatting.GOLD : TextFormatting.RED));
        lore.add(formatting + new LangHelper("lore.dna_quality.name").withProperty("quality", quality + "").build());
    }
}

