/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.event;

import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.server.achievements.AchievementHandler;
import org.jurassicraft.server.block.BlockHandler;
import org.jurassicraft.server.block.FossilizedTrackwayBlock;
import org.jurassicraft.server.block.plant.DoublePlantBlock;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.item.ItemHandler;
import org.jurassicraft.server.util.GameRuleHandler;
import org.jurassicraft.server.world.WorldGenCoal;

public class ServerEventHandler {
    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        GameRuleHandler.register(event.getWorld());
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onItemPickup(PlayerEvent.ItemPickupEvent event) {
        if (event.pickedUp.func_92059_d().func_77973_b() == ItemHandler.AMBER) {
            event.player.func_71064_a((StatBase)AchievementHandler.AMBER, 1);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onCraft(PlayerEvent.ItemCraftedEvent event) {
        Item item = event.crafting.func_77973_b();
        if (item == ItemHandler.PLASTER_AND_BANDAGE) {
            event.player.func_71064_a((StatBase)AchievementHandler.PALEONTOLOGY, 1);
        } else if (item == Item.func_150898_a((Block)BlockHandler.CLEANING_STATION)) {
            event.player.func_71064_a((StatBase)AchievementHandler.CLEANING_STATION, 1);
        } else if (item == Item.func_150898_a((Block)BlockHandler.FOSSIL_GRINDER)) {
            event.player.func_71064_a((StatBase)AchievementHandler.FOSSIL_GRINDER, 1);
        } else if (item == Item.func_150898_a((Block)BlockHandler.REINFORCED_STONE)) {
            event.player.func_71064_a((StatBase)AchievementHandler.REINFORCED_STONE, 1);
        } else if (item == Item.func_150898_a((Block)BlockHandler.REINFORCED_BRICKS)) {
            event.player.func_71064_a((StatBase)AchievementHandler.REINFORCED_STONE, 1);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void decorate(DecorateBiomeEvent.Pre event) {
        IBlockState state;
        BlockPos topBlock;
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        Random rand = event.getRand();
        Biome biome = world.func_180494_b(pos);
        BiomeDecorator decorator = biome.field_76760_I;
        if (JurassiCraft.CONFIG.plantFossilGeneration && decorator != null && decorator.field_180293_d != null && !(decorator.field_76821_k instanceof WorldGenCoal)) {
            decorator.field_76821_k = new WorldGenCoal(Blocks.field_150365_q.func_176223_P(), decorator.field_180293_d.field_177844_ac);
        }
        if (JurassiCraft.CONFIG.mossGeneration && (BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS) || BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP) || BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) && rand.nextInt(8) == 0 && world.func_180495_p((topBlock = world.func_175672_r(pos)).func_177977_b()).func_185914_p() && !world.func_180495_p(topBlock).func_185904_a().func_76224_d()) {
            world.func_180501_a(topBlock, BlockHandler.MOSS.func_176223_P(), 2);
        }
        if (JurassiCraft.CONFIG.flowerGeneration && (BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP) || BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) && rand.nextInt(8) == 0 && world.func_180495_p((topBlock = world.func_175672_r(pos)).func_177977_b()).func_185914_p() && !world.func_180495_p(topBlock).func_185904_a().func_76224_d()) {
            world.func_180501_a(topBlock.func_177984_a(), BlockHandler.WEST_INDIAN_LILAC.func_176223_P(), 2);
            world.func_180501_a(topBlock, BlockHandler.WEST_INDIAN_LILAC.func_176223_P().func_177226_a((IProperty)DoublePlantBlock.HALF, (Comparable)((Object)DoublePlantBlock.BlockHalf.LOWER)), 2);
        }
        if (JurassiCraft.CONFIG.gracilariaGeneration && BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) && rand.nextInt(8) == 0 && (topBlock = world.func_175672_r(pos)).func_177956_o() < 62 && (state = world.func_180495_p(topBlock.func_177977_b())).func_185914_p()) {
            world.func_180501_a(topBlock, BlockHandler.GRACILARIA.func_176223_P(), 2);
        }
        if (JurassiCraft.CONFIG.peatGeneration && BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP) && rand.nextInt(2) == 0) {
            new WorldGenMinable(BlockHandler.PEAT.func_176223_P(), 5, input -> input == Blocks.field_150346_d.func_176223_P() || input == Blocks.field_150349_c.func_176223_P()).func_180709_b(world, rand, world.func_175672_r(pos));
        }
        if (JurassiCraft.CONFIG.trackwayGeneration) {
            int footprintChance = 20;
            if (BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER)) {
                footprintChance = 10;
            }
            if (rand.nextInt(footprintChance) == 0) {
                int y = rand.nextInt(20) + 30;
                FossilizedTrackwayBlock.TrackwayType type = FossilizedTrackwayBlock.TrackwayType.values()[rand.nextInt(FossilizedTrackwayBlock.TrackwayType.values().length)];
                for (int i = 0; i < rand.nextInt(2) + 1; ++i) {
                    BlockPos basePos = new BlockPos(pos.func_177958_n() + rand.nextInt(10) - 5, y, pos.func_177952_p() + rand.nextInt(10) - 5);
                    float angle = (float)(rand.nextDouble() * 360.0);
                    IBlockState trackway = BlockHandler.FOSSILIZED_TRACKWAY.func_176223_P().func_177226_a((IProperty)FossilizedTrackwayBlock.FACING, (Comparable)EnumFacing.func_176733_a((double)angle)).func_177226_a(FossilizedTrackwayBlock.VARIANT, (Comparable)((Object)type));
                    float xOffset = -MathHelper.func_76126_a((float)((float)Math.toRadians(angle)));
                    float zOffset = MathHelper.func_76134_b((float)((float)Math.toRadians(angle)));
                    for (int l = 0; l < rand.nextInt(2) + 3; ++l) {
                        BlockPos trackwayPos = basePos.func_177963_a((double)(xOffset * (float)l), 0.0, (double)(zOffset * (float)l));
                        if (world.func_180495_p(trackwayPos).func_177230_c() != Blocks.field_150348_b) continue;
                        world.func_175656_a(trackwayPos, trackway);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        ResourceLocation name = event.getName();
        LootTable table = event.getTable();
        if (name == LootTableList.field_186387_al) {
            LootEntry[] entries = new LootEntry[]{new LootEntryItem((Item)ItemHandler.GRACILARIA, 25, 0, new LootFunction[0], new LootCondition[0], "gracilaria")};
            LootPool pool = new LootPool(entries, new LootCondition[0], new RandomValueRange(1.0f, 1.0f), new RandomValueRange(0.0f, 0.0f), "jurassicraft");
            table.addPool(pool);
        } else if (name == LootTableList.field_186423_e || name == LootTableList.field_186425_g || name == LootTableList.field_186422_d || name == LootTableList.field_186428_j || name == LootTableList.field_186429_k || name == LootTableList.field_186424_f) {
            List<Dinosaur> dinosaurs = EntityHandler.getRegisteredDinosaurs();
            LootEntry[] actionFigureEntries = new LootEntry[dinosaurs.size()];
            int i = 0;
            for (Dinosaur dinosaur : dinosaurs) {
                int meta = EntityHandler.getDinosaurId(dinosaur);
                actionFigureEntries[i++] = new LootEntryItem((Item)ItemHandler.ACTION_FIGURE, 25, 0, new LootFunction[]{new SetMetadata(new LootCondition[0], new RandomValueRange((float)meta, (float)meta))}, new LootCondition[0], dinosaur.getName().toLowerCase(Locale.ENGLISH));
            }
            table.addPool(new LootPool(actionFigureEntries, new LootCondition[0], new RandomValueRange(1.0f, 2.0f), new RandomValueRange(0.0f, 0.0f), "action_figures"));
            LootEntry[] fossilEntries = new LootEntry[dinosaurs.size() + 3];
            fossilEntries[0] = new LootEntryItem((Item)ItemHandler.PLANT_FOSSIL, 20, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 3.0f))}, new LootCondition[0], "plant_fossil");
            fossilEntries[1] = new LootEntryItem((Item)ItemHandler.TWIG_FOSSIL, 20, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 3.0f))}, new LootCondition[0], "twig_fossil");
            fossilEntries[2] = new LootEntryItem((Item)ItemHandler.AMBER, 15, 0, new LootFunction[]{new SetMetadata(new LootCondition[0], new RandomValueRange(0.0f, 1.0f))}, new LootCondition[0], "amber");
            i = 3;
            for (Dinosaur dinosaur : dinosaurs) {
                int meta = EntityHandler.getDinosaurId(dinosaur);
                fossilEntries[i++] = new LootEntryItem((Item)ItemHandler.FOSSILS.get("skull"), 10, 0, new LootFunction[]{new SetMetadata(new LootCondition[0], new RandomValueRange((float)meta, (float)meta))}, new LootCondition[0], dinosaur.getName().toLowerCase(Locale.ENGLISH));
            }
            table.addPool(new LootPool(fossilEntries, new LootCondition[0], new RandomValueRange(1.0f, 2.0f), new RandomValueRange(0.0f, 0.0f), "fossils"));
            LootEntry[] lootEntryArray = new LootEntry[]{new LootEntryItem((Item)ItemHandler.JURASSICRAFT_THEME_DISC, 25, 0, new LootFunction[0], new LootCondition[0], "jurassicraft_theme"), new LootEntryItem((Item)ItemHandler.DONT_MOVE_A_MUSCLE_DISC, 25, 0, new LootFunction[0], new LootCondition[0], "dont_move_a_muscle"), new LootEntryItem((Item)ItemHandler.TROODONS_AND_RAPTORS_DISC, 25, 0, new LootFunction[0], new LootCondition[0], "troodons_and_raptors")};
            table.addPool(new LootPool(lootEntryArray, new LootCondition[0], new RandomValueRange(0.0f, 2.0f), new RandomValueRange(0.0f, 0.0f), "records"));
        }
    }
}

