/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity.vehicle.modules;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.server.entity.vehicle.HelicopterBaseEntity;
import org.jurassicraft.server.entity.vehicle.modules.HelicopterModule;
import org.jurassicraft.server.entity.vehicle.modules.ModulePosition;
import org.jurassicraft.server.message.HelicopterModulesMessage;

public class HelicopterModuleSpot {
    private final List<HelicopterModule> modules;
    private final float angleFromCenter;
    private final ModulePosition position;
    private final HelicopterBaseEntity helicopter;

    public HelicopterModuleSpot(ModulePosition pos, HelicopterBaseEntity helicopter, float angleFromCenter) {
        this.helicopter = helicopter;
        this.position = pos;
        this.angleFromCenter = angleFromCenter;
        this.modules = Lists.newArrayList();
    }

    public List<HelicopterModule> getModules() {
        return this.modules;
    }

    public boolean addModule(HelicopterModule m) {
        return this.addModule(m, null, new Vec3d(0.0, 0.0, 0.0));
    }

    public boolean addModule(HelicopterModule m, EntityPlayer player, Vec3d v) {
        if (!this.modules.contains(m)) {
            this.modules.add(m);
            if (player != null) {
                m.onAdded(this, player, v);
            }
            if (this.getHelicopter().shouldSyncModules() && !this.getHelicopter().field_70170_p.field_72995_K) {
                JurassiCraft.NETWORK_WRAPPER.sendToAll((IMessage)new HelicopterModulesMessage(this.helicopter.func_145782_y(), this.position, this));
            }
            return true;
        }
        return false;
    }

    public float getAngleFromCenter() {
        return this.angleFromCenter;
    }

    public void readFromNBT(NBTTagCompound compound) {
        System.out.println(">> " + compound);
        this.modules.clear();
        NBTTagList list = compound.func_150295_c("modules", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound moduleData = list.func_150305_b(i);
            String id = moduleData.func_74779_i("id");
            HelicopterModule module = HelicopterModule.createFromID(id);
            this.addModule(module);
            if (module != null) continue;
            throw new IllegalArgumentException("Invalid module ID");
        }
    }

    public void writeToNBT(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (HelicopterModule m : this.modules) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("id", m.getModuleID());
            m.writeToNBT(data);
            list.func_74742_a((NBTBase)data);
        }
        compound.func_74782_a("modules", (NBTBase)list);
    }

    public void readSpawnData(ByteBuf data) {
        this.modules.clear();
        int size = data.readInt();
        for (int i = 0; i < size; ++i) {
            String id = ByteBufUtils.readUTF8String((ByteBuf)data);
            HelicopterModule module = HelicopterModule.createFromID(id);
            NBTTagCompound nbt = ByteBufUtils.readTag((ByteBuf)data);
            if (module == null) {
                System.err.println("Null module for id " + id);
                continue;
            }
            System.out.println(">> Read for " + id + " " + nbt);
            module.readFromNBT(nbt);
            this.addModule(module);
        }
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.modules.size());
        for (HelicopterModule m : this.modules) {
            ByteBufUtils.writeUTF8String((ByteBuf)data, (String)m.getModuleID());
            NBTTagCompound moduleData = new NBTTagCompound();
            m.writeToNBT(moduleData);
            ByteBufUtils.writeTag((ByteBuf)data, (NBTTagCompound)moduleData);
        }
    }

    public ModulePosition getPosition() {
        return this.position;
    }

    public boolean isClicked(Vec3d v) {
        return this.position.isClicked(v);
    }

    public void onClicked(EntityPlayer player, Vec3d vec) {
        for (HelicopterModule m : this.modules) {
            System.out.println(">> Clicked on " + m.getModuleID());
            if (!m.onClicked(this, player, vec)) continue;
            return;
        }
    }

    public HelicopterBaseEntity getHelicopter() {
        return this.helicopter;
    }

    public boolean has(HelicopterModule module) {
        return this.modules.contains(module);
    }
}

