/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import org.jurassicraft.client.model.animation.DinosaurAnimation;
import org.jurassicraft.client.model.animation.PoseHandler;
import org.jurassicraft.client.sound.SoundHandler;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.entity.GrowthStage;
import org.jurassicraft.server.entity.dinosaur.VelociraptorEntity;

public class VelociraptorLeapEntityAI
extends EntityAIBase {
    private VelociraptorEntity entity;
    private EntityLivingBase target;
    private float leapLength;
    private int prevTick;
    private DinosaurAnimation animation;
    private double targetPrevPosX;
    private double targetPrevPosZ;
    private boolean ticked = false;

    public VelociraptorLeapEntityAI(VelociraptorEntity entity) {
        this.entity = entity;
    }

    public boolean func_75250_a() {
        float distance;
        if (this.entity.herd != null && this.entity.herd.fleeing) {
            return false;
        }
        EntityLivingBase target = this.entity.func_70638_az();
        if (target != null && target.func_70089_S() && (!(target instanceof DinosaurEntity) || !((DinosaurEntity)target).isCarcass()) && (distance = this.entity.func_70032_d((Entity)target)) >= 5.0f && distance <= 6.0f && this.entity.field_70122_E) {
            this.target = target;
            return true;
        }
        return false;
    }

    public void func_75249_e() {
        this.animation = DinosaurAnimation.VELOCIRAPTOR_PREPARE_POUNCE;
        PoseHandler poseHandler = this.entity.getDinosaur().getPoseHandler();
        GrowthStage growthStage = this.entity.getGrowthStage();
        this.leapLength = poseHandler.getAnimationLength(DinosaurAnimation.VELOCIRAPTOR_LEAP.get(), growthStage);
        this.entity.func_70671_ap().func_75651_a((Entity)this.target, 30.0f, 30.0f);
        this.ticked = false;
    }

    public void func_75246_d() {
        int tick = this.entity.getAnimationTick();
        if (this.animation == DinosaurAnimation.VELOCIRAPTOR_PREPARE_POUNCE && tick < this.prevTick) {
            this.animation = DinosaurAnimation.VELOCIRAPTOR_LEAP;
            this.entity.setAnimation(this.animation.get());
            this.entity.func_184185_a(SoundHandler.VELOCIRAPTOR_ATTACK, this.entity.func_70599_aP(), this.entity.func_70647_i());
            double targetSpeedX = this.target.field_70165_t - (!this.ticked ? this.target.field_70169_q : this.targetPrevPosX);
            double targetSpeedZ = this.target.field_70161_v - (!this.ticked ? this.target.field_70166_s : this.targetPrevPosZ);
            double length = 6.0;
            double destX = this.target.field_70165_t + targetSpeedX * length;
            double destZ = this.target.field_70161_v + targetSpeedZ * length;
            double delta = Math.sqrt((destX - this.entity.field_70165_t) * (destX - this.entity.field_70165_t) + (destZ - this.entity.field_70161_v) * (destZ - this.entity.field_70161_v));
            double angle = Math.atan2(destZ - this.entity.field_70161_v, destX - this.entity.field_70165_t);
            this.entity.field_70159_w = delta / length * Math.cos(angle);
            this.entity.field_70179_y = delta / length * Math.sin(angle);
            this.entity.field_70181_x = Math.min(0.3, Math.max(0.0, (this.target.field_70163_u - this.entity.field_70163_u) * 0.1)) + 0.6;
        } else if (this.animation == DinosaurAnimation.VELOCIRAPTOR_LEAP && this.entity.field_70181_x < 0.0) {
            this.animation = DinosaurAnimation.VELOCIRAPTOR_LAND;
            this.entity.setAnimation(this.animation.get());
        } else if (this.animation == DinosaurAnimation.VELOCIRAPTOR_LAND && (this.entity.field_70122_E || this.entity.isSwimming())) {
            this.animation = DinosaurAnimation.IDLE;
            this.entity.setAnimation(this.animation.get());
            if (this.entity.func_174813_aQ() != null && this.target.func_174813_aQ() != null && this.entity.func_174813_aQ().func_72326_a(this.target.func_174813_aQ().func_72314_b(2.0, 2.0, 2.0))) {
                this.entity.func_70652_k((Entity)this.target);
            }
        }
        this.targetPrevPosX = this.target.field_70165_t;
        this.targetPrevPosZ = this.target.field_70161_v;
        this.ticked = true;
        if (this.entity.getAnimation() != this.animation.get()) {
            this.entity.setAnimation(this.animation.get());
            this.entity.setAnimationTick(this.prevTick + 1);
        }
        this.prevTick = tick;
    }

    public void func_75251_c() {
        this.entity.setAnimation(DinosaurAnimation.IDLE.get());
    }

    public boolean func_75253_b() {
        return !this.target.field_70128_L && (!(this.target instanceof DinosaurEntity) || !((DinosaurEntity)this.target).isCarcass()) && this.animation != DinosaurAnimation.IDLE;
    }
}

