/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.UUID;
import net.ilexiconn.llibrary.client.model.tools.ChainBuffer;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.client.model.animation.DinosaurAnimation;
import org.jurassicraft.server.block.entity.FeederBlockEntity;
import org.jurassicraft.server.damage.DinosaurDamageSource;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.DinosaurSerializers;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.entity.GrowthStage;
import org.jurassicraft.server.entity.InventoryDinosaur;
import org.jurassicraft.server.entity.MetabolismContainer;
import org.jurassicraft.server.entity.SleepingSchedule;
import org.jurassicraft.server.entity.ai.AdvancedSwimEntityAI;
import org.jurassicraft.server.entity.ai.AssistOwnerEntityAI;
import org.jurassicraft.server.entity.ai.DefendOwnerEntityAI;
import org.jurassicraft.server.entity.ai.DinosaurAttackMeleeEntityAI;
import org.jurassicraft.server.entity.ai.DinosaurLookHelper;
import org.jurassicraft.server.entity.ai.DinosaurWanderEntityAI;
import org.jurassicraft.server.entity.ai.FleeEntityAI;
import org.jurassicraft.server.entity.ai.FollowOwnerEntityAI;
import org.jurassicraft.server.entity.ai.Herd;
import org.jurassicraft.server.entity.ai.MateEntityAI;
import org.jurassicraft.server.entity.ai.ProtectInfantEntityAI;
import org.jurassicraft.server.entity.ai.RespondToAttackEntityAI;
import org.jurassicraft.server.entity.ai.SelectTargetEntityAI;
import org.jurassicraft.server.entity.ai.SleepEntityAI;
import org.jurassicraft.server.entity.ai.TargetCarcassEntityAI;
import org.jurassicraft.server.entity.ai.TemptNonAdultEntityAI;
import org.jurassicraft.server.entity.ai.animations.CallAnimationAI;
import org.jurassicraft.server.entity.ai.animations.HeadCockAnimationAI;
import org.jurassicraft.server.entity.ai.animations.LookAnimationAI;
import org.jurassicraft.server.entity.ai.animations.RoarAnimationAI;
import org.jurassicraft.server.entity.ai.metabolism.DrinkEntityAI;
import org.jurassicraft.server.entity.ai.metabolism.EatFoodItemEntityAI;
import org.jurassicraft.server.entity.ai.metabolism.FeederEntityAI;
import org.jurassicraft.server.entity.ai.metabolism.GrazeEntityAI;
import org.jurassicraft.server.food.FoodHelper;
import org.jurassicraft.server.genetics.GeneticsHelper;
import org.jurassicraft.server.item.ItemHandler;
import org.jurassicraft.server.message.SetOrderMessage;
import org.jurassicraft.server.util.GameRuleHandler;
import org.jurassicraft.server.util.LangHelper;

public abstract class DinosaurEntity
extends EntityCreature
implements IEntityAdditionalSpawnData,
IAnimatedEntity {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final DataParameter<Boolean> WATCHER_IS_CARCASS = EntityDataManager.func_187226_a(DinosaurEntity.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> WATCHER_AGE = EntityDataManager.func_187226_a(DinosaurEntity.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> WATCHER_IS_SLEEPING = EntityDataManager.func_187226_a(DinosaurEntity.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> WATCHER_HAS_TRACKER = EntityDataManager.func_187226_a(DinosaurEntity.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<String> WATCHER_OWNER = EntityDataManager.func_187226_a(DinosaurEntity.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Order> WATCHER_ORDER = EntityDataManager.func_187226_a(DinosaurEntity.class, DinosaurSerializers.ORDER);
    private static final DataParameter<Boolean> WATCHER_IS_RUNNING = EntityDataManager.func_187226_a(DinosaurEntity.class, (DataSerializer)DataSerializers.field_187198_h);
    private final InventoryDinosaur inventory;
    private final MetabolismContainer metabolism;
    protected Dinosaur dinosaur;
    protected int dinosaurAge;
    protected int prevAge;
    protected EntityAITasks animationTasks;
    protected Order order = Order.WANDER;
    private int growthSpeedOffset;
    private boolean isCarcass;
    private int carcassHealth;
    private String genetics;
    private int geneticsQuality;
    private boolean isMale;
    private boolean hasTracker;
    private UUID owner;
    private boolean isSleeping;
    private int stayAwakeTime;
    private boolean useInertialTweens;
    private List<Class<? extends EntityLivingBase>> attackTargets = new ArrayList<Class<? extends EntityLivingBase>>();
    private int attackCooldown;
    @SideOnly(value=Side.CLIENT)
    public ChainBuffer tailBuffer;
    public Herd herd;
    private boolean isSittingNaturally;
    private Animation animation;
    private int animationTick;
    private int animationLength;
    private DinosaurLookHelper lookHelper;

    public DinosaurEntity(World world) {
        super(world);
        this.setFullyGrown();
        this.updateAttributes();
        this.lookHelper = new DinosaurLookHelper(this);
        this.metabolism = new MetabolismContainer(this);
        this.inventory = new InventoryDinosaur(this);
        this.genetics = GeneticsHelper.randomGenetics(this.field_70146_Z);
        this.isMale = this.field_70146_Z.nextBoolean();
        this.resetAttackCooldown();
        this.animationTick = 0;
        this.setAnimation(DinosaurAnimation.IDLE.get());
        this.setUseInertialTweens(true);
        this.animationTasks = new EntityAITasks(world.field_72984_F);
        if (!this.dinosaur.isMarineAnimal()) {
            this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AdvancedSwimEntityAI(this));
        }
        if (this.dinosaur.getDiet().isHerbivorous()) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new GrazeEntityAI(this));
        }
        if (this.dinosaur.getDiet().isCarnivorous()) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new TargetCarcassEntityAI(this));
        }
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new RespondToAttackEntityAI(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new TemptNonAdultEntityAI(this, 0.6));
        if (this.dinosaur.shouldDefendOwner()) {
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new DefendOwnerEntityAI(this));
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AssistOwnerEntityAI(this));
        }
        if (this.dinosaur.shouldFlee()) {
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new FleeEntityAI(this));
        }
        this.field_70714_bg.func_75776_a(2, new ProtectInfantEntityAI<DinosaurEntity>(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new DinosaurWanderEntityAI(this, 0.8f, 20));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new FollowOwnerEntityAI(this));
        this.field_70714_bg.func_75776_a(3, this.getAttackAI());
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 6.0f));
        this.animationTasks.func_75776_a(0, (EntityAIBase)new SleepEntityAI(this));
        this.animationTasks.func_75776_a(1, (EntityAIBase)new DrinkEntityAI(this));
        this.animationTasks.func_75776_a(1, (EntityAIBase)new MateEntityAI(this));
        this.animationTasks.func_75776_a(1, (EntityAIBase)new EatFoodItemEntityAI(this));
        this.animationTasks.func_75776_a(1, (EntityAIBase)new FeederEntityAI(this));
        this.animationTasks.func_75776_a(3, (EntityAIBase)new CallAnimationAI(this));
        this.animationTasks.func_75776_a(3, (EntityAIBase)new RoarAnimationAI(this));
        this.animationTasks.func_75776_a(3, (EntityAIBase)new LookAnimationAI(this));
        this.animationTasks.func_75776_a(3, (EntityAIBase)new HeadCockAnimationAI(this));
        if (world.field_72995_K) {
            this.initClient();
        }
        this.field_70158_ak = true;
    }

    public EntityLookHelper func_70671_ap() {
        return this.lookHelper;
    }

    private void initClient() {
        this.tailBuffer = new ChainBuffer();
    }

    public boolean shouldSleep() {
        return this.getDinosaurTime() > this.getDinosaur().getSleepingSchedule().getAwakeTime() && !this.hasPredators() && !this.metabolism.isDehydrated() && !this.metabolism.isStarving() && (this.herd == null || this.herd.enemies.size() <= 0);
    }

    private boolean hasPredators() {
        for (EntityLiving predator : this.getEntitiesWithinDistance(EntityLiving.class, 10.0, 5.0)) {
            DinosaurEntity dinosaur;
            boolean hasDinosaurPredator = false;
            if (predator instanceof DinosaurEntity && (!(dinosaur = (DinosaurEntity)predator).isCarcass() || dinosaur.isSleeping)) {
                for (Class<? extends EntityLivingBase> target : dinosaur.getAttackTargets()) {
                    if (!target.isAssignableFrom(((Object)((Object)this)).getClass())) continue;
                    hasDinosaurPredator = true;
                    break;
                }
            }
            if (this.func_110144_aD() != predator && predator.func_70638_az() != this && !hasDinosaurPredator) continue;
            return true;
        }
        return false;
    }

    private <T extends Entity> List<T> getEntitiesWithinDistance(Class<T> entity, double width, double height) {
        List entities = this.field_70170_p.func_72872_a(entity, new AxisAlignedBB(this.field_70165_t - width, this.field_70163_u - height, this.field_70161_v - width, this.field_70165_t + width, this.field_70163_u + height, this.field_70161_v + width));
        entities.remove((Object)this);
        return entities;
    }

    public int getDinosaurTime() {
        SleepingSchedule sleepingSchedule = this.getDinosaur().getSleepingSchedule();
        long time = this.field_70170_p.func_72820_D() % 24000L - (long)sleepingSchedule.getWakeUpTime();
        if (time < 0L) {
            time += 24000L;
        }
        return (int)time;
    }

    public boolean hasTracker() {
        return this.hasTracker;
    }

    public void setHasTracker(boolean hasTracker) {
        this.hasTracker = hasTracker;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(EntityPlayer player) {
        if (this.dinosaur.isImprintable()) {
            UUID prevOwner = this.owner;
            this.owner = player.func_110124_au();
            if (!this.owner.equals(prevOwner)) {
                player.func_146105_b((ITextComponent)new TextComponentString(new LangHelper("message.tame.name").withProperty("dinosaur", "entity.jurassicraft." + this.dinosaur.getName().toLowerCase(Locale.ENGLISH) + ".name").build()));
            }
        }
    }

    public boolean func_70652_k(Entity entity) {
        if (entity instanceof DinosaurEntity && ((DinosaurEntity)entity).isCarcass()) {
            this.setAnimation(DinosaurAnimation.EATING.get());
        } else {
            this.setAnimation(DinosaurAnimation.ATTACKING.get());
        }
        while (entity.func_184187_bx() != null) {
            entity = entity.func_184187_bx();
        }
        float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        if (entity.func_70097_a((DamageSource)new DinosaurDamageSource("mob", (Entity)this), damage)) {
            if (entity instanceof DinosaurEntity && ((DinosaurEntity)entity).isCarcass()) {
                DinosaurEntity dinosaur = (DinosaurEntity)entity;
                if (dinosaur.herd != null && this.herd != null && dinosaur.herd.fleeing && dinosaur.herd.enemies.contains((Object)this)) {
                    this.herd.enemies.removeAll(dinosaur.herd.members);
                    for (DinosaurEntity member : this.herd) {
                        if (member.func_70638_az() == null || !dinosaur.herd.members.contains(member.func_70638_az())) continue;
                        member.func_70624_b(null);
                    }
                    this.herd.state = Herd.State.STATIC;
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_70097_a(DamageSource damageSource, float amount) {
        boolean canHarmInCreative = damageSource.func_76357_e();
        if (!this.isCarcass()) {
            if (this.func_110143_aJ() - amount <= 0.0f) {
                if (!canHarmInCreative) {
                    this.func_70606_j(this.func_110138_aP());
                    this.setCarcass(true);
                    return true;
                }
                return super.func_70097_a(damageSource, amount);
            }
            if (this.getAnimation() == DinosaurAnimation.RESTING.get()) {
                this.setAnimation(DinosaurAnimation.IDLE.get());
                this.isSittingNaturally = false;
            }
            if (!this.field_70170_p.field_72995_K && this.getAnimation() == DinosaurAnimation.IDLE.get()) {
                this.setAnimation(DinosaurAnimation.INJURED.get());
            }
            if (this.shouldSleep()) {
                this.disturbSleep();
            }
            return super.func_70097_a(damageSource, amount);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (canHarmInCreative) {
                return super.func_70097_a(damageSource, amount);
            }
            if ((float)this.field_70172_ad <= (float)this.field_70771_an / 2.0f) {
                this.field_70738_aO = 10;
                this.field_70737_aN = 10;
            }
            if (damageSource != DamageSource.field_76369_e) {
                --this.carcassHealth;
                if (!this.field_70729_aU && this.carcassHealth >= 0 && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                    this.dropMeat(damageSource.func_76346_g());
                }
                if (this.carcassHealth < 0) {
                    this.func_70645_a(damageSource);
                    this.func_70106_y();
                }
            }
        }
        return false;
    }

    private void dropMeat(Entity attacker) {
        int fortune = 0;
        if (attacker instanceof EntityLivingBase) {
            fortune = EnchantmentHelper.func_185283_h((EntityLivingBase)((EntityLivingBase)attacker));
        }
        int count = this.field_70146_Z.nextInt(2) + 1 + fortune;
        boolean burning = this.func_70027_ad();
        for (int i = 0; i < count; ++i) {
            int meta = EntityHandler.getDinosaurId(this.dinosaur);
            if (burning) {
                this.func_70099_a(new ItemStack((Item)ItemHandler.DINOSAUR_STEAK, 1, meta), 0.0f);
                continue;
            }
            this.dropStackWithGenetics(new ItemStack((Item)ItemHandler.DINOSAUR_MEAT, 1, meta));
        }
    }

    public boolean func_70104_M() {
        return super.func_70104_M() && !this.isCarcass() && !this.isSleeping();
    }

    public EntityItem func_70099_a(ItemStack stack, float offsetY) {
        if (stack.field_77994_a != 0 && stack.func_77973_b() != null) {
            Random rand = new Random();
            EntityItem item = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(rand.nextFloat() * this.field_70130_N - this.field_70130_N / 2.0f), this.field_70163_u + (double)offsetY, this.field_70161_v + (double)(rand.nextFloat() * this.field_70130_N - this.field_70130_N / 2.0f), stack);
            item.func_174869_p();
            if (this.captureDrops) {
                this.capturedDrops.add(item);
            } else {
                this.field_70170_p.func_72838_d((Entity)item);
            }
            return item;
        }
        return null;
    }

    public void func_70653_a(Entity entity, float p_70653_2_, double motionX, double motionZ) {
        if (this.field_70146_Z.nextDouble() >= this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e()) {
            this.field_70160_al = true;
            float distance = MathHelper.func_76133_a((double)(motionX * motionX + motionZ * motionZ));
            float multiplier = 0.4f;
            this.field_70159_w /= 2.0;
            this.field_70179_y /= 2.0;
            this.field_70159_w -= motionX / (double)distance * (double)multiplier;
            this.field_70179_y -= motionZ / (double)distance * (double)multiplier;
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (this.herd != null) {
            if (this.herd.leader == this) {
                this.herd.updateLeader();
            }
            this.herd.members.remove((Object)this);
        }
        if (cause.func_76364_f() instanceof EntityLivingBase) {
            this.respondToAttack((EntityLivingBase)cause.func_76364_f());
        }
    }

    public void func_70642_aH() {
        if (this.getAnimation() == DinosaurAnimation.IDLE.get()) {
            this.setAnimation(DinosaurAnimation.SPEAK.get());
            super.func_70642_aH();
        }
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(WATCHER_IS_CARCASS, (Object)this.isCarcass);
        this.field_70180_af.func_187214_a(WATCHER_AGE, (Object)this.dinosaurAge);
        this.field_70180_af.func_187214_a(WATCHER_IS_SLEEPING, (Object)this.isSleeping);
        this.field_70180_af.func_187214_a(WATCHER_HAS_TRACKER, (Object)this.hasTracker);
        this.field_70180_af.func_187214_a(WATCHER_OWNER, (Object)"");
        this.field_70180_af.func_187214_a(WATCHER_ORDER, (Object)Order.WANDER);
        this.field_70180_af.func_187214_a(WATCHER_IS_RUNNING, (Object)false);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.dinosaur = EntityHandler.getDinosaurByClass(((Object)((Object)this)).getClass());
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.updateAttributes();
        this.updateBounds();
    }

    public void updateAttributes() {
        double prevHealth = this.func_110138_aP();
        double newHealth = this.interpolate(this.dinosaur.getBabyHealth(), this.dinosaur.getAdultHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(newHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.interpolate(this.dinosaur.getBabySpeed(), this.dinosaur.getAdultSpeed()));
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.interpolate(this.dinosaur.getBabyStrength(), this.dinosaur.getAdultStrength()));
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
        if (prevHealth != newHealth) {
            this.func_70691_i((float)(newHealth - (double)this.field_110153_bc));
        }
    }

    private void updateBounds() {
        float width = Math.min(5.0f, (float)this.interpolate(this.dinosaur.getBabySizeX(), this.dinosaur.getAdultSizeX()));
        float height = (float)this.interpolate(this.dinosaur.getBabySizeY(), this.dinosaur.getAdultSizeY());
        this.field_70138_W = Math.max(1.0f, (float)(Math.ceil(height / 2.0f) / 2.0));
        if (this.isCarcass) {
            this.func_70105_a(Math.min(5.0f, height), width);
        } else {
            this.func_70105_a(width, height);
        }
    }

    public double interpolate(double baby, double adult) {
        int dinosaurAge = this.dinosaurAge;
        int maxAge = this.dinosaur.getMaximumAge();
        if (dinosaurAge > maxAge) {
            dinosaurAge = maxAge;
        }
        return (adult - baby) / (double)maxAge * (double)dinosaurAge + baby;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return true;
    }

    public void setupActionFigure(boolean isMale) {
        this.setFullyGrown();
        this.setMale(isMale);
        this.field_70173_aa = 4;
    }

    public int func_70627_aG() {
        return 200;
    }

    public float func_70647_i() {
        return (float)this.interpolate(2.5, 1.0) + (this.field_70146_Z.nextFloat() - 0.5f) * 0.125f;
    }

    public float func_70599_aP() {
        return this.isCarcass() || this.isSleeping ? 0.0f : 2.0f * (float)this.interpolate(0.2f, 1.0);
    }

    public String getGenetics() {
        return this.genetics;
    }

    public void setGenetics(String genetics) {
        this.genetics = genetics;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (!this.dinosaur.isMarineAnimal()) {
                Path path;
                if (this.func_70055_a(Material.field_151586_h)) {
                    this.func_70683_ar().func_75660_a();
                } else if (this.isSwimming() && (path = this.func_70661_as().func_75505_d()) != null) {
                    double deltaZ;
                    double deltaX;
                    PathPoint nextPoint = path.func_75877_a(Math.min(path.func_75874_d() - 1, path.func_75873_e() + 1));
                    if ((double)nextPoint.field_75837_b >= this.field_70163_u - 1.0 && (deltaX = this.field_70165_t - (double)nextPoint.field_75839_a) * deltaX + (deltaZ = this.field_70161_v - (double)nextPoint.field_75838_c) * deltaZ < 1.5) {
                        this.func_70683_ar().func_75660_a();
                    }
                }
            }
            if (this.herd == null) {
                this.herd = new Herd(this);
            }
            if (this.order == Order.WANDER) {
                if (this.herd.state == Herd.State.STATIC && this.func_70638_az() == null) {
                    if (!this.isSleeping && !this.func_70090_H() && this.getAnimation() == DinosaurAnimation.IDLE.get() && this.field_70146_Z.nextInt(400) == 0) {
                        this.setAnimation(DinosaurAnimation.RESTING.get());
                        this.isSittingNaturally = true;
                    }
                } else if (this.getAnimation() == DinosaurAnimation.RESTING.get()) {
                    this.setAnimation(DinosaurAnimation.IDLE.get());
                    this.isSittingNaturally = false;
                }
            }
            if (this == this.herd.leader) {
                this.herd.onUpdate();
            }
        }
        if (!this.isCarcass) {
            if (this.field_70148_d) {
                this.updateAttributes();
            }
            this.updateGrowth();
            if (!this.field_70170_p.field_72995_K) {
                if (this.metabolism.isHungry()) {
                    List entitiesWithinAABB = this.field_70170_p.func_72872_a(EntityItem.class, this.func_174813_aQ().func_72314_b(1.0, 1.0, 1.0));
                    for (EntityItem itemEntity : entitiesWithinAABB) {
                        Item item = itemEntity.func_92059_d().func_77973_b();
                        if (!FoodHelper.isEdible(this.dinosaur.getDiet(), item)) continue;
                        this.setAnimation(DinosaurAnimation.EATING.get());
                        if (itemEntity.func_92059_d().field_77994_a > 1) {
                            --itemEntity.func_92059_d().field_77994_a;
                        } else {
                            itemEntity.func_70106_y();
                        }
                        this.getMetabolism().eat(FoodHelper.getHealAmount(item));
                        FoodHelper.applyEatEffects(this, item);
                        this.func_70691_i(10.0f);
                        break;
                    }
                }
                this.metabolism.update();
            }
            if (this.field_70173_aa % 62 == 0) {
                this.func_184185_a(this.getBreathingSound(), this.func_70599_aP(), this.func_70647_i());
            }
        }
        if (this.func_70613_aW()) {
            this.lookHelper.func_75649_a();
        }
    }

    private void updateGrowth() {
        if (!this.field_70128_L && this.field_70173_aa % 8 == 0 && !this.field_70170_p.field_72995_K) {
            if (GameRuleHandler.DINO_GROWTH.getBoolean(this.field_70170_p)) {
                this.dinosaurAge += Math.min(this.growthSpeedOffset, 960) + 1;
                this.metabolism.decreaseEnergy((int)((double)(Math.min(this.growthSpeedOffset, 960) + 1) * 0.1));
            }
            if (this.growthSpeedOffset > 0) {
                this.growthSpeedOffset -= 10;
                if (this.growthSpeedOffset < 0) {
                    this.growthSpeedOffset = 0;
                }
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (this.animation != null && this.animation != DinosaurAnimation.IDLE.get()) {
            boolean shouldHold = DinosaurAnimation.getAnimation(this.animation).shouldHold();
            if (this.animationTick < this.animationLength) {
                ++this.animationTick;
            } else if (!shouldHold) {
                this.animationTick = 0;
                this.setAnimation(DinosaurAnimation.IDLE.get());
            } else {
                this.animationTick = this.animationLength - 1;
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(WATCHER_AGE, (Object)this.dinosaurAge);
            this.field_70180_af.func_187227_b(WATCHER_IS_SLEEPING, (Object)this.isSleeping);
            this.field_70180_af.func_187227_b(WATCHER_IS_CARCASS, (Object)this.isCarcass);
            this.field_70180_af.func_187227_b(WATCHER_HAS_TRACKER, (Object)this.hasTracker);
            this.field_70180_af.func_187227_b(WATCHER_ORDER, (Object)this.order);
            this.field_70180_af.func_187227_b(WATCHER_OWNER, (Object)(this.owner != null ? this.owner.toString() : ""));
            this.field_70180_af.func_187227_b(WATCHER_IS_RUNNING, (Object)((double)this.func_70689_ay() > this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() ? 1 : 0));
        } else {
            this.updateTailBuffer();
            this.dinosaurAge = (Integer)this.field_70180_af.func_187225_a(WATCHER_AGE);
            this.isSleeping = (Boolean)this.field_70180_af.func_187225_a(WATCHER_IS_SLEEPING);
            this.isCarcass = (Boolean)this.field_70180_af.func_187225_a(WATCHER_IS_CARCASS);
            this.hasTracker = (Boolean)this.field_70180_af.func_187225_a(WATCHER_HAS_TRACKER);
            this.order = (Order)((Object)this.field_70180_af.func_187225_a(WATCHER_ORDER));
            String owner = (String)this.field_70180_af.func_187225_a(WATCHER_OWNER);
            if (!(owner.length() <= 0 || this.owner != null && owner.equals(this.owner.toString()))) {
                this.owner = UUID.fromString(owner);
            } else if (owner.length() == 0) {
                this.owner = null;
            }
        }
        if (this.field_70173_aa % 16 == 0) {
            this.updateAttributes();
            this.updateBounds();
        }
        if (this.isCarcass) {
            this.field_70761_aq = this.field_70177_z;
            this.field_70759_as = this.field_70177_z;
        }
        if (this.isSleeping) {
            if (this.getAnimation() != DinosaurAnimation.SLEEPING.get()) {
                this.setAnimation(DinosaurAnimation.SLEEPING.get());
            }
        } else if (this.getAnimation() == DinosaurAnimation.SLEEPING.get()) {
            this.setAnimation(DinosaurAnimation.IDLE.get());
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.isCarcass) {
                if (this.getAnimation() != DinosaurAnimation.DYING.get()) {
                    this.setAnimation(DinosaurAnimation.DYING.get());
                }
                if (this.field_70173_aa % 1000 == 0) {
                    this.func_70097_a(DamageSource.field_76377_j, 1.0f);
                }
            } else {
                if (this.isSleeping) {
                    if (this.field_70173_aa % 20 == 0 && this.stayAwakeTime <= 0 && this.hasPredators()) {
                        this.disturbSleep();
                    }
                    if (!this.shouldSleep() && !this.field_70170_p.field_72995_K) {
                        this.isSleeping = false;
                    }
                } else if (this.getAnimation() == DinosaurAnimation.SLEEPING.get()) {
                    this.setAnimation(DinosaurAnimation.IDLE.get());
                }
                if (!this.isSleeping) {
                    if (this.order == Order.SIT) {
                        if (this.getAnimation() != DinosaurAnimation.RESTING.get()) {
                            this.setAnimation(DinosaurAnimation.RESTING.get());
                        }
                    } else if (!this.isSittingNaturally && this.getAnimation() == DinosaurAnimation.RESTING.get()) {
                        this.setAnimation(DinosaurAnimation.IDLE.get());
                    }
                }
            }
        }
        if (!this.shouldSleep() && !this.isSleeping) {
            this.stayAwakeTime = 0;
        }
        if (this.func_70613_aW()) {
            this.animationTasks.func_75774_a();
        }
        if (this.stayAwakeTime > 0) {
            --this.stayAwakeTime;
        }
        this.prevAge = this.dinosaurAge;
    }

    private void updateTailBuffer() {
        this.tailBuffer.calculateChainSwingBuffer(68.0f, 5, 4.0f, (EntityLivingBase)this);
    }

    public boolean func_70610_aX() {
        return this.isCarcass() || this.isSleeping() || this.animation != null && DinosaurAnimation.getAnimation(this.animation).doesBlockMovement();
    }

    public int getDaysExisted() {
        return (int)Math.floor((float)this.dinosaurAge * 8.0f / 24000.0f);
    }

    public void setFullyGrown() {
        this.setAge(this.dinosaur.getMaximumAge());
    }

    public Dinosaur getDinosaur() {
        return this.dinosaur;
    }

    public boolean func_70692_ba() {
        return false;
    }

    public int getDinosaurAge() {
        return this.dinosaurAge;
    }

    public void setAge(int age) {
        this.dinosaurAge = age;
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(WATCHER_AGE, (Object)this.dinosaurAge);
        }
    }

    public float func_70047_e() {
        return (float)this.interpolate(this.dinosaur.getBabyEyeHeight(), this.dinosaur.getAdultEyeHeight());
    }

    protected void func_70628_a(boolean playerAttack, int looting) {
        for (String bone : this.dinosaur.getBones()) {
            if (this.field_70146_Z.nextInt(10) == 0) continue;
            this.dropStackWithGenetics(new ItemStack((Item)ItemHandler.FRESH_FOSSILS.get(bone), 1, EntityHandler.getDinosaurId(this.dinosaur)));
        }
    }

    private void dropStackWithGenetics(ItemStack stack) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("DNAQuality", this.geneticsQuality);
        nbt.func_74778_a("Genetics", this.genetics);
        stack.func_77982_d(nbt);
        this.func_70099_a(stack, 0.0f);
    }

    public boolean isCarcass() {
        return this.isCarcass;
    }

    public void setCarcass(boolean carcass) {
        this.isCarcass = carcass;
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(WATCHER_IS_CARCASS, (Object)this.isCarcass);
        }
        if (carcass) {
            this.setAnimation(DinosaurAnimation.DYING.get());
            this.carcassHealth = (int)Math.sqrt(this.field_70130_N * this.field_70131_O) * 2;
            this.field_70173_aa = 0;
            this.inventory.dropItems(this.field_70170_p, this.field_70146_Z);
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand, ItemStack stack) {
        if (player.func_70093_af() && hand == EnumHand.MAIN_HAND) {
            if (this.isOwner(player)) {
                if (this.getAgePercentage() > 75) {
                    player.func_71007_a((IInventory)this.inventory);
                } else if (this.field_70170_p.field_72995_K) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("message.too_young.name", new Object[0]));
                }
            } else if (this.field_70170_p.field_72995_K) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("message.not_owned.name", new Object[0]));
            }
        } else if (stack == null && hand == EnumHand.MAIN_HAND && this.field_70170_p.field_72995_K) {
            if (this.isOwner(player)) {
                JurassiCraft.PROXY.openOrderGui(this);
            } else {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("message.not_owned.name", new Object[0]));
            }
        } else if (stack != null && this.metabolism.isHungry() && FoodHelper.isEdible(this.dinosaur.getDiet(), stack.func_77973_b())) {
            if (this.isOwner(player) && !this.field_70170_p.field_72995_K) {
                Item item = stack.func_77973_b();
                this.metabolism.eat(FoodHelper.getHealAmount(item));
                FoodHelper.applyEatEffects(this, item);
                --stack.field_77994_a;
            } else if (this.field_70170_p.field_72995_K) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("message.not_owned.name", new Object[0]));
            }
        }
        return false;
    }

    public boolean isOwner(EntityPlayer player) {
        return player.func_110124_au().equals(this.getOwner());
    }

    public boolean func_184652_a(EntityPlayer player) {
        return !this.func_110167_bD() && (double)this.field_70130_N < 1.5;
    }

    public int getDNAQuality() {
        return this.geneticsQuality;
    }

    public void setDNAQuality(int quality) {
        this.geneticsQuality = quality;
    }

    public Animation[] getAnimations() {
        return DinosaurAnimation.getAnimations();
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public void setAnimation(Animation newAnimation) {
        if (this.isSleeping()) {
            newAnimation = DinosaurAnimation.SLEEPING.get();
        }
        if (this.isCarcass()) {
            newAnimation = DinosaurAnimation.DYING.get();
        }
        Animation oldAnimation = this.animation;
        this.animation = newAnimation;
        if (oldAnimation != newAnimation) {
            this.animationTick = 0;
            this.animationLength = (int)this.dinosaur.getPoseHandler().getAnimationLength(this.animation, this.getGrowthStage());
            AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, newAnimation);
        }
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public SoundEvent func_184639_G() {
        return this.getSoundForAnimation(DinosaurAnimation.SPEAK.get());
    }

    public SoundEvent func_184601_bQ() {
        return this.getSoundForAnimation(DinosaurAnimation.INJURED.get());
    }

    public SoundEvent func_184615_bR() {
        return this.getSoundForAnimation(DinosaurAnimation.DYING.get());
    }

    public SoundEvent getSoundForAnimation(Animation animation) {
        return null;
    }

    public SoundEvent getBreathingSound() {
        return null;
    }

    public double getAttackDamage() {
        return this.interpolate(this.dinosaur.getBabyStrength(), this.dinosaur.getAdultStrength());
    }

    public boolean isMale() {
        return this.isMale;
    }

    public void setMale(boolean male) {
        this.isMale = male;
    }

    public int getAgePercentage() {
        int age = this.getDinosaurAge();
        return age != 0 ? age * 100 / this.getDinosaur().getMaximumAge() : 0;
    }

    public GrowthStage getGrowthStage() {
        int percent = this.getAgePercentage();
        return percent > 75 ? GrowthStage.ADULT : (percent > 50 ? GrowthStage.ADOLESCENT : (percent > 25 ? GrowthStage.JUVENILE : GrowthStage.INFANT));
    }

    public void increaseGrowthSpeed() {
        this.growthSpeedOffset += 240;
    }

    public boolean isSwimming() {
        return (this.func_70090_H() || this.func_180799_ab()) && !this.field_70122_E;
    }

    public NBTTagCompound func_189511_e(NBTTagCompound nbt) {
        nbt = super.func_189511_e(nbt);
        nbt.func_74768_a("DinosaurAge", this.dinosaurAge);
        nbt.func_74757_a("IsCarcass", this.isCarcass);
        nbt.func_74768_a("DNAQuality", this.geneticsQuality);
        nbt.func_74778_a("Genetics", this.genetics);
        nbt.func_74757_a("IsMale", this.isMale);
        nbt.func_74768_a("GrowthSpeedOffset", this.growthSpeedOffset);
        nbt.func_74768_a("StayAwakeTime", this.stayAwakeTime);
        nbt.func_74757_a("IsSleeping", this.isSleeping);
        nbt.func_74774_a("Order", (byte)this.order.ordinal());
        nbt.func_74768_a("CarcassHealth", this.carcassHealth);
        this.metabolism.writeToNBT(nbt);
        if (this.owner != null) {
            nbt.func_74778_a("OwnerUUID", this.owner.toString());
        }
        this.inventory.writeToNBT(nbt);
        return nbt;
    }

    public void func_70020_e(NBTTagCompound nbt) {
        super.func_70020_e(nbt);
        this.setAge(nbt.func_74762_e("DinosaurAge"));
        this.setCarcass(nbt.func_74767_n("IsCarcass"));
        this.geneticsQuality = nbt.func_74762_e("DNAQuality");
        this.genetics = nbt.func_74779_i("Genetics");
        this.isMale = nbt.func_74767_n("IsMale");
        this.growthSpeedOffset = nbt.func_74762_e("GrowthSpeedOffset");
        this.stayAwakeTime = nbt.func_74762_e("StayAwakeTime");
        this.setSleeping(nbt.func_74767_n("IsSleeping"));
        this.carcassHealth = nbt.func_74762_e("CarcassHealth");
        this.order = Order.values()[nbt.func_74771_c("Order")];
        this.metabolism.readFromNBT(nbt);
        String ownerUUID = nbt.func_74779_i("OwnerUUID");
        if (ownerUUID.length() > 0) {
            this.owner = UUID.fromString(ownerUUID);
        }
        this.inventory.readFromNBT(nbt);
        this.updateAttributes();
        this.updateBounds();
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.dinosaurAge);
        buffer.writeBoolean(this.isCarcass);
        buffer.writeInt(this.geneticsQuality);
        buffer.writeBoolean(this.isMale);
        buffer.writeInt(this.growthSpeedOffset);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.dinosaurAge = additionalData.readInt();
        this.isCarcass = additionalData.readBoolean();
        this.geneticsQuality = additionalData.readInt();
        this.isMale = additionalData.readBoolean();
        this.growthSpeedOffset = additionalData.readInt();
        if (this.isCarcass) {
            this.setAnimation(DinosaurAnimation.DYING.get());
        }
        this.updateAttributes();
        this.updateBounds();
    }

    public MetabolismContainer getMetabolism() {
        return this.metabolism;
    }

    public boolean setSleepLocation(BlockPos sleepLocation, boolean moveTo) {
        return !moveTo || this.func_70661_as().func_75492_a((double)sleepLocation.func_177958_n(), (double)sleepLocation.func_177956_o(), (double)sleepLocation.func_177952_p(), 1.0);
    }

    public boolean isSleeping() {
        return this.isSleeping;
    }

    public void setSleeping(boolean sleeping) {
        this.isSleeping = sleeping;
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(WATCHER_IS_SLEEPING, (Object)this.isSleeping);
        }
    }

    public int getStayAwakeTime() {
        return this.stayAwakeTime;
    }

    public void disturbSleep() {
        this.isSleeping = false;
        this.stayAwakeTime = 400;
    }

    public void writeStatsToLog() {
        LOGGER.info((Object)this);
    }

    public String toString() {
        return "DinosaurEntity{ " + this.dinosaur.getName() + ", id=" + this.func_145782_y() + ", remote=" + this.func_130014_f_().field_72995_K + ", isDead=" + this.field_70128_L + ", isCarcass=" + this.isCarcass + ", isSleeping=" + this.isSleeping + ", stayAwakeTime=" + this.stayAwakeTime + "\n    " + ", dinosaurAge=" + this.dinosaurAge + ", prevAge=" + this.prevAge + ", maxAge" + this.dinosaur.getMaximumAge() + ", ticksExisted=" + this.field_70173_aa + ", entityAge=" + this.field_70708_bq + ", isMale=" + this.isMale + ", growthSpeedOffset=" + this.growthSpeedOffset + "\n    " + ", food=" + this.metabolism.getEnergy() + " / " + this.metabolism.getMaxEnergy() + " (" + (double)this.metabolism.getMaxEnergy() * 0.875 + ")" + ", water=" + this.metabolism.getWater() + " / " + this.metabolism.getMaxWater() + " (" + (double)this.metabolism.getMaxWater() * 0.875 + ")" + ", digestingFood=" + this.metabolism.getDigestingFood() + " / " + 3000 + ", health=" + this.func_110143_aJ() + " / " + this.func_110138_aP() + "\n    " + ", pos=" + this.func_180425_c() + ", eyePos=" + this.getHeadPos() + ", eyeHeight=" + this.func_70047_e() + ", lookX=" + this.func_70671_ap().func_180423_e() + ", lookY=" + this.func_70671_ap().func_180422_f() + ", lookZ=" + this.func_70671_ap().func_180421_g() + "\n    " + ", width=" + this.field_70130_N + ", bb=" + this.func_174813_aQ() + " }";
    }

    public Vec3d getHeadPos() {
        double scale = this.interpolate(this.dinosaur.getScaleInfant(), this.dinosaur.getScaleAdult());
        double[] headPos = this.dinosaur.getHeadPosition(this.getGrowthStage(), (360.0f - this.field_70759_as) % 360.0f - 180.0f);
        double headX = (headPos[0] * 0.0625 - (double)this.dinosaur.getOffsetX()) * scale;
        double headY = ((24.0 - headPos[1]) * 0.0625 - (double)this.dinosaur.getOffsetY()) * scale;
        double headZ = (headPos[2] * 0.0625 - (double)this.dinosaur.getOffsetZ()) * scale;
        return new Vec3d(this.field_70165_t + headX, this.field_70163_u + headY, this.field_70161_v + headZ);
    }

    public boolean areEyelidsClosed() {
        return this.isCarcass || this.isSleeping || this.field_70173_aa % 100 < 4;
    }

    public boolean getUseInertialTweens() {
        return this.useInertialTweens;
    }

    public void setUseInertialTweens(boolean parUseInertialTweens) {
        this.useInertialTweens = parUseInertialTweens;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((Item)ItemHandler.SPAWN_EGG, 1, EntityHandler.getDinosaurId(this.dinosaur));
    }

    public void func_82167_n(Entity entity) {
        super.func_82167_n(entity);
        if (this.isSleeping && !this.func_184223_x(entity) && !entity.field_70145_X && !this.field_70145_X && entity.getClass() != ((Object)((Object)this)).getClass()) {
            this.disturbSleep();
        }
    }

    protected void func_70105_a(float width, float height) {
        if (width != this.field_70130_N || height != this.field_70131_O) {
            float prevWidth = this.field_70130_N;
            this.field_70130_N = width;
            this.field_70131_O = height;
            AxisAlignedBB bounds = this.func_174813_aQ();
            this.func_174826_a(new AxisAlignedBB(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72339_c, bounds.field_72340_a + (double)this.field_70130_N, bounds.field_72338_b + (double)this.field_70131_O, bounds.field_72339_c + (double)this.field_70130_N));
            if (this.field_70130_N > prevWidth && !this.field_70148_d && !this.field_70170_p.field_72995_K) {
                this.func_70091_d(prevWidth - this.field_70130_N, 0.0, prevWidth - this.field_70130_N);
            }
        }
    }

    public Order getOrder() {
        return this.order;
    }

    public void setOrder(Order order) {
        this.order = order;
        if (this.field_70170_p.field_72995_K) {
            EntityPlayer player;
            if (this.owner != null && (player = this.field_70170_p.func_152378_a(this.owner)) != null) {
                player.func_146105_b((ITextComponent)new TextComponentString(new LangHelper("message.set_order.name").withProperty("order", "order." + order.name().toLowerCase(Locale.ENGLISH) + ".name").build()));
            }
            JurassiCraft.NETWORK_WRAPPER.sendToServer((IMessage)new SetOrderMessage(this));
        }
    }

    @SafeVarargs
    public final void target(Class<? extends EntityLivingBase> ... targets) {
        for (Class<? extends EntityLivingBase> target : targets) {
            this.field_70715_bh.func_75776_a(1, new SelectTargetEntityAI<EntityLivingBase>(this, target));
        }
        this.attackTargets.addAll(Lists.newArrayList((Object[])targets));
    }

    public EntityAIBase getAttackAI() {
        return new DinosaurAttackMeleeEntityAI(this, this.dinosaur.getAttackSpeed(), false);
    }

    public List<Class<? extends EntityLivingBase>> getAttackTargets() {
        return this.attackTargets;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData data) {
        this.metabolism.setEnergy(this.metabolism.getMaxEnergy());
        this.metabolism.setWater(this.metabolism.getMaxWater());
        this.genetics = GeneticsHelper.randomGenetics(this.field_70146_Z);
        this.setFullyGrown();
        this.setMale(this.field_70146_Z.nextBoolean());
        this.setDNAQuality(100);
        return data;
    }

    public int getAttackCooldown() {
        return this.attackCooldown;
    }

    public void resetAttackCooldown() {
        this.attackCooldown = 100 + this.func_70681_au().nextInt(20);
    }

    public void respondToAttack(EntityLivingBase attacker) {
        if (!(attacker == null || attacker.field_70128_L || attacker instanceof EntityPlayer && ((EntityPlayer)attacker).field_71075_bZ.field_75098_d)) {
            LinkedList<EntityLivingBase> enemies = new LinkedList<EntityLivingBase>();
            if (attacker instanceof DinosaurEntity) {
                DinosaurEntity enemyDinosaur = (DinosaurEntity)attacker;
                if (enemyDinosaur.herd != null) {
                    enemies.addAll(enemyDinosaur.herd.members);
                }
            } else {
                enemies.add(attacker);
            }
            if (enemies.size() > 0) {
                Herd herd = this.herd;
                if (herd != null) {
                    herd.fleeing = !herd.shouldDefend(enemies) || this.dinosaur.shouldFlee();
                    for (EntityLivingBase entity : enemies) {
                        if (herd.enemies.contains(entity)) continue;
                        herd.enemies.add(entity);
                    }
                } else {
                    this.func_70624_b((EntityLivingBase)enemies.get(this.func_70681_au().nextInt(enemies.size())));
                }
            }
        }
    }

    public int getAnimationLength() {
        return this.animationLength;
    }

    public boolean isRunning() {
        return (Boolean)this.field_70180_af.func_187225_a(WATCHER_IS_RUNNING);
    }

    public BlockPos getClosestFeeder() {
        int posX = (int)this.field_70165_t;
        int posY = (int)this.field_70163_u;
        int posZ = (int)this.field_70161_v;
        int closestDist = Integer.MAX_VALUE;
        BlockPos closestPos = null;
        int range = 16;
        for (int x = posX - range; x < posX + range; ++x) {
            for (int y = posY - 8; y < posY + 8; ++y) {
                for (int z = posZ - range; z < posZ + range; ++z) {
                    int deltaZ;
                    int deltaY;
                    int deltaX;
                    int distance;
                    FeederBlockEntity feeder;
                    BlockPos pos;
                    TileEntity tile;
                    if (y <= 0 || y >= this.field_70170_p.func_72800_K() || !((tile = this.field_70170_p.func_175625_s(pos = new BlockPos(x, y, z))) instanceof FeederBlockEntity) || !(feeder = (FeederBlockEntity)tile).canFeedDinosaur(this.dinosaur) || feeder.getFeeding() != null || feeder.openAnimation != 0 || (distance = (deltaX = Math.abs(posX - x)) * deltaX + (deltaY = Math.abs(posY - y)) * deltaY + (deltaZ = Math.abs(posZ - z)) * deltaZ) >= closestDist) continue;
                    closestDist = distance;
                    closestPos = pos;
                }
            }
        }
        return closestPos;
    }

    public static enum Order {
        WANDER,
        FOLLOW,
        SIT;

    }

    public static class FieldGuideInfo {
        public int hunger;
        public int thirst;
        public boolean flocking;
        public boolean scared;
        public boolean hungry;
        public boolean thirsty;
        public boolean poisoned;

        public static FieldGuideInfo deserialize(ByteBuf buf) {
            FieldGuideInfo info = new FieldGuideInfo();
            info.flocking = buf.readBoolean();
            info.scared = buf.readBoolean();
            info.hunger = buf.readInt();
            info.thirst = buf.readInt();
            info.hungry = buf.readBoolean();
            info.thirsty = buf.readBoolean();
            info.poisoned = buf.readBoolean();
            return info;
        }

        public static FieldGuideInfo serialize(ByteBuf buf, DinosaurEntity entity) {
            MetabolismContainer metabolism = entity.getMetabolism();
            Herd herd = entity.herd;
            FieldGuideInfo info = new FieldGuideInfo();
            info.flocking = herd != null && herd.members.size() > 1 && herd.state == Herd.State.MOVING;
            info.scared = herd != null && herd.fleeing;
            info.hunger = metabolism.getEnergy();
            info.thirst = metabolism.getWater();
            info.hungry = metabolism.isHungry();
            info.thirsty = metabolism.isThirsty();
            info.poisoned = entity.func_70644_a(Potion.func_180142_b((String)"poison"));
            buf.writeBoolean(info.flocking);
            buf.writeBoolean(info.scared);
            buf.writeInt(info.hunger);
            buf.writeInt(info.thirst);
            buf.writeBoolean(info.hungry);
            buf.writeBoolean(info.thirsty);
            buf.writeBoolean(info.poisoned);
            return info;
        }
    }
}

