/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block.plant;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jurassicraft.server.block.plant.AncientPlantBlock;

public class DoublePlantBlock
extends AncientPlantBlock {
    public static final PropertyEnum HALF = PropertyEnum.func_177709_a((String)"half", BlockHalf.class);
    private static final AxisAlignedBB BOUNDS = new AxisAlignedBB((double)0.1f, 0.0, (double)0.1f, (double)0.9f, 1.0, (double)0.9f);

    public DoublePlantBlock(Material material) {
        super(material);
        this.func_149711_c(0.0f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDS;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return super.func_176196_c(world, pos) && world.func_175623_d(pos.func_177984_a());
    }

    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c() != this;
    }

    protected void func_176475_e(World world, BlockPos pos, IBlockState state) {
        if (!this.func_180671_f(world, pos, state)) {
            DoublePlantBlock bottomBlock;
            boolean upperPart = state.func_177229_b((IProperty)HALF) == BlockHalf.UPPER;
            BlockPos top = upperPart ? pos : pos.func_177984_a();
            BlockPos bottom = upperPart ? pos.func_177977_b() : pos;
            DoublePlantBlock topBlock = upperPart ? this : world.func_180495_p(top).func_177230_c();
            DoublePlantBlock doublePlantBlock = bottomBlock = upperPart ? world.func_180495_p(bottom).func_177230_c() : this;
            if (!upperPart) {
                this.func_176226_b(world, pos, state, 0);
            }
            if (topBlock == this) {
                world.func_180501_a(top, Blocks.field_150350_a.func_176223_P(), 3);
            }
            if (bottomBlock == this) {
                world.func_180501_a(bottom, Blocks.field_150350_a.func_176223_P(), 3);
            }
        }
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() != this) {
            return super.func_180671_f(world, pos, state);
        }
        if (state.func_177229_b((IProperty)HALF) == BlockHalf.UPPER) {
            return world.func_180495_p(pos.func_177977_b()).func_177230_c() == this;
        }
        IBlockState up = world.func_180495_p(pos.func_177984_a());
        return up.func_177230_c() == this && super.func_180671_f(world, pos, up);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (state.func_177229_b((IProperty)HALF) == BlockHalf.UPPER) {
            return null;
        }
        return super.func_180660_a(state, rand, fortune);
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)HALF, (Comparable)((Object)BlockHalf.LOWER)), 2);
        worldIn.func_180501_a(pos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)HALF, (Comparable)((Object)BlockHalf.UPPER)), 2);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (state.func_177229_b((IProperty)HALF) == BlockHalf.UPPER) {
            if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
                if (!player.field_71075_bZ.field_75098_d) {
                    IBlockState lowerBlock = world.func_180495_p(pos.func_177977_b());
                    if (lowerBlock.func_177230_c() == this) {
                        world.func_175655_b(pos.func_177977_b(), true);
                    }
                } else {
                    world.func_175698_g(pos.func_177977_b());
                }
            }
        } else if (player.field_71075_bZ.field_75098_d && world.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
            world.func_180501_a(pos.func_177984_a(), Blocks.field_150350_a.func_176223_P(), 2);
        }
        super.func_176208_a(world, pos, state, player);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)HALF, (Comparable)((Object)BlockHalf.values()[meta]));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state;
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockHalf)((Object)state.func_177229_b((IProperty)HALF))).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HALF});
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (state.func_177230_c() == this && state.func_177229_b((IProperty)HALF) == BlockHalf.LOWER && world.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
            world.func_175698_g(pos.func_177984_a());
        }
        return world.func_175698_g(pos);
    }

    @Override
    protected void spread(World world, BlockPos position) {
        world.func_175656_a(position, this.func_176223_P().func_177226_a((IProperty)HALF, (Comparable)((Object)BlockHalf.LOWER)));
        world.func_175656_a(position.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)HALF, (Comparable)((Object)BlockHalf.UPPER)));
    }

    @Override
    protected boolean canPlace(IBlockState down, IBlockState here, IBlockState up) {
        return super.canPlace(down, here, up) && up.func_177230_c() == Blocks.field_150350_a;
    }

    public static enum BlockHalf implements IStringSerializable
    {
        UPPER,
        LOWER;


        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this == UPPER ? "upper" : "lower";
        }
    }
}

