/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block.entity;

import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import org.jurassicraft.server.api.SynthesizableItem;
import org.jurassicraft.server.block.entity.MachineBaseBlockEntity;
import org.jurassicraft.server.container.DNASynthesizerContainer;
import org.jurassicraft.server.item.ItemHandler;

public class DNASynthesizerBlockEntity
extends MachineBaseBlockEntity {
    private static final int[] INPUTS = new int[]{0, 1, 2};
    private static final int[] OUTPUTS = new int[]{3, 4, 5, 6};
    private ItemStack[] slots = new ItemStack[7];

    @Override
    protected int getProcess(int slot) {
        return 0;
    }

    @Override
    protected boolean canProcess(int process) {
        ItemStack storage = this.slots[0];
        ItemStack testTube = this.slots[1];
        ItemStack baseMaterial = this.slots[2];
        SynthesizableItem synthesizableItem = SynthesizableItem.getSynthesizableItem(storage);
        if (synthesizableItem != null && synthesizableItem.isSynthesizable(storage) && testTube != null && testTube.func_77973_b() == ItemHandler.EMPTY_TEST_TUBE && baseMaterial != null && baseMaterial.func_77973_b() == ItemHandler.DNA_NUCLEOTIDES && storage.func_77978_p() != null && storage.func_77978_p().func_74764_b("DNAQuality")) {
            ItemStack output = synthesizableItem.getSynthesizedItem(storage, new Random(0L));
            return output != null && this.hasOutputSlot(output);
        }
        return false;
    }

    @Override
    protected void processItem(int process) {
        ItemStack storageDisc = this.slots[0];
        ItemStack output = SynthesizableItem.getSynthesizableItem(storageDisc).getSynthesizedItem(storageDisc, new Random());
        int emptySlot = this.getOutputSlot(output);
        if (emptySlot != -1) {
            this.mergeStack(emptySlot, output);
            this.decreaseStackSize(1);
            this.decreaseStackSize(2);
        }
    }

    @Override
    protected int getMainOutput(int process) {
        return 1;
    }

    @Override
    protected int getStackProcessTime(ItemStack stack) {
        return 1000;
    }

    @Override
    protected int getProcessCount() {
        return 1;
    }

    @Override
    protected int[] getInputs() {
        return INPUTS;
    }

    @Override
    protected int[] getInputs(int process) {
        return this.getInputs();
    }

    @Override
    protected int[] getOutputs() {
        return OUTPUTS;
    }

    @Override
    protected ItemStack[] getSlots() {
        return this.slots;
    }

    @Override
    protected void setSlots(ItemStack[] slots) {
        this.slots = slots;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new DNASynthesizerContainer(playerInventory, (TileEntity)this);
    }

    public String func_174875_k() {
        return "jurassicraft:dna_synthesizer";
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.dna_synthesizer";
    }
}

