/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block;

import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.world.Explosion;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.server.api.CleanableItem;
import org.jurassicraft.server.api.SubBlocksBlock;
import org.jurassicraft.server.block.BlockHandler;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.item.ItemHandler;
import org.jurassicraft.server.item.block.EncasedFossilItemBlock;
import org.jurassicraft.server.tab.TabHandler;

public class EncasedFossilBlock
extends Block
implements SubBlocksBlock,
CleanableItem {
    public static final PropertyInteger VARIANT = PropertyInteger.func_177719_a((String)"variant", (int)0, (int)15);
    private int start;

    public EncasedFossilBlock(int start) {
        super(Material.field_151576_e);
        this.func_149711_c(2.0f);
        this.func_149752_b(8.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(TabHandler.FOSSILS);
        this.start = start;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(0)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)VARIANT);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, this.func_176201_c(state));
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        Map<Integer, Dinosaur> dinosaurs = EntityHandler.getDinosaurs();
        for (int i = 0; i < 16; ++i) {
            Dinosaur dinosaur = dinosaurs.get(i + this.start);
            if (dinosaur == null || !dinosaur.shouldRegister()) continue;
            list.add(new ItemStack((Block)this, 1, i));
        }
    }

    public Dinosaur getDinosaur(int metadata) {
        return EntityHandler.getDinosaurById(this.start + metadata);
    }

    @Override
    public ItemBlock getItemBlock() {
        return new EncasedFossilItemBlock(this);
    }

    public String getHarvestTool(IBlockState state) {
        return "pickaxe";
    }

    public int getHarvestLevel(IBlockState state) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public boolean func_149662_c(IBlockState state) {
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return true;
    }

    public boolean func_149659_a(Explosion explosion) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    public boolean isCleanable(ItemStack stack) {
        return true;
    }

    @Override
    public ItemStack getCleanedItem(ItemStack stack, Random random) {
        int dinosaurId = BlockHandler.getDinosaurId((EncasedFossilBlock)Block.func_149634_a((Item)stack.func_77973_b()), stack.func_77952_i());
        String[] bones = EntityHandler.getDinosaurById(dinosaurId).getBones();
        return new ItemStack((Item)ItemHandler.FOSSILS.get(bones[random.nextInt(bones.length)]), 1, dinosaurId);
    }
}

