/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.render.entity;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.client.render.entity.dinosaur.DinosaurRenderInfo;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.entity.GrowthStage;

@SideOnly(value=Side.CLIENT)
public class DinosaurRenderer
extends RenderLiving<DinosaurEntity> {
    public Dinosaur dinosaur;
    public DinosaurRenderInfo renderInfo;
    public Random random;

    public DinosaurRenderer(DinosaurRenderInfo renderInfo, RenderManager renderManager) {
        super(renderManager, renderInfo.getModel(GrowthStage.INFANT), renderInfo.getShadowSize());
        this.dinosaur = renderInfo.getDinosaur();
        this.random = new Random();
        this.renderInfo = renderInfo;
        this.func_177094_a(new LayerEyelid(this));
    }

    public void preRenderCallback(DinosaurEntity entity, float partialTick) {
        String name;
        float scale = (float)entity.interpolate(this.dinosaur.getScaleInfant(), this.dinosaur.getScaleAdult());
        this.field_76989_e = scale * this.renderInfo.getShadowSize();
        GlStateManager.func_179109_b((float)(this.dinosaur.getOffsetX() * scale), (float)(this.dinosaur.getOffsetY() * scale), (float)(this.dinosaur.getOffsetZ() * scale));
        switch (name = entity.func_95999_t()) {
            case "iLexiconn": 
            case "JTGhawk137": {
                GlStateManager.func_179152_a((float)0.1f, (float)scale, (float)scale);
                break;
            }
            case "Gegy": {
                int ticksExisted = entity.field_70173_aa / 25 + entity.func_145782_y();
                int colorTypes = EnumDyeColor.values().length;
                int k = ticksExisted % colorTypes;
                int l = (ticksExisted + 1) % colorTypes;
                float time = ((float)(entity.field_70173_aa % 25) + 2.0f) / 25.0f;
                float[] colors = EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.func_176764_b((int)k));
                float[] colors2 = EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.func_176764_b((int)l));
                GlStateManager.func_179124_c((float)(colors[0] * (1.0f - time) + colors2[0] * time), (float)(colors[1] * (1.0f - time) + colors2[1] * time), (float)(colors[2] * (1.0f - time) + colors2[2] * time));
                if (time > 0.5f) {
                    time = 1.0f - time;
                }
                GlStateManager.func_179152_a((float)(scale * (0.5f + time * 0.5f)), (float)(scale * (1.0f + time * 0.5f)), (float)(scale * (0.9f + time * 0.25f)));
                break;
            }
            case "Notch": 
            case "Jumbo": {
                GlStateManager.func_179152_a((float)(scale * 2.0f), (float)(scale * 2.0f), (float)(scale * 2.0f));
                break;
            }
            case "jglrxavpok": {
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)(scale * -1.0f));
                break;
            }
            default: {
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            }
        }
    }

    public void doRender(DinosaurEntity entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.field_77045_g = this.renderInfo.getModel(entity.getGrowthStage());
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
    }

    public ResourceLocation getEntityTexture(DinosaurEntity entity) {
        GrowthStage growthStage = entity.getGrowthStage();
        if (!this.dinosaur.doesSupportGrowthStage(growthStage)) {
            growthStage = GrowthStage.ADULT;
        }
        return entity.isMale() ? this.dinosaur.getMaleTexture(growthStage) : this.dinosaur.getFemaleTexture(growthStage);
    }

    protected void rotateCorpse(DinosaurEntity entity, float p_77043_2_, float p_77043_3_, float partialTicks) {
        GlStateManager.func_179114_b((float)(180.0f - p_77043_3_), (float)0.0f, (float)1.0f, (float)0.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public class LayerEyelid
    implements LayerRenderer<DinosaurEntity> {
        private final DinosaurRenderer renderer;

        public LayerEyelid(DinosaurRenderer renderer) {
            this.renderer = renderer;
        }

        public void doRenderLayer(DinosaurEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float age, float yaw, float pitch, float scale) {
            ITextureObject textureObject;
            ResourceLocation texture;
            if (!entity.func_82150_aj() && (texture = this.renderer.dinosaur.getEyelidTexture(entity)) != null && entity.areEyelidsClosed() && (textureObject = Minecraft.func_71410_x().func_110434_K().func_110581_b(texture)) != TextureUtil.field_111001_a) {
                this.renderer.func_110776_a(texture);
                this.renderer.func_177087_b().func_78088_a((Entity)entity, limbSwing, limbSwingAmount, age, yaw, pitch, scale);
                this.renderer.func_177105_a((EntityLiving)entity, partialTicks);
            }
        }

        public boolean func_177142_b() {
            return true;
        }
    }
}

