/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.model.animation;

import java.util.EnumMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.ilexiconn.llibrary.client.model.tabula.ITabulaModelAnimator;
import net.ilexiconn.llibrary.client.model.tabula.TabulaModel;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.client.model.DinosaurModel;
import org.jurassicraft.client.model.animation.JabelarAnimationHandler;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.entity.GrowthStage;

@SideOnly(value=Side.CLIENT)
public abstract class DinosaurAnimator<ENTITY extends DinosaurEntity>
implements ITabulaModelAnimator<ENTITY> {
    protected EnumMap<GrowthStage, Map<DinosaurEntity, JabelarAnimationHandler>> animationHandlers = new EnumMap(GrowthStage.class);

    private JabelarAnimationHandler getAnimationHelper(DinosaurEntity entity, DinosaurModel model, boolean useInertialTweens) {
        JabelarAnimationHandler render;
        GrowthStage growth = entity.getGrowthStage();
        Map<DinosaurEntity, JabelarAnimationHandler> growthToRender = this.animationHandlers.get((Object)growth);
        if (growthToRender == null) {
            growthToRender = new WeakHashMap<DinosaurEntity, JabelarAnimationHandler>();
            this.animationHandlers.put(growth, growthToRender);
        }
        if ((render = growthToRender.get((Object)entity)) == null) {
            render = entity.getDinosaur().getPoseHandler().createAnimationHandler(entity, model, growth, useInertialTweens);
            growthToRender.put(entity, render);
        }
        return render;
    }

    public final void setRotationAngles(TabulaModel model, ENTITY entity, float limbSwing, float limbSwingAmount, float ticks, float rotationYaw, float rotationPitch, float scale) {
        this.getAnimationHelper((DinosaurEntity)((Object)entity), (DinosaurModel)model, ((DinosaurEntity)((Object)entity)).getUseInertialTweens()).performAnimations((DinosaurEntity)((Object)entity), limbSwing, limbSwingAmount, ticks);
        this.performAnimations((DinosaurModel)model, entity, limbSwing, limbSwingAmount, ticks, rotationYaw, rotationPitch, scale);
    }

    protected void performAnimations(DinosaurModel parModel, ENTITY entity, float limbSwing, float limbSwingAmount, float ticks, float rotationYaw, float rotationPitch, float scale) {
    }
}

