/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.server.config.entry;

import net.ilexiconn.llibrary.server.config.ConfigEntry;
import net.ilexiconn.llibrary.server.config.entry.IEntryAdapter;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public enum EntryAdapters implements IEntryAdapter
{
    INTEGER{

        public Object getValue(Configuration config, String name, ConfigEntry entry, Object defaultValue) {
            int minInt = entry.minValue().isEmpty() ? Integer.MIN_VALUE : Integer.parseInt(entry.minValue());
            int maxInt = entry.maxValue().isEmpty() ? Integer.MAX_VALUE : Integer.parseInt(entry.maxValue());
            return config.getInt(name, entry.category(), ((Integer)defaultValue).intValue(), minInt, maxInt, entry.comment());
        }
    }
    ,
    BOOLEAN{

        public Object getValue(Configuration config, String name, ConfigEntry entry, Object defaultValue) {
            return config.getBoolean(name, entry.category(), ((Boolean)defaultValue).booleanValue(), entry.comment());
        }
    }
    ,
    STRING{

        public Object getValue(Configuration config, String name, ConfigEntry entry, Object defaultValue) {
            return config.getString(name, entry.category(), (String)defaultValue, entry.comment());
        }
    }
    ,
    FLOAT{

        public Object getValue(Configuration config, String name, ConfigEntry entry, Object defaultValue) {
            float minFloat = entry.minValue().isEmpty() ? Float.MIN_VALUE : Float.parseFloat(entry.minValue());
            float maxFloat = entry.maxValue().isEmpty() ? Float.MAX_VALUE : Float.parseFloat(entry.maxValue());
            return Float.valueOf(config.getFloat(name, entry.category(), ((Float)defaultValue).floatValue(), minFloat, maxFloat, entry.comment()));
        }
    }
    ,
    DOUBLE{

        public Object getValue(Configuration config, String name, ConfigEntry entry, Object defaultValue) {
            double minDouble = entry.minValue().isEmpty() ? Double.MIN_VALUE : Double.parseDouble(entry.minValue());
            double maxDouble = entry.maxValue().isEmpty() ? Double.MAX_VALUE : Double.parseDouble(entry.maxValue());
            Property property = config.get(entry.category(), name, Double.toString((Double)defaultValue), name);
            property.comment = entry.comment() + " [range: " + minDouble + " ~ " + maxDouble + ", default: " + defaultValue + "]";
            property.setMinValue(minDouble);
            property.setMaxValue(maxDouble);
            try {
                return Double.parseDouble(property.getString()) < minDouble ? minDouble : (Double.parseDouble(property.getString()) > maxDouble ? maxDouble : Double.parseDouble(property.getString()));
            }
            catch (Exception e) {
                e.printStackTrace();
                return defaultValue;
            }
        }
    }
    ,
    INT_ARRAY{

        public Object getValue(Configuration config, String name, ConfigEntry entry, Object defaultValue) {
            Property property = config.get(entry.category(), name, (int[])defaultValue);
            property.setValidValues(entry.validValues());
            property.comment = entry.comment() + " [default: " + property.getDefault() + "]";
            return property.getIntList();
        }
    }
    ,
    BOOLEAN_ARRAY{

        public Object getValue(Configuration config, String name, ConfigEntry entry, Object defaultValue) {
            Property property = config.get(entry.category(), name, (boolean[])defaultValue);
            property.setValidValues(entry.validValues());
            property.comment = entry.comment() + " [default: " + property.getDefault() + "]";
            return property.getBooleanList();
        }
    }
    ,
    STRING_ARRAY{

        public Object getValue(Configuration config, String name, ConfigEntry entry, Object defaultValue) {
            return config.getStringList(name, entry.category(), (String[])defaultValue, entry.comment());
        }
    }
    ,
    FLOAT_ARRAY{

        public Object getValue(Configuration config, String name, ConfigEntry entry, Object defaultValue) {
            float[] floatArray = (float[])defaultValue;
            double[] doubleArray = new double[floatArray.length];
            for (int i = 0; i < doubleArray.length; ++i) {
                doubleArray[i] = floatArray[i];
            }
            Property property = config.get(entry.category(), name, doubleArray);
            property.setValidValues(entry.validValues());
            property.comment = entry.comment() + " [default: " + property.getDefault() + "]";
            doubleArray = property.getDoubleList();
            floatArray = new float[doubleArray.length];
            for (int i = 0; i < doubleArray.length; ++i) {
                floatArray[i] = (float)doubleArray[i];
            }
            return floatArray;
        }
    }
    ,
    DOUBLE_ARRAY{

        public Object getValue(Configuration config, String name, ConfigEntry entry, Object defaultValue) {
            Property property = config.get(entry.category(), name, (double[])defaultValue);
            property.setValidValues(entry.validValues());
            property.comment = entry.comment() + " [default: " + property.getDefault() + "]";
            return property.getDoubleList();
        }
    };


    public static <T> IEntryAdapter<T> getBuiltinAdapter(Class<T> type) {
        if (Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type)) {
            return INTEGER;
        }
        if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
            return BOOLEAN;
        }
        if (String.class.isAssignableFrom(type)) {
            return STRING;
        }
        if (Float.class.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type)) {
            return FLOAT;
        }
        if (Double.class.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type)) {
            return DOUBLE;
        }
        if (Integer[].class.isAssignableFrom(type) || int[].class.isAssignableFrom(type)) {
            return INT_ARRAY;
        }
        if (Boolean[].class.isAssignableFrom(type) || boolean[].class.isAssignableFrom(type)) {
            return BOOLEAN_ARRAY;
        }
        if (String[].class.isAssignableFrom(type)) {
            return STRING_ARRAY;
        }
        if (Float[].class.isAssignableFrom(type) || float[].class.isAssignableFrom(type)) {
            return FLOAT_ARRAY;
        }
        if (Double[].class.isAssignableFrom(type) || double[].class.isAssignableFrom(type)) {
            return DOUBLE_ARRAY;
        }
        return null;
    }
}

