/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.server.config;

import com.google.common.collect.SetMultimap;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.discovery.ASMDataTable;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.server.config.Config;
import net.ilexiconn.llibrary.server.config.ConfigEntry;
import net.ilexiconn.llibrary.server.config.entry.EntryAdapters;
import net.ilexiconn.llibrary.server.config.entry.IEntryAdapter;
import net.ilexiconn.llibrary.server.util.Tuple3;
import net.minecraft.crash.CrashReport;
import net.minecraftforge.common.config.Configuration;

public enum ConfigHandler {
    INSTANCE;

    private List<Tuple3<String, Configuration, Object>> configList = new ArrayList<Tuple3<String, Configuration, Object>>();
    private Map<String, Map<String, IEntryAdapter<?>>> valueTypeMap = new HashMap();
    private Map<String, Map<String, Object>> defaultValueMap = new HashMap<String, Map<String, Object>>();
    private Map<Class<?>, IEntryAdapter<?>> entryAdapterMap = new HashMap();

    public <T> void registerEntryAdapter(Class<T> entryClass, IEntryAdapter<T> entryAdapter) {
        this.entryAdapterMap.put(entryClass, entryAdapter);
    }

    @Deprecated
    public <T> T registerConfig(Object mod, File file, T config) {
        return config;
    }

    public boolean hasConfigForID(String modid) {
        boolean[] result = new boolean[1];
        this.configList.stream().filter(tuple -> ((String)tuple.getA()).equals(modid)).forEach(tuple -> {
            result[0] = true;
        });
        return result[0];
    }

    public Configuration getConfigForID(String modid) {
        Configuration[] result = new Configuration[]{null};
        this.configList.stream().filter(tuple -> ((String)tuple.getA()).equals(modid)).forEach(tuple -> {
            result[0] = (Configuration)tuple.getB();
        });
        return result[0];
    }

    public Object getObjectForID(String modid) {
        Object[] result = new Object[]{null};
        this.configList.stream().filter(tuple -> ((String)tuple.getA()).equals(modid)).forEach(tuple -> {
            result[0] = tuple.getC();
        });
        return result[0];
    }

    public void saveConfigForID(String modid) {
        Object object = this.getObjectForID(modid);
        Configuration config = this.getConfigForID(modid);
        Map<String, IEntryAdapter<?>> typeMap = this.valueTypeMap.get(modid);
        Map<String, Object> valueMap = this.defaultValueMap.get(modid);
        Arrays.stream(object.getClass().getFields()).filter(field -> field.isAnnotationPresent(ConfigEntry.class)).forEach(field -> {
            try {
                String name;
                IEntryAdapter entryAdapter;
                ConfigEntry configEntry = field.getAnnotation(ConfigEntry.class);
                if ((configEntry.side().isServer() || FMLCommonHandler.instance().getEffectiveSide().isClient()) && (entryAdapter = (IEntryAdapter)typeMap.get(name = configEntry.name().isEmpty() ? field.getName() : configEntry.name())) != null) {
                    field.set(object, entryAdapter.getValue(config, name, configEntry, valueMap.get(name)));
                }
            }
            catch (IllegalAccessException e) {
                LLibrary.LOGGER.error(CrashReport.func_85055_a((Throwable)e, (String)("Failed to set config value " + field.getName() + " for mod " + modid)).func_71502_e());
            }
        });
        config.save();
    }

    public void injectConfig(ModContainer mod, ASMDataTable data) {
        SetMultimap annotations = data.getAnnotationsFor(mod);
        if (annotations != null) {
            Set targetList = annotations.get((Object)Config.class.getName());
            ClassLoader classLoader = Loader.instance().getModClassLoader();
            for (ASMDataTable.ASMData target : targetList) {
                try {
                    Class<?> targetClass = Class.forName(target.getClassName(), true, classLoader);
                    Field field = targetClass.getDeclaredField(target.getObjectName());
                    field.setAccessible(true);
                    Class<?> configClass = field.getType();
                    File configFile = new File(".", "config" + File.separator + mod.getModId() + ".cfg");
                    field.set(null, INSTANCE.registerConfig(mod, configFile, configClass.newInstance()));
                }
                catch (Exception e) {
                    LLibrary.LOGGER.fatal("Failed to inject config for mod container " + mod, (Throwable)e);
                }
            }
        }
    }

    private <T> T registerConfig(ModContainer mod, File file, T config) {
        this.configList.add(new Tuple3<String, Configuration, T>(mod.getModId(), new Configuration(file), config));
        HashMap typeMap = new HashMap();
        HashMap valueMap = new HashMap();
        Arrays.stream(config.getClass().getFields()).filter(field -> field.isAnnotationPresent(ConfigEntry.class)).forEach(field -> {
            try {
                ConfigEntry configEntry = field.getAnnotation(ConfigEntry.class);
                if (configEntry.side().isServer() || FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                    String name = configEntry.name().isEmpty() ? field.getName() : configEntry.name();
                    IEntryAdapter<?> entryAdapter = EntryAdapters.getBuiltinAdapter(field.getType());
                    if (entryAdapter == null) {
                        entryAdapter = this.entryAdapterMap.get(field.getType());
                    }
                    if (entryAdapter != null) {
                        field.setAccessible(true);
                        typeMap.put(name, entryAdapter);
                        valueMap.put(name, field.get(config));
                    } else {
                        LLibrary.LOGGER.error("Found unsupported config entry " + field.getName() + " for mod " + mod.getName());
                    }
                }
            }
            catch (IllegalAccessException e) {
                LLibrary.LOGGER.error(CrashReport.func_85055_a((Throwable)e, (String)("Failed to get config value " + field.getName() + " for mod " + mod.getName())).func_71502_e());
            }
        });
        this.valueTypeMap.put(mod.getModId(), typeMap);
        this.defaultValueMap.put(mod.getModId(), valueMap);
        this.saveConfigForID(mod.getModId());
        return config;
    }
}

