/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.model.tools;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class Model3DTexture
extends ModelBox {
    private int width;
    private int height;
    private float u1;
    private float v1;
    private float u2;
    private float v2;

    public Model3DTexture(ModelRenderer model, int textureOffsetX, int textureOffsetY, float posX, float posY, float posZ, int width, int height) {
        super(model, 0, 0, posX, posY, posZ, 0, 0, 0, 0.0f);
        this.width = width;
        this.height = height;
        this.u1 = (float)textureOffsetX / model.field_78801_a;
        this.v1 = (float)textureOffsetY / model.field_78799_b;
        this.u2 = (float)(textureOffsetX + width) / model.field_78801_a;
        this.v2 = (float)(textureOffsetY + height) / model.field_78799_b;
    }

    public Model3DTexture(ModelRenderer model, int textureOffsetX, int textureOffsetY, int width, int height) {
        this(model, textureOffsetX, textureOffsetY, 0.0f, 0.0f, 0.0f, width, height);
    }

    public void func_78245_a(Tessellator tessellator, float scale) {
        float f9;
        float f8;
        float f7;
        int k;
        GL11.glPushMatrix();
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)(this.field_78252_a * scale), (float)(this.field_78250_b * scale), (float)(this.field_78251_c * scale));
        GL11.glScalef((float)((float)this.width / 16.0f), (float)((float)this.height / 16.0f), (float)1.0f);
        float depth = 0.0625f;
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        tessellator.func_78374_a(0.0, 0.0, 0.0, (double)this.u1, (double)this.v2);
        tessellator.func_78374_a(1.0, 0.0, 0.0, (double)this.u2, (double)this.v2);
        tessellator.func_78374_a(1.0, 1.0, 0.0, (double)this.u2, (double)this.v1);
        tessellator.func_78374_a(0.0, 1.0, 0.0, (double)this.u1, (double)this.v1);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        tessellator.func_78374_a(0.0, 1.0, (double)(0.0f - depth), (double)this.u1, (double)this.v1);
        tessellator.func_78374_a(1.0, 1.0, (double)(0.0f - depth), (double)this.u2, (double)this.v1);
        tessellator.func_78374_a(1.0, 0.0, (double)(0.0f - depth), (double)this.u2, (double)this.v2);
        tessellator.func_78374_a(0.0, 0.0, (double)(0.0f - depth), (double)this.u1, (double)this.v2);
        tessellator.func_78381_a();
        float f5 = 0.5f * (this.u1 - this.u2) / (float)this.width;
        float f6 = 0.5f * (this.v2 - this.v1) / (float)this.height;
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        for (k = 0; k < this.width; ++k) {
            f7 = (float)k / (float)this.width;
            f8 = this.u1 + (this.u2 - this.u1) * f7 - f5;
            tessellator.func_78374_a((double)f7, 0.0, (double)(0.0f - depth), (double)f8, (double)this.v2);
            tessellator.func_78374_a((double)f7, 0.0, 0.0, (double)f8, (double)this.v2);
            tessellator.func_78374_a((double)f7, 1.0, 0.0, (double)f8, (double)this.v1);
            tessellator.func_78374_a((double)f7, 1.0, (double)(0.0f - depth), (double)f8, (double)this.v1);
        }
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        for (k = 0; k < this.width; ++k) {
            f7 = (float)k / (float)this.width;
            f8 = this.u1 + (this.u2 - this.u1) * f7 - f5;
            f9 = f7 + 1.0f / (float)this.width;
            tessellator.func_78374_a((double)f9, 1.0, (double)(0.0f - depth), (double)f8, (double)this.v1);
            tessellator.func_78374_a((double)f9, 1.0, 0.0, (double)f8, (double)this.v1);
            tessellator.func_78374_a((double)f9, 0.0, 0.0, (double)f8, (double)this.v2);
            tessellator.func_78374_a((double)f9, 0.0, (double)(0.0f - depth), (double)f8, (double)this.v2);
        }
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        for (k = 0; k < this.height; ++k) {
            f7 = (float)k / (float)this.height;
            f8 = this.v2 + (this.v1 - this.v2) * f7 - f6;
            f9 = f7 + 1.0f / (float)this.height;
            tessellator.func_78374_a(0.0, (double)f9, 0.0, (double)this.u1, (double)f8);
            tessellator.func_78374_a(1.0, (double)f9, 0.0, (double)this.u2, (double)f8);
            tessellator.func_78374_a(1.0, (double)f9, (double)(0.0f - depth), (double)this.u2, (double)f8);
            tessellator.func_78374_a(0.0, (double)f9, (double)(0.0f - depth), (double)this.u1, (double)f8);
        }
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        for (k = 0; k < this.height; ++k) {
            f7 = (float)k / (float)this.height;
            f8 = this.v2 + (this.v1 - this.v2) * f7 - f6;
            tessellator.func_78374_a(1.0, (double)f7, 0.0, (double)this.u2, (double)f8);
            tessellator.func_78374_a(0.0, (double)f7, 0.0, (double)this.u1, (double)f8);
            tessellator.func_78374_a(0.0, (double)f7, (double)(0.0f - depth), (double)this.u1, (double)f8);
            tessellator.func_78374_a(1.0, (double)f7, (double)(0.0f - depth), (double)this.u2, (double)f8);
        }
        tessellator.func_78381_a();
        GL11.glPopMatrix();
    }
}

