/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.lang;

import com.google.gson.Gson;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.client.lang.RemoteLanguageContainer;
import net.minecraft.util.StringTranslate;

@SideOnly(value=Side.CLIENT)
public enum LanguageHandler {
    INSTANCE;

    private Map<String, Map<String, String>> localizations = new HashMap<String, Map<String, String>>();

    public RemoteLanguageContainer loadRemoteLocalization(String modId) throws Exception {
        InputStream in = LanguageHandler.class.getResourceAsStream("/assets/" + modId.toLowerCase() + "/lang.json");
        if (in != null) {
            return (RemoteLanguageContainer)new Gson().fromJson((Reader)new InputStreamReader(in), RemoteLanguageContainer.class);
        }
        return null;
    }

    public void load() {
        File cacheDir = new File("llibrary/lang");
        if (!cacheDir.exists()) {
            cacheDir.mkdirs();
        }
        for (File child : cacheDir.listFiles()) {
            if (!child.isFile()) continue;
            try {
                HashMap lang = StringTranslate.parseLangFile((InputStream)new FileInputStream(child));
                this.localizations.put(child.getName().split("\\.")[0], lang);
            }
            catch (Exception e) {
                LLibrary.LOGGER.error("An exception occurred while loading " + child.getName() + " from cache.", (Throwable)e);
            }
        }
        for (ModContainer modContainer : Loader.instance().getModList()) {
            String modId = modContainer.getModId();
            try {
                RemoteLanguageContainer container = this.loadRemoteLocalization(modId);
                if (container == null) continue;
                for (RemoteLanguageContainer.LangContainer language : container.languages) {
                    HashMap lang = StringTranslate.parseLangFile((InputStream)new URL(language.downloadURL).openStream());
                    String locale = language.locale;
                    if (this.localizations.containsKey(locale)) {
                        lang.putAll(this.localizations.get(locale));
                    }
                    this.localizations.put(locale, lang);
                }
            }
            catch (Exception e) {
                LLibrary.LOGGER.error("An exception occurred while loading remote lang container for " + modId, (Throwable)e);
            }
        }
        for (Map.Entry entry : this.localizations.entrySet()) {
            String language = (String)entry.getKey();
            File cache = new File(cacheDir, language + ".lang");
            try {
                if (!cache.exists()) {
                    cache.createNewFile();
                }
                PrintWriter out = new PrintWriter(new FileWriter(cache));
                for (Map.Entry langEntry : ((Map)entry.getValue()).entrySet()) {
                    out.println((String)langEntry.getKey() + "=" + (String)langEntry.getValue());
                }
                out.close();
            }
            catch (Exception e) {
                LLibrary.LOGGER.error("An exception occurred while saving cache for " + language);
            }
        }
    }

    public void addRemoteLocalizations(String language, Map<String, String> properties) {
        Map<String, String> localizationsForLang = this.localizations.get(language);
        if (localizationsForLang != null) {
            properties.putAll(localizationsForLang);
        }
    }
}

