/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.gui.element;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.function.Function;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.client.ClientProxy;
import net.ilexiconn.llibrary.client.gui.element.Element;
import net.ilexiconn.llibrary.client.gui.element.InputElement;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class SliderElement<T extends GuiScreen>
extends Element<T> {
    private Function<Float, Boolean> onEnter;
    private Function<Integer, Boolean> allowKey;
    private boolean isInteger;
    private DecimalFormat decimalFormat;
    private boolean hasSlider;
    private float sliderWidth;
    private float minValue;
    private float maxValue;
    private boolean editable = true;
    private boolean dragging;
    private InputElement value;

    public SliderElement(T gui, float posX, float posY, Function<Float, Boolean> onEnter) {
        this(gui, posX, posY, false, onEnter);
    }

    public SliderElement(T gui, float posX, float posY, boolean isInteger, Function<Float, Boolean> onEnter) {
        this(gui, posX, posY, isInteger, 0.0f, -1.0f, -1.0f, onEnter, key -> true);
    }

    public SliderElement(T gui, float posX, float posY, boolean isInteger, float sliderWidth, float minValue, float maxValue, Function<Float, Boolean> onEnter, Function<Integer, Boolean> allowKey) {
        super(gui, posX, posY, (int)(38.0f + sliderWidth), 12);
        this.onEnter = onEnter;
        this.isInteger = isInteger;
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.ENGLISH);
        symbols.setDecimalSeparator('.');
        symbols.setGroupingSeparator(',');
        this.decimalFormat = new DecimalFormat("#.#", symbols);
        this.hasSlider = sliderWidth > 0.0f;
        this.sliderWidth = sliderWidth;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.allowKey = allowKey;
    }

    @Override
    public void init() {
        this.value = (InputElement)new InputElement(this.getGUI(), "0.0", -1.0f, 0.0f, 28, true, input -> {
            float value1 = 0.0f;
            String text = input.getText();
            if (!this.isInteger) {
                if (text.endsWith("\\.")) {
                    text = text + "0";
                } else if (text.startsWith("\\.")) {
                    text = "0" + text;
                }
            }
            if (text.length() == 0) {
                text = "0";
            }
            value1 = Float.parseFloat(text);
            this.withValue(value1);
            this.onEnter.apply(Float.valueOf(value1));
        }, this.allowKey).withParent(this);
    }

    @Override
    public void render(float mouseX, float mouseY, float partialTicks) {
        float posX = this.getPosX();
        float posY = this.getPosY();
        int width = this.getWidth();
        int height = this.getHeight();
        this.drawRectangle(posX, posY, width, height, this.editable ? LLibrary.CONFIG.getSecondaryColor() : LLibrary.CONFIG.getSecondarySubcolor());
        boolean selected = this.isSelected(mouseX, mouseY);
        boolean upperSelected = this.editable && selected && mouseX >= posX + (float)width - this.sliderWidth - 11.0f && mouseY < posY + 6.0f && mouseX < posX + (float)width - this.sliderWidth;
        boolean lowerSelected = this.editable && selected && mouseX >= posX + (float)width - this.sliderWidth - 11.0f && mouseY > posY + 6.0f && mouseX < posX + (float)width - this.sliderWidth;
        this.drawRectangle(posX + (float)width - 11.0f - this.sliderWidth, posY, 11.0, 6.0, this.editable ? (upperSelected ? LLibrary.CONFIG.getDarkAccentColor() : LLibrary.CONFIG.getAccentColor()) : LLibrary.CONFIG.getTertiaryColor());
        this.drawRectangle(posX + (float)width - 11.0f - this.sliderWidth, posY + 6.0f, 11.0, 6.0, this.editable ? (lowerSelected ? LLibrary.CONFIG.getDarkAccentColor() : LLibrary.CONFIG.getAccentColor()) : LLibrary.CONFIG.getTertiaryColor());
        int textColor = LLibrary.CONFIG.getTextColor();
        this.drawRectangle(posX + (float)width - 8.0f - this.sliderWidth, posY + 4.0f, 5.0, 1.0, textColor);
        this.drawRectangle(posX + (float)width - 7.0f - this.sliderWidth, posY + 3.0f, 3.0, 1.0, textColor);
        this.drawRectangle(posX + (float)width - 6.0f - this.sliderWidth, posY + 2.0f, 1.0, 1.0, textColor);
        this.drawRectangle(posX + (float)width - 8.0f - this.sliderWidth, posY + 7.0f, 5.0, 1.0, textColor);
        this.drawRectangle(posX + (float)width - 7.0f - this.sliderWidth, posY + 8.0f, 3.0, 1.0, textColor);
        this.drawRectangle(posX + (float)width - 6.0f - this.sliderWidth, posY + 9.0f, 1.0, 1.0, textColor);
        GL11.glEnable((int)3089);
        float scaleFactor = new ScaledResolution(ClientProxy.MINECRAFT).func_78325_e();
        GL11.glScissor((int)((int)(posX * scaleFactor)), (int)((int)(((float)((GuiScreen)this.getGUI()).field_146295_m - (posY + (float)height)) * scaleFactor)), (int)((int)((float)(width - 11) * scaleFactor)), (int)((int)((float)height * scaleFactor)));
        GL11.glDisable((int)3089);
        if (this.hasSlider) {
            float offsetX = (this.sliderWidth - 4.0f) * (this.getValue() - this.minValue) / (this.maxValue - this.minValue);
            boolean indicatorSelected = this.editable && selected && mouseX >= this.getPosX() + 38.0f + offsetX && mouseX <= this.getPosX() + 38.0f + offsetX + 4.0f;
            this.drawRectangle(this.getPosX() + 38.0f + offsetX, this.getPosY(), 4.0, this.getHeight(), this.editable ? (indicatorSelected ? LLibrary.CONFIG.getDarkAccentColor() : LLibrary.CONFIG.getAccentColor()) : LLibrary.CONFIG.getTertiaryColor());
        }
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.value.setEditable(editable);
    }

    public SliderElement<T> withValue(float value) {
        this.value.clearText();
        if (this.isInteger) {
            this.value.writeText(String.valueOf((int)value));
        } else {
            this.value.writeText(String.valueOf(Float.parseFloat(this.decimalFormat.format(value)) + 0.0f));
        }
        return this;
    }

    @Override
    public boolean mouseClicked(float mouseX, float mouseY, int button) {
        boolean lowerSelected;
        if (!this.editable) {
            return super.mouseClicked(mouseX, mouseY, button);
        }
        float offsetX = (this.sliderWidth - 4.0f) * (this.getValue() - this.minValue) / (this.maxValue - this.minValue);
        boolean selected = this.isSelected(mouseX, mouseY);
        boolean indicatorSelected = selected && mouseX >= this.getPosX() + 38.0f + offsetX && mouseX <= this.getPosX() + 38.0f + offsetX + 4.0f;
        boolean upperSelected = selected && mouseX >= this.getPosX() + (float)this.getWidth() - this.sliderWidth - 11.0f && mouseY < this.getPosY() + 6.0f && mouseX < this.getPosX() + (float)this.getWidth() - this.sliderWidth;
        boolean bl = lowerSelected = selected && mouseX >= this.getPosX() + (float)this.getWidth() - this.sliderWidth - 11.0f && mouseY > this.getPosY() + 6.0f && mouseX < this.getPosX() + (float)this.getWidth() - this.sliderWidth;
        if (upperSelected) {
            float newValue;
            float f = GuiScreen.func_146272_n() ? (this.isInteger ? this.getValue() + 10.0f : this.getValue() + 1.0f) : (newValue = this.isInteger ? this.getValue() + 1.0f : this.getValue() + 0.1f);
            if ((this.maxValue == -1.0f || newValue <= this.maxValue) && this.onEnter.apply(Float.valueOf(newValue)).booleanValue()) {
                ((GuiScreen)this.getGUI()).field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                this.withValue(newValue);
                return true;
            }
        } else if (lowerSelected) {
            float newValue;
            float f = GuiScreen.func_146272_n() ? (this.isInteger ? this.getValue() - 10.0f : this.getValue() - 1.0f) : (newValue = this.isInteger ? this.getValue() - 1.0f : this.getValue() - 0.1f);
            if ((this.minValue == -1.0f || newValue >= this.minValue) && this.onEnter.apply(Float.valueOf(newValue)).booleanValue()) {
                ((GuiScreen)this.getGUI()).field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                this.withValue(newValue);
                return true;
            }
        } else if (indicatorSelected) {
            this.dragging = true;
            ((GuiScreen)this.getGUI()).field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            return true;
        }
        return false;
    }

    private float getValue() {
        return this.value.getText().length() > 0 ? Float.parseFloat(this.value.getText()) : 0.0f;
    }

    @Override
    public boolean mouseDragged(float mouseX, float mouseY, int button, long timeSinceClick) {
        float newValue;
        if (this.dragging && this.onEnter.apply(Float.valueOf(newValue = Math.max(this.minValue, Math.min(this.maxValue, (mouseX - (this.getPosX() + 38.0f)) / ((float)this.getWidth() - 38.0f - 4.0f) * (this.maxValue - this.minValue) + this.minValue)))).booleanValue()) {
            this.withValue(newValue);
            return true;
        }
        return this.dragging;
    }

    @Override
    public boolean mouseReleased(float mouseX, float mouseY, int button) {
        if (this.dragging) {
            ((GuiScreen)this.getGUI()).field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        }
        this.dragging = false;
        return false;
    }

    public InputElement getValueInput() {
        return this.value;
    }
}

