/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.gui.element;

import java.util.function.Function;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.client.gui.element.Element;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class CheckboxElement<T extends GuiScreen>
extends Element<T> {
    private boolean selected;
    private Function<CheckboxElement<T>, Boolean> function;

    public CheckboxElement(T gui, float posX, float posY) {
        this(gui, posX, posY, null);
    }

    public CheckboxElement(T gui, float posX, float posY, Function<CheckboxElement<T>, Boolean> function) {
        super(gui, posX, posY, 12, 12);
        this.function = function;
    }

    @Override
    public void render(float mouseX, float mouseY, float partialTicks) {
        if (this.isEnabled()) {
            this.drawRectangle(this.getPosX() + 1.0f, this.getPosY() + 1.0f, this.getWidth() - 1, this.getHeight() - 1, LLibrary.CONFIG.getSecondaryColor());
        } else {
            this.drawRectangle(this.getPosX() + 1.0f, this.getPosY() + 1.0f, this.getWidth() - 1, this.getHeight() - 1, LLibrary.CONFIG.getTertiaryColor());
        }
        if (this.selected) {
            this.drawRectangle(this.getPosX() + 3.0f, this.getPosY() + 3.0f, this.getWidth() - 5, this.getHeight() - 5, LLibrary.CONFIG.getTextColor());
        }
    }

    @Override
    public boolean mouseClicked(float mouseX, float mouseY, int button) {
        if (button == 0 && super.isSelected(mouseX, mouseY)) {
            boolean bl = this.selected = !this.selected;
            if (this.function != null && this.function.apply(this).booleanValue()) {
                ((GuiScreen)this.getGUI()).field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            } else {
                this.selected = !this.selected;
            }
            return true;
        }
        return false;
    }

    public CheckboxElement<T> withSelection(boolean selected) {
        this.selected = selected;
        return this;
    }

    public CheckboxElement<T> withFunction(Function<CheckboxElement<T>, Boolean> function) {
        this.function = function;
        return this;
    }

    public boolean isSelected() {
        return this.selected;
    }
}

