/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.common.tileentity.fence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.ilexiconn.jurassicraft.common.block.fence.BlockSecurityFenceHighBase;
import net.ilexiconn.jurassicraft.common.block.fence.BlockSecurityFenceHighCorner;
import net.ilexiconn.jurassicraft.common.block.fence.BlockSecurityFenceHighGrid;
import net.ilexiconn.jurassicraft.common.block.fence.BlockSecurityFenceHighPole;
import net.ilexiconn.jurassicraft.common.tileentity.fence.TileSecurityFenceHighPole;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemRedstone;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class TileSecurityFenceHighCorner
extends TileEntity
implements ISidedInventory {
    private static final int REDSTONEPERGRID = 6;
    private static final int IRONPERGRID = 3;
    private ItemStack[] slots = new ItemStack[6];
    private boolean[] builtFences = new boolean[4];
    private boolean[] fenceState = new boolean[4];
    private int plannedSide = 0;

    public TileSecurityFenceHighCorner() {
        for (int i = 0; i < this.builtFences.length; ++i) {
            this.builtFences[i] = false;
        }
    }

    public int getPlannedSide() {
        return this.plannedSide;
    }

    public void setPlannedSide(int side) {
        this.plannedSide = side;
    }

    public void setFenceAt(int side, boolean hasFenceAt) {
        this.builtFences[side] = hasFenceAt;
    }

    public boolean hasFenceAt(int side) {
        return this.builtFences[side];
    }

    public void setFenceOff(int side) {
        this.fenceState[side] = false;
    }

    public void setFenceOn(int side) {
        this.fenceState[side] = true;
    }

    public void setFenceOnOff(int side, boolean turnOnOrOff) {
        this.fenceState[side] = turnOnOrOff;
    }

    public boolean isFenceOff(int side) {
        return !this.fenceState[side];
    }

    public boolean isFenceOn(int side) {
        return this.fenceState[side];
    }

    public boolean hasIronStored() {
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null || !this.slots[i].func_77973_b().func_77658_a().equals("item.ingotIron")) continue;
            return true;
        }
        return false;
    }

    public boolean hasNumberOfIronStored(int amount) {
        int ironStored = 0;
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null || !this.slots[i].func_77973_b().func_77658_a().equals("item.ingotIron")) continue;
            ironStored += this.slots[i].field_77994_a;
        }
        return ironStored >= amount;
    }

    public void reduceIronIngots(int amount) {
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null || !this.slots[i].func_77973_b().func_77658_a().equals("item.ingotIron")) continue;
            if (this.slots[i].field_77994_a >= amount) {
                this.slots[i].field_77994_a -= amount;
                if (this.slots[i].field_77994_a >= 1) continue;
                this.slots[i] = null;
                continue;
            }
            amount -= this.slots[i].field_77994_a;
            this.slots[i] = null;
        }
    }

    public boolean hasRedstoneStored() {
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null || !(this.slots[i].func_77973_b() instanceof ItemRedstone)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNumberOfRedstoneStored(int amount) {
        int redstoneStored = 0;
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null || !(this.slots[i].func_77973_b() instanceof ItemRedstone)) continue;
            redstoneStored += this.slots[i].field_77994_a;
        }
        return redstoneStored >= amount;
    }

    public void reduceRedstone(int amount) {
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null || !(this.slots[i].func_77973_b() instanceof ItemRedstone)) continue;
            if (this.slots[i].field_77994_a >= amount) {
                this.slots[i].field_77994_a -= amount;
                if (this.slots[i].field_77994_a >= 1) continue;
                this.slots[i] = null;
                continue;
            }
            amount -= this.slots[i].field_77994_a;
            this.slots[i] = null;
        }
    }

    public boolean hasItems() {
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null || this.slots[i].field_77994_a <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean hasHighSecurityCornerFenceBlockAt(TileSecurityFenceHighCorner mainFence, int x, int y, int z) {
        return mainFence.field_145850_b.func_147439_a(x, y, z) instanceof BlockSecurityFenceHighCorner;
    }

    private boolean hasHighSecurityBaseFenceBlockAt(TileSecurityFenceHighCorner mainFence, int x, int y, int z) {
        return mainFence.field_145850_b.func_147439_a(x, y, z) instanceof BlockSecurityFenceHighBase;
    }

    private boolean hasHighSecurityPoleFenceBlockAt(TileSecurityFenceHighCorner mainFence, int x, int y, int z) {
        return mainFence.field_145850_b.func_147439_a(x, y, z) instanceof BlockSecurityFenceHighPole;
    }

    private boolean hasHighSecurityGridFenceBlockAt(TileSecurityFenceHighCorner mainFence, int x, int y, int z) {
        return mainFence.field_145850_b.func_147439_a(x, y, z) instanceof BlockSecurityFenceHighGrid;
    }

    public TileSecurityFenceHighCorner getNextHighSecurityCornerFenceBlock(TileSecurityFenceHighCorner mainFence, int side, int distance) {
        TileEntity tileEntity = null;
        switch (side) {
            case 0: {
                for (int i = 1; i < distance; ++i) {
                    if (!mainFence.hasHighSecurityCornerFenceBlockAt(mainFence, mainFence.field_145851_c, mainFence.field_145848_d, mainFence.field_145849_e + i)) continue;
                    tileEntity = mainFence.field_145850_b.func_147438_o(mainFence.field_145851_c, mainFence.field_145848_d, mainFence.field_145849_e + i);
                }
                break;
            }
            case 1: {
                for (int i = 1; i < distance; ++i) {
                    if (!mainFence.hasHighSecurityCornerFenceBlockAt(mainFence, mainFence.field_145851_c - i, mainFence.field_145848_d, mainFence.field_145849_e)) continue;
                    tileEntity = mainFence.field_145850_b.func_147438_o(mainFence.field_145851_c - i, mainFence.field_145848_d, mainFence.field_145849_e);
                }
                break;
            }
            case 2: {
                for (int i = 1; i < distance; ++i) {
                    if (!mainFence.hasHighSecurityCornerFenceBlockAt(mainFence, mainFence.field_145851_c, mainFence.field_145848_d, mainFence.field_145849_e - i)) continue;
                    tileEntity = mainFence.field_145850_b.func_147438_o(mainFence.field_145851_c, mainFence.field_145848_d, mainFence.field_145849_e - i);
                }
                break;
            }
            case 3: {
                for (int i = 1; i < distance; ++i) {
                    if (!mainFence.hasHighSecurityCornerFenceBlockAt(mainFence, mainFence.field_145851_c + i, mainFence.field_145848_d, mainFence.field_145849_e)) continue;
                    tileEntity = mainFence.field_145850_b.func_147438_o(mainFence.field_145851_c + i, mainFence.field_145848_d, mainFence.field_145849_e);
                }
                break;
            }
        }
        if (tileEntity instanceof TileSecurityFenceHighCorner) {
            return (TileSecurityFenceHighCorner)tileEntity;
        }
        return null;
    }

    public TileSecurityFenceHighCorner getNextHighSecurityCornerFenceBlockDirectly(TileSecurityFenceHighCorner mainFence, int side, int distance) {
        TileEntity tileEntity = null;
        switch (side) {
            case 0: {
                if (!mainFence.hasHighSecurityCornerFenceBlockAt(mainFence, mainFence.field_145851_c, mainFence.field_145848_d, mainFence.field_145849_e + distance)) break;
                tileEntity = mainFence.field_145850_b.func_147438_o(mainFence.field_145851_c, mainFence.field_145848_d, mainFence.field_145849_e + distance);
                break;
            }
            case 1: {
                if (!mainFence.hasHighSecurityCornerFenceBlockAt(mainFence, mainFence.field_145851_c - distance, mainFence.field_145848_d, mainFence.field_145849_e)) break;
                tileEntity = mainFence.field_145850_b.func_147438_o(mainFence.field_145851_c - distance, mainFence.field_145848_d, mainFence.field_145849_e);
                break;
            }
            case 2: {
                if (!mainFence.hasHighSecurityCornerFenceBlockAt(mainFence, mainFence.field_145851_c, mainFence.field_145848_d, mainFence.field_145849_e - distance)) break;
                tileEntity = mainFence.field_145850_b.func_147438_o(mainFence.field_145851_c, mainFence.field_145848_d, mainFence.field_145849_e - distance);
                break;
            }
            case 3: {
                if (!mainFence.hasHighSecurityCornerFenceBlockAt(mainFence, mainFence.field_145851_c + distance, mainFence.field_145848_d, mainFence.field_145849_e)) break;
                tileEntity = mainFence.field_145850_b.func_147438_o(mainFence.field_145851_c + distance, mainFence.field_145848_d, mainFence.field_145849_e);
            }
        }
        if (tileEntity instanceof TileSecurityFenceHighCorner) {
            return (TileSecurityFenceHighCorner)tileEntity;
        }
        return null;
    }

    public int getFencePoleHeight(TileSecurityFenceHighCorner mainFence) {
        int i = 0;
        if (mainFence.field_145850_b != null) {
            while (this.hasHighSecurityPoleFenceBlockAt(mainFence, mainFence.field_145851_c, mainFence.field_145848_d + i + 1, mainFence.field_145849_e)) {
                ++i;
            }
        }
        return i;
    }

    public int getSmallerFencePoleHeight(TileSecurityFenceHighCorner mainFence1, TileSecurityFenceHighCorner mainFence2) {
        int heigthFence1 = this.getFencePoleHeight(mainFence1);
        int heigthFence2 = this.getFencePoleHeight(mainFence2);
        return Math.min(heigthFence1, heigthFence2);
    }

    public List<TileSecurityFenceHighPole> getAllFencePoles(TileSecurityFenceHighCorner mainFence) {
        int i = this.getFencePoleHeight(mainFence);
        if (i > 0) {
            ArrayList<TileSecurityFenceHighPole> fencePoles = new ArrayList<TileSecurityFenceHighPole>();
            for (int j = 0; j < i; ++j) {
                fencePoles.add((TileSecurityFenceHighPole)mainFence.field_145850_b.func_147438_o(mainFence.field_145851_c, mainFence.field_145848_d + i + 1, mainFence.field_145849_e));
            }
            return fencePoles;
        }
        return null;
    }

    public void setGridsToAllFencePoles(TileSecurityFenceHighCorner mainFence) {
        int i = this.getFencePoleHeight(mainFence);
        for (int height = 0; height < i; ++height) {
            for (int side = 0; side < 4; ++side) {
                TileEntity fence = mainFence.field_145850_b.func_147438_o(mainFence.field_145851_c, mainFence.field_145848_d + height + 1, mainFence.field_145849_e);
                if (!(fence instanceof TileSecurityFenceHighPole)) continue;
                ((TileSecurityFenceHighPole)fence).setGridAtSide(side, this.hasFenceAt(side));
            }
        }
    }

    public int getFenceBaseLength(TileSecurityFenceHighCorner mainFence, int side) {
        boolean flag = true;
        int metadata = mainFence.func_145832_p();
        int i = 0;
        switch (side) {
            case 0: {
                while (flag) {
                    metadata = mainFence.field_145850_b.func_72805_g(mainFence.field_145851_c, mainFence.field_145848_d, mainFence.field_145849_e + i + 1);
                    if (mainFence.hasHighSecurityBaseFenceBlockAt(mainFence, mainFence.field_145851_c, mainFence.field_145848_d, mainFence.field_145849_e + i + 1) && (metadata == 1 || metadata == 3)) {
                        ++i;
                        continue;
                    }
                    flag = false;
                }
                break;
            }
            case 1: {
                while (flag) {
                    metadata = mainFence.field_145850_b.func_72805_g(mainFence.field_145851_c - i - 1, mainFence.field_145848_d, mainFence.field_145849_e);
                    if (mainFence.hasHighSecurityBaseFenceBlockAt(mainFence, mainFence.field_145851_c - i - 1, mainFence.field_145848_d, mainFence.field_145849_e) && (metadata == 0 || metadata == 2)) {
                        ++i;
                        continue;
                    }
                    flag = false;
                }
                break;
            }
            case 2: {
                while (flag) {
                    metadata = mainFence.field_145850_b.func_72805_g(mainFence.field_145851_c, mainFence.field_145848_d, mainFence.field_145849_e - i - 1);
                    if (mainFence.hasHighSecurityBaseFenceBlockAt(mainFence, mainFence.field_145851_c, mainFence.field_145848_d, mainFence.field_145849_e - i - 1) && (metadata == 1 || metadata == 3)) {
                        ++i;
                        continue;
                    }
                    flag = false;
                }
                break;
            }
            case 3: {
                while (flag) {
                    metadata = mainFence.field_145850_b.func_72805_g(mainFence.field_145851_c + i + 1, mainFence.field_145848_d, mainFence.field_145849_e);
                    if (mainFence.hasHighSecurityBaseFenceBlockAt(mainFence, mainFence.field_145851_c + i + 1, mainFence.field_145848_d, mainFence.field_145849_e) && (metadata == 0 || metadata == 2)) {
                        ++i;
                        continue;
                    }
                    flag = false;
                }
                break;
            }
        }
        return i;
    }

    public boolean isBaseAtSideValid(TileSecurityFenceHighCorner mainFence, int side, int length) {
        ++length;
        switch (side) {
            case 0: {
                return mainFence.hasHighSecurityCornerFenceBlockAt(mainFence, mainFence.field_145851_c, mainFence.field_145848_d, mainFence.field_145849_e + length);
            }
            case 1: {
                return mainFence.hasHighSecurityCornerFenceBlockAt(mainFence, mainFence.field_145851_c - length, mainFence.field_145848_d, mainFence.field_145849_e);
            }
            case 2: {
                return mainFence.hasHighSecurityCornerFenceBlockAt(mainFence, mainFence.field_145851_c, mainFence.field_145848_d, mainFence.field_145849_e - length);
            }
            case 3: {
                return mainFence.hasHighSecurityCornerFenceBlockAt(mainFence, mainFence.field_145851_c + length, mainFence.field_145848_d, mainFence.field_145849_e);
            }
        }
        return false;
    }

    public boolean hasEmptySpaceAt(TileSecurityFenceHighCorner mainFence, int side, int length, int height) {
        switch (side) {
            case 0: {
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < length; ++j) {
                        if (mainFence.field_145850_b.func_147437_c(mainFence.field_145851_c, mainFence.field_145848_d + i + 1, mainFence.field_145849_e + j + 1)) continue;
                        return false;
                    }
                }
                break;
            }
            case 1: {
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < length; ++j) {
                        if (mainFence.field_145850_b.func_147437_c(mainFence.field_145851_c - j - 1, mainFence.field_145848_d + i + 1, mainFence.field_145849_e)) continue;
                        return false;
                    }
                }
                break;
            }
            case 2: {
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < length; ++j) {
                        if (mainFence.field_145850_b.func_147437_c(mainFence.field_145851_c, mainFence.field_145848_d + i + 1, mainFence.field_145849_e - j - 1)) continue;
                        return false;
                    }
                }
                break;
            }
            case 3: {
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < length; ++j) {
                        if (mainFence.field_145850_b.func_147437_c(mainFence.field_145851_c + j + 1, mainFence.field_145848_d + i + 1, mainFence.field_145849_e)) continue;
                        return false;
                    }
                }
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean hasGridBetweenSpace(TileSecurityFenceHighCorner mainFence, int side, int length, int height) {
        switch (side) {
            case 0: {
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < length; ++j) {
                        if (mainFence.hasHighSecurityGridFenceBlockAt(mainFence, mainFence.field_145851_c, mainFence.field_145848_d + i + 1, mainFence.field_145849_e + j + 1)) continue;
                        return false;
                    }
                }
                break;
            }
            case 1: {
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < length; ++j) {
                        if (mainFence.hasHighSecurityGridFenceBlockAt(mainFence, mainFence.field_145851_c - j - 1, mainFence.field_145848_d + i + 1, mainFence.field_145849_e)) continue;
                        return false;
                    }
                }
                break;
            }
            case 2: {
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < length; ++j) {
                        if (mainFence.hasHighSecurityGridFenceBlockAt(mainFence, mainFence.field_145851_c, mainFence.field_145848_d + i + 1, mainFence.field_145849_e - j - 1)) continue;
                        return false;
                    }
                }
                break;
            }
            case 3: {
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < length; ++j) {
                        if (mainFence.hasHighSecurityGridFenceBlockAt(mainFence, mainFence.field_145851_c + j + 1, mainFence.field_145848_d + i + 1, mainFence.field_145849_e)) continue;
                        return false;
                    }
                }
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public int getNumberOfGridsToBuild(int lengthOfTheFence, int heightOfTheFence) {
        return lengthOfTheFence * heightOfTheFence;
    }

    public int getNumberOfGridsToFix(TileSecurityFenceHighCorner mainFence, int side, int length, int height) {
        int numberOfGridsMissing = 0;
        switch (side) {
            case 0: {
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < length; ++j) {
                        if (mainFence.hasHighSecurityGridFenceBlockAt(mainFence, mainFence.field_145851_c, mainFence.field_145848_d + i + 1, mainFence.field_145849_e + j + 1)) continue;
                        ++numberOfGridsMissing;
                    }
                }
                break;
            }
            case 1: {
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < length; ++j) {
                        if (mainFence.hasHighSecurityGridFenceBlockAt(mainFence, mainFence.field_145851_c - j - 1, mainFence.field_145848_d + i + 1, mainFence.field_145849_e)) continue;
                        ++numberOfGridsMissing;
                    }
                }
                break;
            }
            case 2: {
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < length; ++j) {
                        if (mainFence.hasHighSecurityGridFenceBlockAt(mainFence, mainFence.field_145851_c, mainFence.field_145848_d + i + 1, mainFence.field_145849_e - j - 1)) continue;
                        ++numberOfGridsMissing;
                    }
                }
                break;
            }
            case 3: {
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < length; ++j) {
                        if (mainFence.hasHighSecurityGridFenceBlockAt(mainFence, mainFence.field_145851_c + j + 1, mainFence.field_145848_d + i + 1, mainFence.field_145849_e)) continue;
                        ++numberOfGridsMissing;
                    }
                }
                break;
            }
        }
        return numberOfGridsMissing;
    }

    public int getRedstoneRequiredForGrid(int numberOfGrids) {
        return 6 * numberOfGrids;
    }

    public int getIronRequiredForGrid(int numberOfGrids) {
        return 3 * numberOfGrids;
    }

    private void buildFenceOff(TileSecurityFenceHighCorner mainFence1, TileSecurityFenceHighCorner mainFence2, int side, int length, int height) {
        switch (side) {
            case 0: {
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < length; ++j) {
                    }
                }
                mainFence1.setFenceAt(0, true);
                mainFence1.setFenceOff(0);
                mainFence2.setFenceAt(2, true);
                mainFence2.setFenceOff(2);
                break;
            }
            case 1: {
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < length; ++j) {
                    }
                }
                mainFence1.setFenceAt(1, true);
                mainFence1.setFenceOff(1);
                mainFence2.setFenceAt(3, true);
                mainFence2.setFenceOff(3);
                break;
            }
            case 2: {
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < length; ++j) {
                    }
                }
                mainFence1.setFenceAt(2, true);
                mainFence1.setFenceOff(2);
                mainFence2.setFenceAt(0, true);
                mainFence2.setFenceOff(0);
                break;
            }
            case 3: {
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < length; ++j) {
                    }
                }
                mainFence1.setFenceAt(3, true);
                mainFence1.setFenceOff(3);
                mainFence2.setFenceAt(1, true);
                mainFence2.setFenceOff(1);
            }
        }
    }

    private void changeFenceState(boolean turnOnOrOff, TileSecurityFenceHighCorner mainFence1, TileSecurityFenceHighCorner mainFence2, int side, int length, int height) {
        int metadata = 0;
        if (turnOnOrOff) {
            switch (side) {
                case 0: {
                    metadata = 1;
                    break;
                }
                case 1: {
                    metadata = 2;
                    break;
                }
                case 2: {
                    metadata = 3;
                    break;
                }
                case 3: {
                    metadata = 0;
                }
            }
        } else {
            switch (side) {
                case 0: {
                    metadata = 5;
                    break;
                }
                case 1: {
                    metadata = 6;
                    break;
                }
                case 2: {
                    metadata = 7;
                    break;
                }
                case 3: {
                    metadata = 4;
                }
            }
        }
        switch (side) {
            case 0: {
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < length; ++j) {
                        if (!mainFence1.hasHighSecurityGridFenceBlockAt(mainFence1, mainFence1.field_145851_c, mainFence1.field_145848_d + i + 1, mainFence1.field_145849_e + j + 1)) continue;
                        mainFence1.field_145850_b.func_72921_c(mainFence1.field_145851_c, mainFence1.field_145848_d + i + 1, mainFence1.field_145849_e + j + 1, metadata, 2);
                    }
                }
                mainFence1.setFenceOnOff(0, !turnOnOrOff);
                mainFence2.setFenceOnOff(2, !turnOnOrOff);
                break;
            }
            case 1: {
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < length; ++j) {
                        if (!mainFence1.hasHighSecurityGridFenceBlockAt(mainFence1, mainFence1.field_145851_c - j - 1, mainFence1.field_145848_d + i + 1, mainFence1.field_145849_e)) continue;
                        mainFence1.field_145850_b.func_72921_c(mainFence1.field_145851_c - j - 1, mainFence1.field_145848_d + i + 1, mainFence1.field_145849_e, metadata, 2);
                    }
                }
                mainFence1.setFenceOnOff(1, !turnOnOrOff);
                mainFence2.setFenceOnOff(3, !turnOnOrOff);
                break;
            }
            case 2: {
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < length; ++j) {
                        if (!mainFence1.hasHighSecurityGridFenceBlockAt(mainFence1, mainFence1.field_145851_c, mainFence1.field_145848_d + i + 1, mainFence1.field_145849_e - j - 1)) continue;
                        mainFence1.field_145850_b.func_72921_c(mainFence1.field_145851_c, mainFence1.field_145848_d + i + 1, mainFence1.field_145849_e - j - 1, metadata, 2);
                    }
                }
                mainFence1.setFenceOnOff(2, !turnOnOrOff);
                mainFence2.setFenceOnOff(0, !turnOnOrOff);
                break;
            }
            case 3: {
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < length; ++j) {
                        if (!mainFence1.hasHighSecurityGridFenceBlockAt(mainFence1, mainFence1.field_145851_c + j + 1, mainFence1.field_145848_d + i + 1, mainFence1.field_145849_e)) continue;
                        mainFence1.field_145850_b.func_72921_c(mainFence1.field_145851_c + j + 1, mainFence1.field_145848_d + i + 1, mainFence1.field_145849_e, metadata, 2);
                    }
                }
                mainFence1.setFenceOnOff(3, !turnOnOrOff);
                mainFence2.setFenceOnOff(1, !turnOnOrOff);
            }
        }
    }

    public void tryToBuildFence(int side) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        int length = this.getFenceBaseLength(this, side);
        if (!this.isBaseAtSideValid(this, side, length)) {
            return;
        }
        TileSecurityFenceHighCorner otherFence = this.getNextHighSecurityCornerFenceBlockDirectly(this, side, length + 1);
        int height = this.getSmallerFencePoleHeight(this, otherFence);
        int numberOfGrids = this.getNumberOfGridsToBuild(length, height);
        int ironRequired = this.getIronRequiredForGrid(numberOfGrids);
        if (!this.hasNumberOfIronStored(ironRequired)) {
            return;
        }
        int redstoneRequired = this.getRedstoneRequiredForGrid(numberOfGrids);
        if (!this.hasNumberOfRedstoneStored(redstoneRequired)) {
            return;
        }
        if (!this.hasEmptySpaceAt(this, side, length, height)) {
            return;
        }
        this.buildFenceOff(this, otherFence, side, length, height);
        this.reduceIronIngots(ironRequired);
        this.reduceRedstone(redstoneRequired);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        otherFence.field_145850_b.func_147471_g(otherFence.field_145851_c, otherFence.field_145848_d, otherFence.field_145849_e);
    }

    public void tryToFixFence(int side) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        int length = this.getFenceBaseLength(this, side);
        if (!this.isBaseAtSideValid(this, side, length)) {
            return;
        }
        TileSecurityFenceHighCorner otherFence = this.getNextHighSecurityCornerFenceBlockDirectly(this, side, length + 1);
        int height = this.getSmallerFencePoleHeight(this, otherFence);
        if (this.hasGridBetweenSpace(this, side, length, height)) {
            return;
        }
        int numberOfGrids = this.getNumberOfGridsToFix(this, side, length, height);
        int ironRequired = this.getIronRequiredForGrid(numberOfGrids);
        if (!this.hasNumberOfIronStored(ironRequired)) {
            return;
        }
        int redstoneRequired = this.getRedstoneRequiredForGrid(numberOfGrids);
        if (!this.hasNumberOfRedstoneStored(redstoneRequired)) {
            return;
        }
        this.buildFenceOff(this, otherFence, side, length, height);
        this.reduceIronIngots(ironRequired);
        this.reduceRedstone(redstoneRequired);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        otherFence.field_145850_b.func_147471_g(otherFence.field_145851_c, otherFence.field_145848_d, otherFence.field_145849_e);
    }

    public void tryToTurnOnTheFence(int side) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        int length = this.getFenceBaseLength(this, side);
        if (!this.isBaseAtSideValid(this, side, length)) {
            return;
        }
        TileSecurityFenceHighCorner otherFence = this.getNextHighSecurityCornerFenceBlockDirectly(this, side, length + 1);
        int height = this.getSmallerFencePoleHeight(this, otherFence);
        this.changeFenceState(this.isFenceOn(side), this, otherFence, side, length, height);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        otherFence.field_145850_b.func_147471_g(otherFence.field_145851_c, otherFence.field_145848_d, otherFence.field_145849_e);
    }

    public HashMap<Integer, int[]> getAllFenceBlocks() {
        HashMap<Integer, int[]> map = new HashMap<Integer, int[]>();
        int numberOfBlocks = 0;
        for (int i = -11; i < 12; ++i) {
            for (int k = -11; k < 12; ++k) {
                if (!this.hasHighSecurityCornerFenceBlockAt(this, this.field_145851_c + i, this.field_145848_d, this.field_145849_e + k) && !this.hasHighSecurityBaseFenceBlockAt(this, this.field_145851_c + i, this.field_145848_d, this.field_145849_e + k) && !this.hasHighSecurityPoleFenceBlockAt(this, this.field_145851_c + i, this.field_145848_d, this.field_145849_e + k) && !this.hasHighSecurityGridFenceBlockAt(this, this.field_145851_c + i, this.field_145848_d, this.field_145849_e + k)) continue;
                map.put(numberOfBlocks, new int[]{i, k});
                ++numberOfBlocks;
            }
        }
        return map;
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70298_a(int i, int stackSize) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= stackSize) {
                ItemStack splitedStack = this.slots[i];
                this.slots[i] = null;
                return splitedStack;
            }
            ItemStack splitedStack = this.slots[i].func_77979_a(stackSize);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return splitedStack;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "Security_Fence_Main_Block";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 49.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return false;
    }

    public int[] func_94128_d(int i) {
        return new int[]{0};
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return false;
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return false;
    }

    public void func_145841_b(NBTTagCompound compound) {
        int i;
        super.func_145841_b(compound);
        NBTTagList list = new NBTTagList();
        for (i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)i);
            this.slots[i].func_77955_b(tagCompound);
            list.func_74742_a((NBTBase)tagCompound);
        }
        compound.func_74782_a("Items", (NBTBase)list);
        for (i = 0; i < this.builtFences.length; ++i) {
            compound.func_74757_a("FenceAtSide" + i, this.hasFenceAt(i));
        }
        for (i = 0; i < this.fenceState.length; ++i) {
            compound.func_74757_a("FenceStateAtSide" + i, this.isFenceOn(i));
        }
        compound.func_74774_a("PlannedSide", (byte)this.getPlannedSide());
    }

    public void func_145839_a(NBTTagCompound compound) {
        int i;
        super.func_145839_a(compound);
        NBTTagList list = compound.func_150295_c("Items", 10);
        this.slots = new ItemStack[this.func_70302_i_()];
        for (i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = list.func_150305_b(i);
            byte j = tagCompound.func_74771_c("Slot");
            if (j < 0 || j >= this.slots.length) continue;
            this.slots[j] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
        for (i = 0; i < this.builtFences.length; ++i) {
            this.setFenceAt(i, compound.func_74767_n("FenceAtSide" + i));
        }
        for (i = 0; i < this.fenceState.length; ++i) {
            this.setFenceOnOff(i, compound.func_74767_n("FenceStateAtSide" + i));
        }
        this.setPlannedSide(compound.func_74771_c("PlannedSide"));
        this.setGridsToAllFencePoles(this);
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_145841_b(compound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145847_g, compound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        NBTTagCompound compound = packet.func_148857_g();
        this.func_145839_a(compound);
    }
}

