/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.common.entity.dinosaurs;

import net.ilexiconn.jurassicraft.client.model.base.ControlledParam;
import net.ilexiconn.jurassicraft.common.data.enums.JurassiCraftAnimationIDs;
import net.ilexiconn.jurassicraft.common.entity.ChainBuffer;
import net.ilexiconn.jurassicraft.common.entity.ControlledAnimation;
import net.ilexiconn.jurassicraft.common.entity.EntityJurassiCraftAggressive;
import net.ilexiconn.jurassicraft.common.entity.IntermittentAnimation;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIEatDroppedFood;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIEating;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIFollowFood;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIOwnerHurtsTarget;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIOwnerIsHurtByTarget;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAISitNatural;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAITargetIfHasAgeAndNonTamed;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIWander;
import net.ilexiconn.jurassicraft.common.entity.ai.animation.AnimationAIRoar;
import net.ilexiconn.jurassicraft.common.entity.ai.animation.AnimationAITyrannosaurusEatingGallimimus;
import net.ilexiconn.jurassicraft.common.entity.ai.animation.AnimationAIWalkRoar;
import net.ilexiconn.jurassicraft.common.entity.ai.herds.HerdAIFollowHerd;
import net.ilexiconn.jurassicraft.common.entity.ai.herds.HerdAIGroupAttack;
import net.ilexiconn.jurassicraft.common.entity.dinosaurs.EntityBrachiosaurus;
import net.ilexiconn.jurassicraft.common.entity.dinosaurs.EntityGallimimus;
import net.ilexiconn.jurassicraft.common.entity.dinosaurs.EntityHypsilophodon;
import net.ilexiconn.jurassicraft.common.entity.dinosaurs.EntityLeaellynasaura;
import net.ilexiconn.jurassicraft.common.entity.dinosaurs.EntityOviraptor;
import net.ilexiconn.jurassicraft.common.entity.dinosaurs.EntityParasaurolophus;
import net.ilexiconn.jurassicraft.common.entity.dinosaurs.EntitySpinosaurus;
import net.ilexiconn.jurassicraft.common.entity.dinosaurs.EntityStegosaurus;
import net.ilexiconn.jurassicraft.common.entity.dinosaurs.EntityTriceratops;
import net.ilexiconn.jurassicraft.common.entity.mammals.EntityLeptictidium;
import net.ilexiconn.jurassicraft.common.entity.mammals.EntityMoeritherium;
import net.ilexiconn.jurassicraft.common.handler.AnimationHandler;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityTyrannosaurus
extends EntityJurassiCraftAggressive {
    public ControlledParam roarCount = new ControlledParam(0.0f, 0.0f, 0.5f, 0.0f);
    public ControlledParam roarTiltDegree = new ControlledParam(0.0f, 0.0f, 1.0f, 0.0f);
    public IntermittentAnimation restingHeadProgress = new IntermittentAnimation(30, 200, 100, 100);
    public ControlledAnimation sittingProgress = new ControlledAnimation(50);
    public ControlledAnimation shakePrey = new ControlledAnimation(10);
    public ChainBuffer tailBuffer = new ChainBuffer(6);
    private int stepCount = 0;

    public EntityTyrannosaurus(World world) {
        super(world);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AnimationAITyrannosaurusEatingGallimimus(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AnimationAIRoar(this, 75));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new AnimationAIWalkRoar(this, 75));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, (double)1.4f * this.getCreatureSpeed(), false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new JurassiCraftAIWander(this, 40, this.getCreatureSpeed()));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new JurassiCraftAISitNatural(this, 800, 125, 400));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new JurassiCraftAIEating(this, 20, true, JurassiCraftAnimationIDs.BITE.animID()));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, this.getCreatureSpeed()));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new JurassiCraftAIFollowFood(this, 100, 1.2 * this.getCreatureSpeed()));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new JurassiCraftAIEatDroppedFood(this, 16.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new HerdAIFollowHerd(this, true, this.getCreatureSpeed()));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new HerdAIGroupAttack(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new JurassiCraftAIOwnerIsHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new JurassiCraftAIOwnerHurtsTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityBrachiosaurus.class, 120, 0.7f, 0.7f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityStegosaurus.class, 80, 0.6f, 0.9f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityTriceratops.class, 70, 0.6f, 0.9f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityParasaurolophus.class, 40, 0.55f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityGallimimus.class, 40, 0.4f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityHypsilophodon.class, 40, 0.4f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityLeaellynasaura.class, 40, 0.4f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityMoeritherium.class, 40, 0.4f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityOviraptor.class, 40, 0.3f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityLeptictidium.class, 40, 0.3f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityHorse.class, 50, 0.25f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityCow.class, 30, 0.2f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityPig.class, 30, 0.15f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntitySheep.class, 30, 0.2f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityChicken.class, 10, 0.1f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityPlayer.class, 40, 0.3f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntitySpinosaurus.class, 40, 0.7f));
        this.setCreatureExperiencePoints(5500);
    }

    public void func_70043_V() {
        super.func_70043_V();
        if (this.field_70153_n != null) {
            if (this.field_70153_n instanceof EntityGallimimus) {
                this.field_70177_z = this.field_70761_aq;
                EntityGallimimus gallimimus = (EntityGallimimus)this.field_70153_n;
                gallimimus.field_70759_as = this.field_70153_n.field_70177_z;
                float shakeProgress = this.shakePrey.getAnimationProgressSinSqrt();
                float radius = 0.4f * this.getCreatureLength();
                float angle = (float)((double)((float)Math.PI / 180 * this.field_70761_aq) + 0.05 * (double)this.getCreatureLength() * (double)shakeProgress * Math.cos((double)this.frame * 0.6 + 1.0));
                this.field_70153_n.field_70177_z = (float)((double)angle * 57.29577951308232 - 150.0);
                gallimimus.field_70761_aq = (float)((double)angle * 57.29577951308232 - 150.0);
                double extraY = (double)this.getCreatureHeight() * (0.425 - (double)shakeProgress * 0.21);
                if (this.getAnimationTick() > 30) {
                    extraY += 0.38 * Math.sin((double)(this.getAnimationTick() - 30) * 0.2) * (double)this.getCreatureHeight();
                    radius = (float)((double)radius - 0.001 * (double)(this.getAnimationTick() - 30) * (double)(this.getAnimationTick() - 30) * (double)this.getCreatureLength());
                }
                double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                double extraZ = radius * MathHelper.func_76134_b((float)angle);
                this.field_70153_n.func_70107_b(this.field_70165_t + extraX, this.field_70163_u + extraY, this.field_70161_v + extraZ);
            } else {
                this.field_70153_n.func_70107_b(this.field_70165_t, this.field_70163_u + this.func_70042_X() + this.field_70153_n.func_70033_W(), this.field_70161_v);
            }
        }
    }

    @Override
    public String func_70639_aQ() {
        int sound = this.field_70146_Z.nextInt(4) + 1;
        if (sound == 1 && this.getCreatureAgeInDays() >= 25) {
            this.func_85030_a("jurassicraft:tyrannosaurus01", 5.0f, this.func_70647_i());
            if (this.animID == 0) {
                if (this.field_70701_bs == 0.0f) {
                    if (!this.isSitting()) {
                        AnimationHandler.sendAnimationPacket(this, JurassiCraftAnimationIDs.ROAR.animID());
                    }
                } else {
                    AnimationHandler.sendAnimationPacket(this, JurassiCraftAnimationIDs.WALK_ROAR.animID());
                }
            }
            return null;
        }
        return null;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.roarCount.update();
        this.roarTiltDegree.update();
        if (this.field_70701_bs > 0.0f && this.stepCount <= 0 && this.getCreatureAgeInDays() >= 25) {
            this.func_85030_a("jurassicraft:footstep", 2.0f, this.func_70647_i());
            this.stepCount = 65;
        }
        if (this.animID == JurassiCraftAnimationIDs.ROAR.animID() && this.animTick == 22) {
            this.roarTiltDegree.thereAndBack(0.0f, 0.1f, 1.0f, 20);
        }
        if (this.animID == JurassiCraftAnimationIDs.WALK_ROAR.animID() && this.animTick == 22) {
            this.roarTiltDegree.thereAndBack(0.0f, 0.1f, 1.0f, 20);
        }
        this.stepCount = (int)((double)this.stepCount - (double)this.field_70701_bs * 9.5);
        if (this.frame % 62 == 28) {
            this.func_85030_a("jurassicraft:tyrannosaurusbreath", 1.0f, this.func_70647_i());
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.isSitting()) {
                this.sittingProgress.increaseTimer();
                this.restingHeadProgress.runAnimation();
            } else {
                this.sittingProgress.decreaseTimer();
                this.restingHeadProgress.stopAnimation();
            }
        }
        this.tailBuffer.calculateChainSwingBuffer(55.0f, 5, 3.0f, (EntityLivingBase)this);
        if (this.func_70638_az() == this.field_70153_n) {
            this.func_70624_b(null);
        }
        if (this.getAnimationId() == JurassiCraftAnimationIDs.EATING.animID() && this.getAnimationTick() <= 20) {
            this.shakePrey.increaseTimer();
        }
        if (this.getAnimationId() == JurassiCraftAnimationIDs.EATING.animID() && this.getAnimationTick() > 20) {
            this.shakePrey.decreaseTimer();
        }
    }

    @Override
    protected void func_70628_a(boolean recentlyBeenHit, int enchantBonus) {
        float developmentFraction = (float)this.getGrowthStage() / 120.0f;
        int countMeat = Math.round(1.0f + 5.0f * developmentFraction + (float)this.field_70146_Z.nextInt(1 + (int)(3.0f * developmentFraction)) + (float)this.field_70146_Z.nextInt(1 + enchantBonus));
        int countTeeth = Math.round(1.5f * developmentFraction + (float)this.field_70146_Z.nextInt(1 + (int)(2.0f * developmentFraction)));
        if (!this.func_70027_ad()) {
            this.dropItemStackWithGenetics(new ItemStack((Item)this.getCreature().getMeat(), countMeat));
            this.dropItemStackWithGenetics(new ItemStack((Item)this.getCreature().getTooth(), countTeeth));
        } else {
            this.func_145779_a((Item)this.getCreature().getSteak(), countMeat);
            this.dropItemStackWithGenetics(new ItemStack((Item)this.getCreature().getTooth(), countTeeth));
        }
        if (this.field_70146_Z.nextFloat() < 0.1f) {
            this.dropItemStackWithGenetics(new ItemStack((Item)this.getCreature().getSkull()));
        }
        if (this.isMale() && this.field_70146_Z.nextFloat() < 0.25f) {
            this.dropItemStackWithGenetics(new ItemStack((Item)this.getCreature().getSkin()));
        }
    }
}

