/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.common.entity.dinosaurs;

import net.ilexiconn.jurassicraft.common.api.IHerbivore;
import net.ilexiconn.jurassicraft.common.data.enums.JurassiCraftAnimationIDs;
import net.ilexiconn.jurassicraft.common.entity.ChainBuffer;
import net.ilexiconn.jurassicraft.common.entity.ControlledAnimation;
import net.ilexiconn.jurassicraft.common.entity.EntityJurassiCraftProtective;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIAngry;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIEatDroppedFood;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIEating;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIFlee;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIFollowFood;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIHerdBehavior;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIOwnerHurtsTarget;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIOwnerIsHurtByTarget;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAISitNatural;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIWander;
import net.ilexiconn.jurassicraft.common.entity.ai.animation.AnimationAIGallimimusBeingEaten;
import net.ilexiconn.jurassicraft.common.entity.ai.herds.HerdAIFollowHerd;
import net.ilexiconn.jurassicraft.common.entity.dinosaurs.EntityTyrannosaurus;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityGallimimus
extends EntityJurassiCraftProtective
implements IHerbivore {
    public ControlledAnimation sittingProgress = new ControlledAnimation(40);
    public ChainBuffer tailBuffer = new ChainBuffer(4);
    public float swallowScale = 1.0f;

    public EntityGallimimus(World world) {
        super(world);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new JurassiCraftAIAngry(this, 150));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new JurassiCraftAIFlee(this, 80, 1.1 * this.getCreatureSpeed()));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new JurassiCraftAISitNatural(this, 900, 175, 375));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, (double)1.1f * this.getCreatureSpeed(), false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new JurassiCraftAIFollowFood(this, 30, 1.1 * this.getCreatureSpeed()));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new JurassiCraftAIEatDroppedFood(this, 16.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new JurassiCraftAIEating(this, 20));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AnimationAIGallimimusBeingEaten(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new JurassiCraftAIWander(this, 30, 0.7 * this.getCreatureSpeed()));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityTyrannosaurus.class, 12.0f, this.getCreatureSpeed(), 1.1 * this.getCreatureSpeed()));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new JurassiCraftAIHerdBehavior(this, 128.0, 2500, 24.0, this.getCreatureSpeed()));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new HerdAIFollowHerd(this, false, this.getCreatureSpeed()));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new JurassiCraftAIOwnerIsHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new JurassiCraftAIOwnerHurtsTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.setCreatureExperiencePoints(1000);
    }

    public void func_70043_V() {
        float creatureSizeParam = 0.25f * this.getCreatureLength();
        float extraX = creatureSizeParam * MathHelper.func_76126_a((float)((float)Math.PI + (float)Math.PI / 180 * this.field_70177_z));
        float extraZ = creatureSizeParam * MathHelper.func_76134_b((float)((float)Math.PI / 180 * this.field_70177_z));
        float extraY = 1.2f * this.getYBouningBox() + 0.16f * (this.field_70721_aZ - this.field_70721_aZ * MathHelper.func_76126_a((float)this.field_70754_ba));
        this.field_70153_n.func_70107_b(this.field_70165_t - (double)extraX, this.field_70163_u + (double)extraY, this.field_70161_v - (double)extraZ);
    }

    @Override
    public int getNumberOfAllies() {
        return 2;
    }

    @Override
    public int func_70627_aG() {
        return 350;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.isSitting()) {
                this.sittingProgress.increaseTimer();
            } else {
                this.sittingProgress.decreaseTimer();
            }
        }
        this.tailBuffer.calculateChainSwingBuffer(45.0f, 3, 3.8f, (EntityLivingBase)this);
        if (this.getAnimationId() == JurassiCraftAnimationIDs.BEING_EATEN.animID() && this.getAnimationTick() >= 35 && this.swallowScale > 0.0f) {
            this.swallowScale = (float)((double)this.swallowScale - 0.1);
        }
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (this.field_70154_o instanceof EntityTyrannosaurus) {
            if (this.func_70638_az() == this.field_70154_o) {
                this.func_70624_b(null);
            }
            return false;
        }
        return super.func_70652_k(entity);
    }

    @Override
    protected void func_70628_a(boolean recentlyBeenHit, int enchantBonus) {
        float developmentFraction = (float)this.getGrowthStage() / 120.0f;
        int count = Math.round(1.0f + 2.5f * developmentFraction + (float)this.field_70146_Z.nextInt(1 + (int)(2.0f * developmentFraction)) + (float)this.field_70146_Z.nextInt(1 + enchantBonus));
        if (!this.func_70027_ad()) {
            this.dropItemStackWithGenetics(new ItemStack((Item)this.getCreature().getMeat(), count));
        } else {
            this.func_145779_a((Item)this.getCreature().getSteak(), count);
        }
    }
}

