/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.common.entity.ai.animation;

import net.ilexiconn.jurassicraft.common.data.enums.JurassiCraftAnimationIDs;
import net.ilexiconn.jurassicraft.common.entity.ai.AIAnimation;
import net.ilexiconn.jurassicraft.common.entity.dinosaurs.EntityVelociraptor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;

public class AnimationAIVelociraptorLeap
extends AIAnimation {
    private EntityVelociraptor entityRaptor;
    private EntityLivingBase attackTarget;
    private double destX;
    private double destZ;
    private double targetSpeedX;
    private double targetSpeedZ;
    private double targetPrevPosX;
    private double targetPrevPosZ;

    public AnimationAIVelociraptorLeap(EntityVelociraptor raptor) {
        super(raptor);
        this.entityRaptor = raptor;
    }

    @Override
    public int getAnimationId() {
        return JurassiCraftAnimationIDs.LEAP.animID();
    }

    @Override
    public boolean isAutomatic() {
        return true;
    }

    @Override
    public int getDuration() {
        return 20;
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
        this.attackTarget = this.entityRaptor.func_70638_az();
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
    }

    public void func_75246_d() {
        if (this.entityRaptor.getAnimationTick() < 10 && this.attackTarget != null) {
            this.entityRaptor.func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
        }
        if (this.entityRaptor.getAnimationTick() == 9 && this.attackTarget != null) {
            this.targetPrevPosX = this.attackTarget.field_70165_t;
            this.targetPrevPosZ = this.attackTarget.field_70161_v;
        }
        if (this.entityRaptor.getAnimationTick() == 10 && this.attackTarget != null) {
            this.targetSpeedX = this.attackTarget.field_70165_t - this.targetPrevPosX;
            this.targetSpeedZ = this.attackTarget.field_70161_v - this.targetPrevPosZ;
            double leapDuration = 6.0;
            this.destX = this.attackTarget.field_70165_t + this.targetSpeedX * leapDuration * 2.0;
            this.destZ = this.attackTarget.field_70161_v + this.targetSpeedZ * leapDuration * 2.0;
            double d = Math.sqrt((this.destX - this.entityRaptor.field_70165_t) * (this.destX - this.entityRaptor.field_70165_t) + (this.destZ - this.entityRaptor.field_70161_v) * (this.destZ - this.entityRaptor.field_70161_v));
            double a = Math.atan2(this.destZ - this.entityRaptor.field_70161_v, this.destX - this.entityRaptor.field_70165_t);
            this.entityRaptor.field_70159_w = d / leapDuration * Math.cos(a);
            this.entityRaptor.field_70179_y = d / leapDuration * Math.sin(a);
            this.entityRaptor.field_70181_x = 0.6;
            this.entityRaptor.timeSinceLeap = 150;
            this.entityRaptor.func_85030_a("jurassicraft:velociraptorCall", 1.0f, 1.0f);
        }
    }
}

