/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.common.entity.ai.animation;

import net.ilexiconn.jurassicraft.common.data.enums.JurassiCraftAnimationIDs;
import net.ilexiconn.jurassicraft.common.entity.EntityJurassiCraftCharges;
import net.ilexiconn.jurassicraft.common.entity.ai.AIAnimation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;

public class AnimationAICharge
extends AIAnimation {
    private EntityJurassiCraftCharges entityCharging;
    private EntityLivingBase attackTarget;
    private float chargeAcceleration;
    private float chargeSpeed;
    private float angleYaw;
    private float startX;
    private float startZ;
    private float distanceTravelled;
    private float distanceOfTargetFromStart;

    public AnimationAICharge(EntityJurassiCraftCharges charging) {
        super(charging);
        this.entityCharging = charging;
        this.attackTarget = null;
        this.chargeAcceleration = 0.2f;
        this.chargeSpeed = 1.0f;
        this.angleYaw = 0.0f;
        this.startX = 0.0f;
        this.startZ = 0.0f;
        this.distanceTravelled = 0.0f;
        this.distanceOfTargetFromStart = 0.0f;
    }

    @Override
    public int getAnimationId() {
        return JurassiCraftAnimationIDs.CHARGE.animID();
    }

    @Override
    public boolean isAutomatic() {
        return true;
    }

    @Override
    public int getDuration() {
        return 100;
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
        this.attackTarget = this.entityCharging.func_70638_az();
        this.startX = (float)this.entityCharging.field_70165_t;
        this.startZ = (float)this.entityCharging.field_70161_v;
        if (this.attackTarget != null) {
            this.distanceOfTargetFromStart = (float)Math.sqrt(((double)this.startX - this.attackTarget.field_70165_t) * ((double)this.startX - this.attackTarget.field_70165_t) + ((double)this.startZ - this.attackTarget.field_70161_v) * ((double)this.startZ - this.attackTarget.field_70161_v));
        }
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
        this.entityCharging.timeSinceCharge = 150;
        this.entityCharging.charging = false;
        this.entityCharging.func_70624_b(null);
    }

    public void func_75246_d() {
        double deltaZ;
        double deltaX;
        if (this.attackTarget != null) {
            this.entityCharging.func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
        }
        this.distanceTravelled = (float)Math.sqrt(((double)this.startX - this.entityCharging.field_70165_t) * ((double)this.startX - this.entityCharging.field_70165_t) + ((double)this.startZ - this.entityCharging.field_70161_v) * ((double)this.startZ - this.entityCharging.field_70161_v));
        if (this.entityCharging.getAnimationTick() == 1) {
            this.entityCharging.func_85030_a("jurassicraft:TriceratopsCharge", 1.0f, 1.0f);
        }
        if (this.entityCharging.getAnimationTick() >= 35 && this.entityCharging.getAnimationTick() <= 40 && this.attackTarget != null) {
            deltaX = this.attackTarget.field_70165_t - this.entityCharging.field_70165_t;
            deltaZ = this.attackTarget.field_70161_v - this.entityCharging.field_70161_v;
            this.angleYaw = (float)Math.atan2(deltaZ, deltaX);
        }
        if (this.entityCharging.getAnimationTick() > 40 && (this.attackTarget != null || this.entityCharging.field_70153_n != null)) {
            if (this.entityCharging.field_70153_n != null && this.entityCharging.field_70153_n instanceof EntityPlayer) {
                this.angleYaw = this.entityCharging.field_70153_n.field_70177_z * ((float)Math.PI / 180) + 1.5707964f;
                this.entityCharging.field_70177_z = this.entityCharging.field_70153_n.field_70177_z;
                this.chargeAcceleration = 0.3f;
            }
            this.entityCharging.charging = true;
            if (this.attackTarget != null && this.distanceOfTargetFromStart > this.distanceTravelled) {
                deltaZ = this.attackTarget.field_70161_v - this.entityCharging.field_70161_v;
                deltaX = this.attackTarget.field_70165_t - this.entityCharging.field_70165_t;
                float destAngleYaw = (float)Math.atan2(deltaZ, deltaX);
                if ((double)(this.angleYaw - destAngleYaw) >= 0.1) {
                    this.angleYaw = (float)((double)this.angleYaw - 0.1);
                } else if ((double)(this.angleYaw - destAngleYaw) <= -0.1) {
                    this.angleYaw = (float)((double)this.angleYaw + 0.1);
                }
            }
            if (Math.sqrt(this.entityCharging.field_70159_w * this.entityCharging.field_70159_w + this.entityCharging.field_70179_y * this.entityCharging.field_70179_y) < (double)this.chargeSpeed - 0.2) {
                this.entityCharging.field_70159_w += (double)this.chargeAcceleration * Math.cos(this.angleYaw);
                this.entityCharging.field_70179_y += (double)this.chargeAcceleration * Math.sin(this.angleYaw);
            } else {
                this.entityCharging.field_70159_w = (double)this.chargeSpeed * Math.cos(this.angleYaw);
                this.entityCharging.field_70179_y = (double)this.chargeSpeed * Math.sin(this.angleYaw);
            }
            this.entityCharging.field_70177_z = (float)((double)this.angleYaw * 57.29577951308232 - 90.0);
            this.entityCharging.field_70761_aq = (float)((double)this.angleYaw * 57.29577951308232 - 90.0);
        }
    }
}

