/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.common.entity;

import net.ilexiconn.jurassicraft.common.entity.EntityJurassiCraftRidable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityJurassiCraftRidableFlying
extends EntityJurassiCraftRidable {
    private static int MAX_TAKEOFF_TIME = 60;
    public float adjustYaw = 0.0f;
    private int takeOffTimer;
    private int flapDelay;

    public EntityJurassiCraftRidableFlying(World world) {
        super(world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
    }

    @Override
    public void func_70612_e(float movementStrafing, float movementForward) {
        if (this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)this.field_70153_n;
            if (this.isFlying() || player.func_70694_bm() != null && this.checkRidingItem(player.func_70694_bm())) {
                if (!this.field_70170_p.field_72995_K) {
                    if ((this.isTakingOff() || !this.isFlying()) && Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d() && Minecraft.func_71410_x().field_71474_y.field_74351_w.func_151470_d()) {
                        this.increaseTakeOffTimer();
                        if (!this.isTakingOff()) {
                            this.setTakingOff(true);
                        }
                    } else {
                        this.decreaseTakeOffTimer(2);
                        if (this.isTakingOff()) {
                            this.setTakingOff(false);
                            this.resetTakeOffTimer();
                        }
                    }
                }
                if (this.field_70123_F) {
                    this.setTakingOff(false);
                    this.setFlying(false);
                    this.resetTakeOffTimer();
                }
                if (this.isTakingOff()) {
                    this.field_70138_W = 0.5f;
                    this.field_70747_aH = this.func_70689_ay() * 0.1f;
                    this.onUpdateTakingOffClient();
                    this.onUpdateTakingOffServer();
                    return;
                }
                if (this.isFlying()) {
                    if (this.field_70122_E) {
                        this.field_70159_w *= 0.75;
                        this.field_70179_y *= 0.75;
                        this.setTakingOff(false);
                        this.setFlying(false);
                        this.resetTakeOffTimer();
                    }
                    this.field_70138_W = 1.25f;
                    this.field_70747_aH = this.func_70689_ay() * 0.1f;
                    this.onUpdateFlyingClient();
                    this.onUpdateFlyingServerGlide();
                    return;
                }
            } else if (this.isFlying() && this.field_70122_E) {
                this.setFlying(false);
            }
        }
        if (this.isFlying() && this.field_70122_E) {
            this.setFlying(false);
        }
        if (this.isTakingOff()) {
            this.setTakingOff(false);
            this.resetTakeOffTimer();
        }
        super.func_70612_e(movementStrafing, movementForward);
    }

    private void onUpdateTakingOffClient() {
        this.field_70177_z = this.field_70126_B;
        this.field_70125_A = this.field_70127_C;
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        this.field_70759_as = this.field_70761_aq = this.field_70177_z;
        this.handleLimbMovement();
    }

    private void onUpdateTakingOffServer() {
        float newAngleYaw = (float)Math.PI / 180 * this.field_70177_z + 1.5707964f;
        this.field_70181_x += 0.025 * (double)this.getTakingOffMotionY();
        this.field_70159_w += 0.01 * Math.cos(newAngleYaw);
        this.field_70179_y += 0.01 * Math.sin(newAngleYaw);
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (this.getTakeOffProgress() >= 1.0f) {
            this.setFlying(true);
            this.setTakingOff(false);
            this.resetTakeOffTimer();
            this.field_70181_x = -0.1f;
        }
    }

    private void onUpdateFlyingClient() {
        this.field_70138_W = 0.0f;
        if (this.adjustYaw > 0.0f) {
            this.adjustYaw = (float)((double)this.adjustYaw - 0.1);
        }
        if (this.adjustYaw < 0.0f) {
            this.adjustYaw = (float)((double)this.adjustYaw + 0.1);
        }
        GameSettings gameSettings = Minecraft.func_71410_x().field_71474_y;
        if (gameSettings.field_74366_z.func_151470_d() && this.adjustYaw < 2.4f) {
            this.adjustYaw += 0.2f;
        }
        if (gameSettings.field_74370_x.func_151470_d() && this.adjustYaw > -2.4f) {
            this.adjustYaw -= 0.2f;
        }
        this.field_70126_B = this.field_70177_z = MathHelper.func_76142_g((float)(this.field_70177_z + this.adjustYaw));
        this.field_70127_C = this.field_70125_A;
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        this.handleLimbMovement();
    }

    private void onUpdateFlyingServerGlide() {
        this.field_70159_w = 2.0f * this.getMountingSpeed() * MathHelper.func_76134_b((float)((float)Math.PI / 180 * this.field_70125_A)) * MathHelper.func_76126_a((float)((float)Math.PI + (float)Math.PI / 180 * this.field_70177_z));
        this.field_70179_y = 2.0f * this.getMountingSpeed() * MathHelper.func_76134_b((float)((float)Math.PI / 180 * this.field_70125_A)) * MathHelper.func_76134_b((float)((float)Math.PI / 180 * this.field_70177_z));
        if (this.getFlapDelay() < 0 && Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d()) {
            this.field_70181_x += 1.5;
            this.setFlapDelay(20);
        } else {
            this.decreaseFlapDelay();
            this.field_70181_x *= 0.7 + 0.15 * Math.sin(1.57079632679 * (double)this.getFlapDelay() / 20.0);
        }
        if (this.getFlapDelay() < 0) {
            this.func_70091_d(this.field_70159_w, this.field_70181_x - 0.2, this.field_70179_y);
        } else {
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
    }

    private void onUpdateFlyingServerFreeMovement() {
        GameSettings gameSettings = Minecraft.func_71410_x().field_71474_y;
        if (this.field_70181_x <= (double)(2.0f * this.getMountingSpeed()) && gameSettings.field_74351_w.func_151470_d()) {
            this.field_70181_x += 0.02;
        }
        if (this.field_70181_x >= (double)(-2.0f * this.getMountingSpeed()) && gameSettings.field_74368_y.func_151470_d()) {
            this.field_70181_x -= 0.02;
        }
        this.field_70159_w = 2.0f * this.getMountingSpeed() * MathHelper.func_76134_b((float)((float)Math.PI / 180 * this.field_70125_A)) * MathHelper.func_76126_a((float)((float)Math.PI + (float)Math.PI / 180 * this.field_70177_z));
        this.field_70179_y = 2.0f * this.getMountingSpeed() * MathHelper.func_76134_b((float)((float)Math.PI / 180 * this.field_70125_A)) * MathHelper.func_76134_b((float)((float)Math.PI / 180 * this.field_70177_z));
        this.func_70091_d(this.field_70159_w, this.field_70181_x + 0.05, this.field_70179_y);
    }

    public boolean isCreatureFlyable() {
        return this.getCreature().isFlyingCreature();
    }

    protected int getMaximumTakeOffTime() {
        return MAX_TAKEOFF_TIME;
    }

    public void setMaximumTakeOffTime(int maxTime) {
        MAX_TAKEOFF_TIME = maxTime;
    }

    private void increaseTakeOffTimer() {
        if (this.getTakeOffTimer() <= this.getMaximumTakeOffTime()) {
            ++this.takeOffTimer;
        }
    }

    private void decreaseTakeOffTimer() {
        if (this.getTakeOffTimer() >= 0) {
            --this.takeOffTimer;
        }
    }

    private void decreaseTakeOffTimer(int value) {
        if (this.getTakeOffTimer() - value >= 0) {
            this.takeOffTimer -= value;
        }
    }

    private void resetTakeOffTimer() {
        this.takeOffTimer = 0;
    }

    public int getTakeOffTimer() {
        return this.takeOffTimer;
    }

    private void setTakeOffTimer(int time) {
        this.takeOffTimer = time;
    }

    public float getTakeOffProgress() {
        return this.getTakeOffTimer() / this.getMaximumTakeOffTime();
    }

    public float getTakingOffMotionY() {
        float result = MathHelper.func_76126_a((float)(1.5707964f * (float)this.getTakeOffTimer() / (float)this.getMaximumTakeOffTime()));
        return result * result;
    }

    private void decreaseFlapDelay() {
        --this.flapDelay;
    }

    public int getFlapDelay() {
        return this.flapDelay;
    }

    private void setFlapDelay(int time) {
        this.flapDelay = time;
    }

    public void func_82167_n(Entity target) {
        super.func_82167_n(target);
        if (this.isFlying()) {
            double deltaX = target.field_70165_t - target.field_70165_t;
            double deltaZ = target.field_70161_v - target.field_70161_v;
            double angleYaw = (float)Math.atan2(deltaZ, deltaX);
            target.field_70159_w += Math.cos(angleYaw);
            target.field_70179_y += Math.sin(angleYaw);
            target.field_70181_x += 0.2;
        }
    }

    @Override
    public boolean func_70617_f_() {
        return false;
    }

    protected void func_70069_a(float f) {
    }

    protected void func_70064_a(double distanceFallen, boolean onGround) {
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("TakeOffTimer", this.getTakeOffTimer());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setTakeOffTimer(compound.func_74762_e("TakeOffTimer"));
    }
}

