/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.common.entity;

import net.ilexiconn.llibrary.client.model.tools.AdvancedModelRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;

public class ChainBuffer {
    private int yawTimer = 0;
    private float yawVariation = 0.0f;
    private int pitchTimer = 0;
    private float pitchVariation = 0.0f;
    private float[] yawArray;
    private float[] pitchArray;

    public ChainBuffer(int numberOfParentedBoxes) {
        this.yawArray = new float[numberOfParentedBoxes];
        this.pitchArray = new float[numberOfParentedBoxes];
    }

    public void resetRotations() {
        this.yawVariation = 0.0f;
        this.pitchVariation = 0.0f;
    }

    public void calculateChainSwingBuffer(float maxAngle, int bufferTime, float angleDecrement, float divider, EntityLivingBase entity) {
        if (entity.field_70761_aq != entity.field_70760_ar && MathHelper.func_76135_e((float)this.yawVariation) < maxAngle) {
            this.yawVariation += (entity.field_70760_ar - entity.field_70761_aq) / divider;
        }
        if (this.yawVariation > 0.7f * angleDecrement) {
            if (this.yawTimer > bufferTime) {
                this.yawVariation -= angleDecrement;
                if (MathHelper.func_76135_e((float)this.yawVariation) < angleDecrement) {
                    this.yawVariation = 0.0f;
                    this.yawTimer = 0;
                }
            } else {
                ++this.yawTimer;
            }
        } else if (this.yawVariation < -0.7f * angleDecrement) {
            if (this.yawTimer > bufferTime) {
                this.yawVariation += angleDecrement;
                if (MathHelper.func_76135_e((float)this.yawVariation) < angleDecrement) {
                    this.yawVariation = 0.0f;
                    this.yawTimer = 0;
                }
            } else {
                ++this.yawTimer;
            }
        }
        for (int i = 0; i < this.yawArray.length; ++i) {
            this.yawArray[i] = (float)Math.PI / 180 * this.yawVariation / (float)this.pitchArray.length;
        }
    }

    public void calculateChainWaveBuffer(float maxAngle, int bufferTime, float angleDecrement, float divider, EntityLivingBase entity) {
        if (entity.field_70125_A != entity.field_70127_C && MathHelper.func_76135_e((float)this.pitchVariation) < maxAngle) {
            this.pitchVariation += (entity.field_70127_C - entity.field_70125_A) / divider;
        }
        if (this.pitchVariation > 0.7f * angleDecrement) {
            if (this.pitchTimer > bufferTime) {
                this.pitchVariation -= angleDecrement;
                if (MathHelper.func_76135_e((float)this.pitchVariation) < angleDecrement) {
                    this.pitchVariation = 0.0f;
                    this.pitchTimer = 0;
                }
            } else {
                ++this.pitchTimer;
            }
        } else if (this.pitchVariation < -0.7f * angleDecrement) {
            if (this.pitchTimer > bufferTime) {
                this.pitchVariation += angleDecrement;
                if (MathHelper.func_76135_e((float)this.pitchVariation) < angleDecrement) {
                    this.pitchVariation = 0.0f;
                    this.pitchTimer = 0;
                }
            } else {
                ++this.pitchTimer;
            }
        }
        for (int i = 0; i < this.pitchArray.length; ++i) {
            this.pitchArray[i] = (float)Math.PI / 180 * this.pitchVariation / (float)this.pitchArray.length;
        }
    }

    public void calculateChainSwingBuffer(float maxAngle, int bufferTime, float angleDecrement, EntityLivingBase entity) {
        if (entity.field_70761_aq != entity.field_70760_ar && MathHelper.func_76135_e((float)this.yawVariation) < maxAngle) {
            this.yawVariation += entity.field_70760_ar - entity.field_70761_aq;
        }
        if (this.yawVariation > 0.7f * angleDecrement) {
            if (this.yawTimer > bufferTime) {
                this.yawVariation -= angleDecrement;
                if (MathHelper.func_76135_e((float)this.yawVariation) < angleDecrement) {
                    this.yawVariation = 0.0f;
                    this.yawTimer = 0;
                }
            } else {
                ++this.yawTimer;
            }
        } else if (this.yawVariation < -0.7f * angleDecrement) {
            if (this.yawTimer > bufferTime) {
                this.yawVariation += angleDecrement;
                if (MathHelper.func_76135_e((float)this.yawVariation) < angleDecrement) {
                    this.yawVariation = 0.0f;
                    this.yawTimer = 0;
                }
            } else {
                ++this.yawTimer;
            }
        }
        for (int i = 0; i < this.yawArray.length; ++i) {
            this.yawArray[i] = (float)Math.PI / 180 * this.yawVariation / (float)this.pitchArray.length;
        }
    }

    public void calculateChainWaveBuffer(float maxAngle, int bufferTime, float angleDecrement, EntityLivingBase entity) {
        if (entity.field_70125_A != entity.field_70127_C && MathHelper.func_76135_e((float)this.pitchVariation) < maxAngle) {
            this.pitchVariation += entity.field_70127_C - entity.field_70125_A;
        }
        if (this.pitchVariation > 0.7f * angleDecrement) {
            if (this.pitchTimer > bufferTime) {
                this.pitchVariation -= angleDecrement;
                if (MathHelper.func_76135_e((float)this.pitchVariation) < angleDecrement) {
                    this.pitchVariation = 0.0f;
                    this.pitchTimer = 0;
                }
            } else {
                ++this.pitchTimer;
            }
        } else if (this.pitchVariation < -0.7f * angleDecrement) {
            if (this.pitchTimer > bufferTime) {
                this.pitchVariation += angleDecrement;
                if (MathHelper.func_76135_e((float)this.pitchVariation) < angleDecrement) {
                    this.pitchVariation = 0.0f;
                    this.pitchTimer = 0;
                }
            } else {
                ++this.pitchTimer;
            }
        }
        for (int i = 0; i < this.pitchArray.length; ++i) {
            this.pitchArray[i] = (float)Math.PI / 180 * this.pitchVariation / (float)this.pitchArray.length;
        }
    }

    public void applyChainSwingBuffer(AdvancedModelRenderer[] boxes) {
        if (boxes.length == this.yawArray.length) {
            for (int i = 0; i < boxes.length; ++i) {
                boxes[i].field_78796_g += this.yawArray[i];
            }
        } else {
            System.err.println("[LLibrary] Wrong array length being used in the buffer! (Y axis)");
        }
    }

    public void applyChainWaveBuffer(AdvancedModelRenderer[] boxes) {
        if (boxes.length == this.pitchArray.length) {
            for (int i = 0; i < boxes.length; ++i) {
                boxes[i].field_78795_f += this.pitchArray[i];
            }
        } else {
            System.out.println("[LLibrary] Wrong array length being used in the buffer! (X axis)");
        }
    }
}

