/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.client.model.animation;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.ilexiconn.jurassicraft.JurassiCraft;
import net.ilexiconn.jurassicraft.client.model.animation.Transform;
import net.ilexiconn.jurassicraft.common.api.IAnimatedEntity;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.util.MathHelper;

@SideOnly(value=Side.CLIENT)
public class Animator {
    public static final float PI = (float)Math.PI;
    private int tempTick = 0;
    private int prevTempTick;
    private boolean currentAnimation = false;
    private ModelBase mainModel;
    private IAnimatedEntity animatedEntity;
    private HashMap<ModelRenderer, Transform> transformMap;
    private HashMap<ModelRenderer, Transform> prevTransformMap;

    public Animator(ModelBase model) {
        this.mainModel = model;
        this.transformMap = new HashMap();
        this.prevTransformMap = new HashMap();
    }

    public IAnimatedEntity getEntity() {
        return this.animatedEntity;
    }

    public void update(IAnimatedEntity entity) {
        this.prevTempTick = 0;
        this.tempTick = 0;
        this.currentAnimation = false;
        this.animatedEntity = entity;
        this.transformMap.clear();
        this.prevTransformMap.clear();
        for (int i = 0; i < this.mainModel.field_78092_r.size(); ++i) {
            ModelRenderer box = (ModelRenderer)this.mainModel.field_78092_r.get(i);
            box.field_78795_f = 0.0f;
            box.field_78796_g = 0.0f;
            box.field_78808_h = 0.0f;
        }
    }

    public boolean setAnimation(int animationId) {
        this.prevTempTick = 0;
        this.tempTick = 0;
        this.currentAnimation = this.animatedEntity.getAnimationId() == animationId;
        return this.currentAnimation;
    }

    public void startPhase(int duration) {
        if (!this.currentAnimation) {
            return;
        }
        this.prevTempTick = this.tempTick;
        this.tempTick += duration;
    }

    public void setStationaryPhase(int duration) {
        this.startPhase(duration);
        this.endPhase(true);
    }

    public void resetPhase(int duration) {
        this.startPhase(duration);
        this.endPhase();
    }

    public void rotate(ModelRenderer box, float x, float y, float z) {
        if (!this.currentAnimation) {
            return;
        }
        if (!this.transformMap.containsKey(box)) {
            this.transformMap.put(box, new Transform(x, y, z));
        } else {
            this.transformMap.get(box).addRot(x, y, z);
        }
    }

    public void move(ModelRenderer box, float x, float y, float z) {
        if (!this.currentAnimation) {
            return;
        }
        if (!this.transformMap.containsKey(box)) {
            this.transformMap.put(box, new Transform(x, y, z, 0.0f, 0.0f, 0.0f));
        } else {
            this.transformMap.get(box).addOffset(x, y, z);
        }
    }

    public void endPhase() {
        this.endPhase(false);
    }

    private void endPhase(boolean stationary) {
        if (!this.currentAnimation) {
            return;
        }
        int animationTick = this.animatedEntity.getAnimationTick();
        if (animationTick >= this.prevTempTick && animationTick < this.tempTick) {
            if (stationary) {
                for (ModelRenderer box : this.prevTransformMap.keySet()) {
                    Transform transform = this.prevTransformMap.get(box);
                    box.field_78795_f += transform.rotX;
                    box.field_78796_g += transform.rotY;
                    box.field_78808_h += transform.rotZ;
                    box.field_78800_c += transform.offsetX;
                    box.field_78797_d += transform.offsetY;
                    box.field_78798_e += transform.offsetZ;
                }
            } else {
                Transform transform;
                float tick = ((float)(animationTick - this.prevTempTick) + JurassiCraft.proxy.getPartialTick()) / (float)(this.tempTick - this.prevTempTick);
                float inc = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
                float dec = 1.0f - inc;
                for (ModelRenderer box : this.prevTransformMap.keySet()) {
                    transform = this.prevTransformMap.get(box);
                    box.field_78795_f += dec * transform.rotX;
                    box.field_78796_g += dec * transform.rotY;
                    box.field_78808_h += dec * transform.rotZ;
                    box.field_78800_c += dec * transform.offsetX;
                    box.field_78797_d += dec * transform.offsetY;
                    box.field_78798_e += dec * transform.offsetZ;
                }
                for (ModelRenderer box : this.transformMap.keySet()) {
                    transform = this.transformMap.get(box);
                    box.field_78795_f += inc * transform.rotX;
                    box.field_78796_g += inc * transform.rotY;
                    box.field_78808_h += inc * transform.rotZ;
                    box.field_78800_c += inc * transform.offsetX;
                    box.field_78797_d += inc * transform.offsetY;
                    box.field_78798_e += inc * transform.offsetZ;
                }
            }
        }
        if (!stationary) {
            this.prevTransformMap.clear();
            this.prevTransformMap.putAll(this.transformMap);
            this.transformMap.clear();
        }
    }
}

