/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.common.world.gen;

import java.util.List;
import java.util.Random;
import net.ilexiconn.llibrary.common.world.gen.WorldHeightmapGenerator;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.ChunkProviderEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ChunkProviderHeightmap
implements IChunkProvider {
    private Random rand;
    private World worldObj;
    private MapGenScatteredFeature scatteredFeatureGenerator = (MapGenScatteredFeature)TerrainGen.getModdedMapGen((MapGenBase)this.scatteredFeatureGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.SCATTERED_FEATURE);
    private BiomeGenBase[] biomesForGeneration;
    private WorldHeightmapGenerator heightmapGenerator;

    public ChunkProviderHeightmap(World world, long seed, WorldHeightmapGenerator heightmapGenerator) {
        this.worldObj = world;
        this.rand = new Random(seed);
        this.heightmapGenerator = heightmapGenerator;
        if (!heightmapGenerator.isLoaded()) {
            heightmapGenerator.load();
        }
    }

    public void setBlocksInChunk(int chunkX, int chunkZ, ChunkPrimer chunkPrimer) {
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76937_a(this.biomesForGeneration, chunkX * 4 - 2, chunkZ * 4 - 2, 10, 10);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int height = this.heightmapGenerator.getHeightForCoords(x + chunkX * 16, z + chunkZ * 16);
                for (int y = 0; y < Math.max(this.heightmapGenerator.getOceanHeight(x, z), height); ++y) {
                    if (y < height) {
                        chunkPrimer.func_177855_a(x, y, z, this.heightmapGenerator.getStoneBlock());
                        continue;
                    }
                    if (!this.heightmapGenerator.hasOcean()) continue;
                    chunkPrimer.func_177855_a(x, y, z, this.heightmapGenerator.getOceanLiquid());
                }
            }
        }
    }

    public void func_180517_a(int chunkX, int chunkZ, ChunkPrimer chunkPrimer, BiomeGenBase[] biomes) {
        ChunkProviderEvent.ReplaceBiomeBlocks event = new ChunkProviderEvent.ReplaceBiomeBlocks((IChunkProvider)this, chunkX, chunkZ, chunkPrimer, this.worldObj);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return;
        }
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                BiomeGenBase biome = biomes[x + z * 16];
                if (biome == null) continue;
                this.genTerrainBlocks(biome, this.worldObj, this.rand, chunkPrimer, chunkX * 16 + z, chunkZ * 16 + x);
            }
        }
    }

    public void genTerrainBlocks(BiomeGenBase biome, World world, Random random, ChunkPrimer chunkPrimer, int x, int z) {
        IBlockState topBlock = biome.field_76752_A;
        IBlockState fillerBlock = biome.field_76753_B;
        int chunkX = x & 0xF;
        int chunkZ = z & 0xF;
        IBlockState stoneBlock = this.heightmapGenerator.getStoneBlock();
        boolean reachedSurface = false;
        int depthSinceSurface = 0;
        for (int y = 255; y >= 0; --y) {
            if (y <= random.nextInt(5)) {
                chunkPrimer.func_177855_a(chunkZ, y, chunkX, Blocks.field_150357_h.func_176223_P());
                continue;
            }
            IBlockState previousBlock = chunkPrimer.func_177856_a(chunkZ, y, chunkX);
            if (previousBlock.func_177230_c().func_149688_o() == Material.field_151579_a) {
                reachedSurface = true;
                continue;
            }
            if (previousBlock != stoneBlock || !reachedSurface) continue;
            if (depthSinceSurface == 0) {
                chunkPrimer.func_177855_a(chunkZ, y, chunkX, topBlock);
            } else if (depthSinceSurface < 4) {
                chunkPrimer.func_177855_a(chunkZ, y, chunkX, fillerBlock);
            }
            ++depthSinceSurface;
        }
    }

    public Chunk func_73154_d(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.setBlocksInChunk(x, z, chunkprimer);
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.func_180517_a(x, z, chunkprimer, this.biomesForGeneration);
        Chunk chunk = new Chunk(this.worldObj, chunkprimer, x, z);
        byte[] biomeArray = chunk.func_76605_m();
        for (int biomeIndex = 0; biomeIndex < biomeArray.length; ++biomeIndex) {
            biomeArray[biomeIndex] = (byte)this.biomesForGeneration[biomeIndex].field_76756_M;
        }
        chunk.func_76603_b();
        return chunk;
    }

    public boolean func_73149_a(int x, int z) {
        return true;
    }

    public void func_73153_a(IChunkProvider provider, int p_73153_2_, int p_73153_3_) {
        BlockFalling.field_149832_M = true;
        int k = p_73153_2_ * 16;
        int l = p_73153_3_ * 16;
        BlockPos blockpos = new BlockPos(k, 0, l);
        BiomeGenBase biomegenbase = this.worldObj.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.worldObj.func_72905_C());
        long i1 = this.rand.nextLong() / 2L * 2L + 1L;
        long j1 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)p_73153_2_ * i1 + (long)p_73153_3_ * j1 ^ this.worldObj.func_72905_C());
        boolean flag = false;
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(provider, this.worldObj, this.rand, p_73153_2_, p_73153_3_, flag));
        biomegenbase.func_180624_a(this.worldObj, this.rand, new BlockPos(k, 0, l));
        if (TerrainGen.populate((IChunkProvider)provider, (World)this.worldObj, (Random)this.rand, (int)p_73153_2_, (int)p_73153_3_, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            SpawnerAnimals.func_77191_a((World)this.worldObj, (BiomeGenBase)biomegenbase, (int)(k + 8), (int)(l + 8), (int)16, (int)16, (Random)this.rand);
        }
        blockpos = blockpos.func_177982_a(8, 0, 8);
        boolean doGen = TerrainGen.populate((IChunkProvider)provider, (World)this.worldObj, (Random)this.rand, (int)p_73153_2_, (int)p_73153_3_, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE);
        for (int k1 = 0; doGen && k1 < 16; ++k1) {
            for (int l1 = 0; l1 < 16; ++l1) {
                BlockPos blockpos1 = this.worldObj.func_175725_q(blockpos.func_177982_a(k1, 0, l1));
                BlockPos blockpos2 = blockpos1.func_177977_b();
                if (this.worldObj.func_175675_v(blockpos2)) {
                    this.worldObj.func_180501_a(blockpos2, Blocks.field_150432_aD.func_176223_P(), 2);
                }
                if (!this.worldObj.func_175708_f(blockpos1, true)) continue;
                this.worldObj.func_180501_a(blockpos1, Blocks.field_150431_aC.func_176223_P(), 2);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(provider, this.worldObj, this.rand, p_73153_2_, p_73153_3_, flag));
        BlockFalling.field_149832_M = false;
    }

    public boolean func_177460_a(IChunkProvider provider, Chunk chunk, int x, int y) {
        return false;
    }

    public boolean func_73151_a(boolean saveAll, IProgressUpdate progressUpdate) {
        return true;
    }

    public void func_104112_b() {
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "RandomLevelSource";
    }

    public List<BiomeGenBase.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        return this.worldObj.func_180494_b(pos).func_76747_a(creatureType);
    }

    public BlockPos func_180513_a(World world, String gen, BlockPos pos) {
        return pos;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_180514_a(Chunk chunk, int x, int z) {
    }

    public Chunk func_177459_a(BlockPos pos) {
        return this.func_73154_d(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }
}

