/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.common.web;

import com.google.common.collect.Lists;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import net.ilexiconn.llibrary.LLibrary;

public class WebHelper {
    private static String pastebinURLPrefix = "http://pastebin.com/raw.php?i=";

    public static List<String> readPastebinAsList(String pasteId) {
        return WebHelper.readPastebinAsList(new String[]{pasteId});
    }

    public static String readPastebin(String pasteId) {
        return WebHelper.readPastebin(new String[]{pasteId});
    }

    public static List<String> downloadTextFileList(String urlString) {
        return WebHelper.downloadTextFileList(new String[]{urlString});
    }

    public static String downloadTextFile(String urlString) {
        return WebHelper.downloadTextFile(new String[]{urlString});
    }

    public static byte[] download(String urlString) {
        return WebHelper.download(new String[]{urlString});
    }

    public static BufferedImage downloadImage(String urlString) {
        return WebHelper.downloadImage(new String[]{urlString});
    }

    public static List<String> readPastebinAsList(String[] pasteIds) {
        for (int i = 0; i < pasteIds.length; ++i) {
            pasteIds[i] = pastebinURLPrefix + pasteIds[i];
        }
        return WebHelper.downloadTextFileList(pasteIds);
    }

    public static String readPastebin(String[] pasteIds) {
        for (int i = 0; i < pasteIds.length; ++i) {
            pasteIds[i] = pastebinURLPrefix + pasteIds[i];
        }
        return WebHelper.downloadTextFile(pasteIds);
    }

    public static List<String> downloadTextFileList(String[] urlStrings) {
        for (String urlString : urlStrings) {
            try {
                String currentLine;
                ArrayList text = Lists.newArrayList();
                URL url = new URL(urlString);
                BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
                while ((currentLine = reader.readLine()) != null) {
                    text.add(currentLine);
                }
                reader.close();
                return text;
            }
            catch (IOException e) {
                LLibrary.logger.error("Failed receiving data from url '" + urlString + "'. (" + e.getLocalizedMessage() + ")");
            }
        }
        LLibrary.logger.error("None of the given urls worked! " + Arrays.toString(urlStrings));
        return null;
    }

    public static String downloadTextFile(String[] urlStrings) {
        for (String urlString : urlStrings) {
            try {
                String currentLine;
                String text = "";
                URL url = new URL(urlString);
                BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
                while ((currentLine = reader.readLine()) != null) {
                    text = text + currentLine + "\r\n";
                }
                reader.close();
                return text;
            }
            catch (IOException e) {
                LLibrary.logger.error("Failed receiving data from url '" + urlString + "'. (" + e.getLocalizedMessage() + ")");
            }
        }
        LLibrary.logger.error("None of the given urls worked! " + Arrays.toString(urlStrings));
        return null;
    }

    public static byte[] download(String[] urlStrings) {
        for (String urlString : urlStrings) {
            try {
                int k;
                URL url = new URL(urlString);
                InputStream in = url.openStream();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                while ((k = in.read(buffer)) != -1) {
                    baos.write(buffer, 0, k);
                }
                baos.flush();
                return baos.toByteArray();
            }
            catch (IOException e) {
                LLibrary.logger.error("Failed receiving data from url '" + urlString + "'. (" + e.getLocalizedMessage() + ")");
            }
        }
        LLibrary.logger.error("None of the given urls worked! " + Arrays.toString(urlStrings));
        return null;
    }

    public static BufferedImage downloadImage(String[] urlStrings) {
        for (String urlString : urlStrings) {
            try {
                URL url = new URL(urlString);
                BufferedInputStream in = new BufferedInputStream(url.openStream());
                return ImageIO.read(in);
            }
            catch (IOException e) {
                LLibrary.logger.error("Failed receiving data from url '" + urlString + "'. (" + e.getLocalizedMessage() + ")");
            }
        }
        LLibrary.logger.error("None of the given urls worked! " + Arrays.toString(urlStrings));
        return null;
    }
}

