/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.common.save;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.ilexiconn.llibrary.common.save.ISaveHandler;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.chunk.storage.IChunkLoader;

public class SaveHelper {
    public static ArrayList<ISaveHandler> saveHandlers = Lists.newArrayList();

    public static void registerSaveHandler(ISaveHandler handler) {
        saveHandlers.add(handler);
    }

    public static void unregisterSaveHandler(ISaveHandler handler) {
        saveHandlers.remove(handler);
    }

    public static void load(net.minecraft.world.storage.ISaveHandler saveHandler, World world) {
        if (world.field_73011_w.func_177502_q() == 0) {
            for (ISaveHandler handler : saveHandlers) {
                String[] saveFileNames;
                for (String saveFileName : saveFileNames = handler.getSaveFiles()) {
                    File fileBackup;
                    File file;
                    ISaveHandler.SaveType saveFileType = handler.getSaveFileType(saveFileName);
                    if (saveFileType == ISaveHandler.SaveType.OBJECT) {
                        try {
                            file = SaveHelper.getSaveFile(saveHandler, world, saveFileName + ".dat", false);
                            if (file == null) continue;
                            try {
                                SaveHelper.loadFile(handler, saveFileName, file);
                            }
                            catch (Exception e) {
                                fileBackup = SaveHelper.getSaveFile(saveHandler, world, saveFileName + ".dat", true);
                                if (fileBackup.exists()) {
                                    SaveHelper.loadFile(handler, saveFileName, fileBackup);
                                    continue;
                                }
                                file.createNewFile();
                                SaveHelper.saveFile(handler, saveFileName, file);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    if (saveFileType != ISaveHandler.SaveType.NBT) continue;
                    try {
                        file = SaveHelper.getSaveFile(saveHandler, world, saveFileName + ".dat", false);
                        if (file == null) continue;
                        try {
                            SaveHelper.loadFileNBT(handler, saveFileName, file);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            fileBackup = SaveHelper.getSaveFile(saveHandler, world, saveFileName + ".dat", true);
                            if (fileBackup.exists()) {
                                SaveHelper.loadFileNBT(handler, saveFileName, fileBackup);
                                continue;
                            }
                            file.createNewFile();
                            SaveHelper.saveFileNBT(handler, saveFileName, file);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private static void loadFile(ISaveHandler saveHandler, String fileName, File file) throws Exception {
        FileInputStream fis = new FileInputStream(file.getAbsolutePath());
        GZIPInputStream gzis = new GZIPInputStream(fis);
        ObjectInputStream in = new ObjectInputStream(gzis);
        saveHandler.load(fileName, file, in);
        in.close();
        gzis.close();
        fis.close();
    }

    private static void loadFileNBT(ISaveHandler saveHandler, String fileName, File file) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)fis);
        fis.close();
        saveHandler.loadNBT(fileName, file, nbt);
    }

    public static void save(net.minecraft.world.storage.ISaveHandler saveHandler, World world) {
        if (world.field_73011_w.func_177502_q() == 0) {
            for (ISaveHandler handler : saveHandlers) {
                String[] saveFileNames;
                for (String saveFileName : saveFileNames = handler.getSaveFiles()) {
                    File file;
                    ISaveHandler.SaveType saveFileType = handler.getSaveFileType(saveFileName);
                    if (saveFileType == ISaveHandler.SaveType.OBJECT) {
                        try {
                            file = SaveHelper.getSaveFile(saveHandler, world, saveFileName + ".dat", false);
                            SaveHelper.saveFile(handler, saveFileName, file);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    if (saveFileType != ISaveHandler.SaveType.NBT) continue;
                    try {
                        file = SaveHelper.getSaveFile(saveHandler, world, saveFileName + ".dat", false);
                        SaveHelper.saveFileNBT(handler, saveFileName, file);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static void saveFile(ISaveHandler saveHandler, String fileName, File file) throws Exception {
        FileOutputStream fos = new FileOutputStream(file);
        GZIPOutputStream gzos = new GZIPOutputStream(fos);
        ObjectOutputStream out = new ObjectOutputStream(gzos);
        saveHandler.save(fileName, file, out);
        out.flush();
        out.close();
        gzos.close();
        fos.close();
        SaveHelper.copyFile(file, new File(file.getAbsolutePath() + ".bak"));
    }

    public static void saveFileNBT(ISaveHandler saveHandler, String fileName, File file) throws Exception {
        NBTTagCompound nbt = new NBTTagCompound();
        saveHandler.saveNBT(fileName, file, nbt);
        FileOutputStream fos = new FileOutputStream(file);
        CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)fos);
        fos.close();
        SaveHelper.copyFile(file, new File(file.getAbsolutePath() + ".bak"));
    }

    public static File getSaveFile(net.minecraft.world.storage.ISaveHandler saveHandler, World world, String name, boolean backup) {
        File file;
        File worldDir = new File(saveHandler.func_75760_g());
        IChunkLoader loader = saveHandler.func_75763_a(world.field_73011_w);
        if (loader instanceof AnvilChunkLoader) {
            worldDir = ((AnvilChunkLoader)loader).field_75825_d;
        }
        if (!(file = new File(worldDir, name + (backup ? ".bak" : ""))).exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    public static void copyFile(File sourceFile, File destFile) {
        try {
            if (!destFile.exists()) {
                destFile.createNewFile();
            }
            FileInputStream in = new FileInputStream(sourceFile);
            FileOutputStream out = new FileOutputStream(destFile);
            FileChannel source = in.getChannel();
            FileChannel destination = out.getChannel();
            destination.transferFrom(source, 0L, source.size());
            in.close();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

