/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.common.nbt.io;

import java.lang.reflect.Field;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.common.crash.SimpleCrashReport;
import net.ilexiconn.llibrary.common.nbt.NbtHelper;
import net.minecraft.nbt.NBTTagCompound;

public class NBTIO {
    public static <T> T fromNbt(NBTTagCompound tag, Class<T> type) {
        try {
            Field[] fields;
            T t = type.newInstance();
            if (tag.func_82582_d()) {
                return t;
            }
            for (Field field : fields = type.getFields()) {
                if (!tag.func_74764_b(field.getName())) continue;
                Object value = NbtHelper.getValueFromNbtTag(tag.func_74781_a(field.getName()));
                if (field.getType().equals(Boolean.TYPE) || field.getType().equals(Boolean.class)) {
                    value = (Byte)value != 0;
                }
                field.setAccessible(true);
                field.set(t, value);
            }
            return t;
        }
        catch (Exception e) {
            LLibrary.logger.error(SimpleCrashReport.makeCrashReport(e, "Unable to load " + type + " from nbt " + tag));
            return null;
        }
    }

    public static void toNbt(NBTTagCompound tag, Object object) {
        Class<?> type = object.getClass();
        try {
            Field[] fields;
            for (Field field : fields = type.getFields()) {
                tag.func_74782_a(field.getName(), NbtHelper.getNbtTagFromValue(field.get(object)));
            }
        }
        catch (Exception e) {
            LLibrary.logger.error(SimpleCrashReport.makeCrashReport(e, "Unable to save " + type + " to nbt " + tag));
        }
    }
}

