/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.common.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.common.crash.SimpleCrashReport;
import net.ilexiconn.llibrary.common.json.JsonFactory;
import org.apache.commons.io.IOUtils;

public class JsonConfigHelper {
    public static <T> T loadConfig(File f, Class<T> t) {
        if (!f.exists()) {
            try {
                return t.newInstance();
            }
            catch (Exception e) {
                LLibrary.logger.error(SimpleCrashReport.makeCrashReport(e, "Failed making a new instance of " + t.getName()));
                return null;
            }
        }
        try {
            return (T)JsonFactory.getGson().fromJson((Reader)new FileReader(f), t);
        }
        catch (FileNotFoundException e) {
            LLibrary.logger.error(SimpleCrashReport.makeCrashReport(e, "Couldn't find config file " + f.getName()));
            return null;
        }
    }

    public static <T> T saveConfig(T t, File f) {
        String json = JsonFactory.getPrettyGson().toJson(t);
        try {
            if (!f.exists()) {
                f.createNewFile();
            }
            IOUtils.write((byte[])json.getBytes(), (OutputStream)new FileOutputStream(f));
        }
        catch (IOException e) {
            LLibrary.logger.error(SimpleCrashReport.makeCrashReport(e, "Couldn't write to file " + f.getName()));
        }
        return t;
    }
}

