/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.common.command.builder;

import net.ilexiconn.llibrary.common.command.builder.ArgumentType;
import net.ilexiconn.llibrary.common.command.builder.Command;
import net.ilexiconn.llibrary.common.command.builder.ICommandExecutor;
import net.minecraft.command.ICommand;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

public class CommandBuilder {
    private Command command = new Command();

    private CommandBuilder(String commandName, String commandUsage) {
        this.command.commandName = commandName;
        this.command.commandUsage = commandUsage;
    }

    public static CommandBuilder create(String commandName, String commandUsage) {
        return new CommandBuilder(commandName, commandUsage);
    }

    public static CommandBuilder create(String commandName) {
        return new CommandBuilder(commandName, null);
    }

    public CommandBuilder withAlias(String alias) {
        this.command.commandAliases.add(alias);
        return this;
    }

    public CommandBuilder withUsage(String usage) {
        this.command.commandUsage = usage;
        return this;
    }

    public CommandBuilder withRequiredPermissionLevel(int permissionLevel) {
        this.command.requiredPermissionLevel = permissionLevel;
        return this;
    }

    @Deprecated
    public CommandBuilder withRequiredArgument(String argument) {
        return this.withRequiredArgument(argument, ArgumentType.STRING);
    }

    public CommandBuilder withRequiredArgument(String argument, ArgumentType<?> type) {
        this.command.requiredArguments.put(argument, type);
        return this;
    }

    @Deprecated
    public CommandBuilder withOptionalArgument(String argument) {
        return this.withOptionalArgument(argument, ArgumentType.STRING);
    }

    public CommandBuilder withOptionalArgument(String argument, ArgumentType<?> type) {
        this.command.optionalArguments.put(argument, type);
        return this;
    }

    public CommandBuilder register(FMLServerStartingEvent event, ICommandExecutor executor) {
        this.command.commandExecutor = executor;
        event.registerServerCommand((ICommand)this.command);
        return this;
    }
}

