/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.common.animation;

import net.minecraft.util.MathHelper;

public class ControlledAnimation {
    protected int prevTimer = 0;
    protected int timer = 0;
    protected int duration;
    protected int timerChange;

    public ControlledAnimation(int d) {
        this.duration = d;
    }

    public void setDuration(int d) {
        this.prevTimer = 0;
        this.timer = 0;
        this.duration = d;
    }

    public int getTimer() {
        return this.timer;
    }

    public void setTimer(int time) {
        this.timer = time;
        if (this.timer > this.duration) {
            this.timer = this.duration;
        } else if (this.timer < 0) {
            this.timer = 0;
        }
    }

    public void resetTimer() {
        this.timer = 0;
    }

    public void update() {
        this.prevTimer = this.timer;
    }

    public void increaseTimer() {
        if (this.timer < this.duration) {
            ++this.timer;
            this.timerChange = 1;
        }
    }

    public boolean canIncreaseTimer() {
        return this.timer < this.duration;
    }

    public void increaseTimer(int time) {
        int newTime = this.timer + time;
        this.timer = newTime <= this.duration && newTime >= 0 ? newTime : (newTime < 0 ? 0 : this.duration);
    }

    public void decreaseTimer() {
        if (this.timer > 0) {
            --this.timer;
            this.timerChange = -1;
        }
    }

    public boolean canDecreaseTimer() {
        return this.timer > 0;
    }

    public void decreaseTimer(int time) {
        this.timer = this.timer - time > 0 ? (this.timer -= time) : 0;
    }

    public float getAnimationFraction(float partialRenderTicks) {
        return ((float)this.prevTimer + (float)(this.timer - this.prevTimer) * partialRenderTicks) / (float)this.duration;
    }

    public float getAnimationProgressSmooth(float partialRenderTicks) {
        if (this.timer > 0) {
            if (this.timer < this.duration) {
                return (float)(1.0 / (1.0 + Math.exp(4.0 - 8.0 * (double)this.getAnimationFraction(partialRenderTicks))));
            }
            return 1.0f;
        }
        return 0.0f;
    }

    public float getAnimationProgressSteep(float partialRenderTicks) {
        return (float)(1.0 / (1.0 + Math.exp(6.0 - 12.0 * (double)this.getAnimationFraction(partialRenderTicks))));
    }

    public float getAnimationProgressSin(float partialRenderTicks) {
        return MathHelper.func_76126_a((float)(1.5707964f * this.getAnimationFraction(partialRenderTicks)));
    }

    public float getAnimationProgressSinSqrt(float partialRenderTicks) {
        float result = MathHelper.func_76126_a((float)(1.5707964f * this.getAnimationFraction(partialRenderTicks)));
        return result * result;
    }

    public float getAnimationProgressSinToTen(float partialRenderTicks) {
        return (float)Math.pow(MathHelper.func_76126_a((float)(1.5707964f * this.getAnimationFraction(partialRenderTicks))), 10.0);
    }

    public float getAnimationProgressSinToTenWithoutReturn(float partialRenderTicks) {
        float t = this.getAnimationFraction(partialRenderTicks);
        if (this.timerChange == -1) {
            return MathHelper.func_76126_a((float)(1.5707964f * t)) * MathHelper.func_76126_a((float)(1.5707964f * t));
        }
        return (float)Math.pow(MathHelper.func_76126_a((float)(1.5707964f * t)), 10.0);
    }

    public float getAnimationProgressSinPowerOf(float partialRenderTicks, int i) {
        return (float)Math.pow(MathHelper.func_76126_a((float)(1.5707964f * this.getAnimationFraction(partialRenderTicks))), i);
    }

    public float getAnimationProgressPoly2(float partialRenderTicks) {
        float x = this.getAnimationFraction(partialRenderTicks);
        float x2 = x * x;
        return x2 / (x2 + (1.0f - x) * (1.0f - x));
    }

    public float getAnimationProgressPoly3(float partialRenderTicks) {
        float x = this.getAnimationFraction(partialRenderTicks);
        float x3 = x * x * x;
        return x3 / (x3 + (1.0f - x) * (1.0f - x) * (1.0f - x));
    }

    public float getAnimationProgressPolyN(float partialRenderTicks, int n) {
        double x = this.getAnimationFraction(partialRenderTicks);
        double xi = Math.pow(x, n);
        return (float)(xi / (xi + Math.pow(1.0 - x, n)));
    }

    public float getAnimationProgressArcTan(float partialRenderTicks) {
        return (float)(0.5 + (double)0.4980651f * Math.atan(3.14159265359 * ((double)this.getAnimationFraction(partialRenderTicks) - 0.5)));
    }

    public float getAnimationProgressTemporary(float partialRenderTicks) {
        float x = (float)Math.PI * 2 * this.getAnimationFraction(partialRenderTicks);
        return 0.5f - 0.5f * MathHelper.func_76134_b((float)(x + MathHelper.func_76126_a((float)x)));
    }

    public float getAnimationProgressTemporaryFS(float partialRenderTicks) {
        float x = (float)Math.PI * this.getAnimationFraction(partialRenderTicks);
        return MathHelper.func_76126_a((float)(x + MathHelper.func_76126_a((float)x)));
    }

    public float getAnimationProgressTemporaryInvesed(float partialRenderTicks) {
        float x = (float)Math.PI * 2 * this.getAnimationFraction(partialRenderTicks);
        return 0.5f + 0.5f * MathHelper.func_76134_b((float)(x + MathHelper.func_76126_a((float)x)));
    }
}

