/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.common.animation;

import com.google.common.collect.Maps;
import java.util.Map;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.common.animation.IAnimated;
import net.ilexiconn.llibrary.common.animation.IAnimationAction;
import net.ilexiconn.llibrary.common.message.MessageLLibraryAnimation;
import net.ilexiconn.llibrary.common.message.MessageLLibraryAnimationAction;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class Animation {
    public Map<Integer, IAnimationAction> actions = Maps.newHashMap();
    public int animationId;
    public int duration;

    public Animation(int id, int d) {
        this.animationId = id;
        this.duration = d;
    }

    public static void sendAnimationPacket(IAnimated entity, Animation animation) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        entity.setAnimation(animation);
        LLibrary.networkWrapper.sendToAll((IMessage)new MessageLLibraryAnimation(animation.animationId, ((Entity)entity).func_145782_y()));
    }

    public static void tickAnimations(IAnimated entity) {
        if (entity.getAnimation() == null) {
            entity.setAnimation(entity.animations()[0]);
        } else if (entity.getAnimation().animationId != 0) {
            if (entity.getAnimationTick() == 0) {
                Animation.sendAnimationPacket(entity, entity.getAnimation());
            }
            if (entity.getAnimation().actions.containsKey(entity.getAnimationTick())) {
                entity.getAnimation().actions.get(entity.getAnimationTick()).execute(entity.getAnimationTick(), (Entity)entity);
                LLibrary.networkWrapper.sendToAll((IMessage)new MessageLLibraryAnimationAction(entity.getAnimation().animationId, ((Entity)entity).func_145782_y(), entity.getAnimationTick()));
            }
            if (entity.getAnimationTick() < entity.getAnimation().duration) {
                entity.setAnimationTick(entity.getAnimationTick() + 1);
            }
            if (entity.getAnimationTick() == entity.getAnimation().duration) {
                entity.setAnimationTick(0);
                entity.setAnimation(entity.animations()[0]);
            }
        }
    }

    public void registerAction(int tick, IAnimationAction action) {
        this.actions.put(tick, action);
    }
}

