/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.asm;

import com.google.common.base.Objects;
import java.io.IOException;
import net.ilexiconn.llibrary.asm.MCPRemapper;
import net.ilexiconn.llibrary.asm.ObfRemapper;
import net.minecraft.launchwrapper.Launch;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class ObfMapping {
    public static ObfRemapper obfMapper = new ObfRemapper();
    public static Remapper mcpMapper = null;
    public static final boolean obfuscated;
    public String owner;
    public String name;
    public String desc;

    public static void loadMCPRemapper() {
        if (mcpMapper == null) {
            mcpMapper = new MCPRemapper();
        }
    }

    public ObfMapping(String owner) {
        this(owner, "", "");
    }

    public ObfMapping(String owner, String name, String desc) {
        this.owner = owner;
        this.name = name;
        this.desc = desc;
        if (owner.contains(".")) {
            throw new IllegalArgumentException(owner);
        }
    }

    public ObfMapping(ObfMapping descmap, String subclass) {
        this(subclass, descmap.name, descmap.desc);
    }

    public ObfMapping copy() {
        return new ObfMapping(this.owner, this.name, this.desc);
    }

    public ObfMapping subclass(String subclass) {
        return new ObfMapping(this, subclass);
    }

    public ObfMapping map(Remapper mapper) {
        if (mapper == null) {
            return this;
        }
        if (this.isMethod()) {
            this.name = mapper.mapMethodName(this.owner, this.name, this.desc);
        } else if (this.isField()) {
            this.name = mapper.mapFieldName(this.owner, this.name, this.desc);
        }
        this.owner = mapper.mapType(this.owner);
        if (this.isMethod()) {
            this.desc = mapper.mapMethodDesc(this.desc);
        } else if (this.desc.length() > 0) {
            this.desc = mapper.mapDesc(this.desc);
        }
        return this;
    }

    public ObfMapping toRuntime() {
        this.map(mcpMapper);
        return this;
    }

    public ObfMapping toClassloading() {
        if (!obfuscated) {
            this.map(mcpMapper);
        } else if (obfMapper.isObf(this.owner)) {
            this.map(obfMapper);
        }
        return this;
    }

    public AbstractInsnNode toInsn(int opcode) {
        if (this.isClass()) {
            return new TypeInsnNode(opcode, this.owner);
        }
        if (this.isMethod()) {
            return new MethodInsnNode(opcode, this.owner, this.name, this.desc);
        }
        return new FieldInsnNode(opcode, this.owner, this.name, this.desc);
    }

    public void visitTypeInsn(MethodVisitor mv, int opcode) {
        mv.visitTypeInsn(opcode, this.owner);
    }

    public void visitMethodInsn(MethodVisitor mv, int opcode) {
        mv.visitMethodInsn(opcode, this.owner, this.name, this.desc);
    }

    public void visitFieldInsn(MethodVisitor mv, int opcode) {
        mv.visitFieldInsn(opcode, this.owner, this.name, this.desc);
    }

    public MethodVisitor visitMethod(ClassVisitor visitor, int access, String[] exceptions) {
        return visitor.visitMethod(access, this.name, this.desc, null, exceptions);
    }

    public FieldVisitor visitField(ClassVisitor visitor, int access, Object value) {
        return visitor.visitField(access, this.name, this.desc, null, value);
    }

    public boolean isClass(String name) {
        return name.replace('.', '/').equals(this.owner);
    }

    public boolean matches(String name, String desc) {
        return name.equals(name) && desc.equals(desc);
    }

    public boolean matches(MethodNode node) {
        return this.name.equals(node.name) && this.desc.equals(node.desc);
    }

    public boolean matches(MethodInsnNode node) {
        return this.owner.equals(node.owner) && this.name.equals(node.name) && this.desc.equals(node.desc);
    }

    public boolean matches(FieldNode node) {
        return this.name.equals(node.name) && this.desc.equals(node.desc);
    }

    public boolean matches(FieldInsnNode node) {
        return this.owner.equals(node.owner) && this.name.equals(node.name) && this.desc.equals(node.desc);
    }

    public boolean isClass() {
        return this.name.length() == 0;
    }

    public boolean isMethod() {
        return this.desc.contains("(");
    }

    public boolean isField() {
        return !this.isClass() && !this.isMethod();
    }

    public String javaClass() {
        return this.owner.replace('/', '.');
    }

    public String methodDesc() {
        return this.owner + "." + this.name + this.desc;
    }

    public String fieldDesc() {
        return this.owner + "." + this.name + ":" + this.desc;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ObfMapping)) {
            return false;
        }
        ObfMapping desc = (ObfMapping)obj;
        return this.owner.equals(desc.owner) && this.name.equals(desc.name) && desc.equals(desc.desc);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.desc, this.name, this.owner});
    }

    public String toString() {
        if (this.isClass()) {
            return "[" + this.owner + "]";
        }
        if (this.desc.length() == 0) {
            return "[" + this.owner + "." + this.name + "]";
        }
        return "[" + (this.isMethod() ? this.methodDesc() : this.fieldDesc()) + "]";
    }

    public static ObfMapping fromDesc(String s) {
        int sep;
        int lastDot = s.lastIndexOf(46);
        if (lastDot < 0) {
            return new ObfMapping(s, "", "");
        }
        int sep_end = sep = s.indexOf(40);
        if (sep < 0) {
            sep = s.indexOf(32);
            sep_end = sep + 1;
        }
        if (sep < 0) {
            sep = s.indexOf(58);
            sep_end = sep + 1;
        }
        if (sep < 0) {
            return new ObfMapping(s.substring(0, lastDot), s.substring(lastDot + 1), "");
        }
        return new ObfMapping(s.substring(0, lastDot), s.substring(lastDot + 1, sep), s.substring(sep_end));
    }

    static {
        boolean obf = true;
        try {
            obf = Launch.classLoader.getClassBytes("net.minecraft.world.World") == null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        obfuscated = obf;
        if (!obf) {
            ObfMapping.loadMCPRemapper();
        }
    }
}

