/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.asm;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.io.LineProcessor;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import javax.swing.JFileChooser;
import net.ilexiconn.llibrary.common.config.ConfigHelper;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.relauncher.FMLInjectionData;
import org.objectweb.asm.commons.Remapper;

public class MCPRemapper
extends Remapper
implements LineProcessor<Void> {
    private static final int DIR_GUESSES = 4;
    private static final int DIR_ASKS = 3;
    private HashMap<String, String> fields = new HashMap();
    private HashMap<String, String> funcs = new HashMap();

    public MCPRemapper() {
        File[] mappings = MCPRemapper.getConfFiles();
        try {
            Resources.readLines((URL)mappings[1].toURI().toURL(), (Charset)Charsets.UTF_8, (LineProcessor)this);
            Resources.readLines((URL)mappings[2].toURI().toURL(), (Charset)Charsets.UTF_8, (LineProcessor)this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String mapMethodName(String owner, String name, String desc) {
        String s = this.funcs.get(name);
        return s == null ? name : s;
    }

    public String mapFieldName(String owner, String name, String desc) {
        String s = this.fields.get(name);
        return s == null ? name : s;
    }

    public boolean processLine(String line) throws IOException {
        int i = line.indexOf(44);
        String srg = line.substring(0, i);
        int i2 = i + 1;
        i = line.indexOf(44, i2);
        String mcp = line.substring(i2, i);
        (srg.startsWith("func") ? this.funcs : this.fields).put(srg, mcp);
        return true;
    }

    public Void getResult() {
        return null;
    }

    public static File[] getConfFiles() {
        if (!Strings.isNullOrEmpty((String)System.getProperty("net.minecraftforge.gradle.GradleStart.srgDir"))) {
            File srgDir = new File(System.getProperty("net.minecraftforge.gradle.GradleStart.srgDir"));
            File csvDir = new File(System.getProperty("net.minecraftforge.gradle.GradleStart.csvDir"));
            if (srgDir.exists() && csvDir.exists()) {
                File srg = new File(srgDir, "notch-srg.srg");
                File fieldCsv = new File(csvDir, "fields.csv");
                File methodCsv = new File(csvDir, "methods.csv");
                if (srg.exists() && fieldCsv.exists() && methodCsv.exists()) {
                    return new File[]{srg, fieldCsv, methodCsv};
                }
            }
        }
        for (int i = 0; i < 7; ++i) {
            File[] mappings;
            File dir = MCPRemapper.confDirectoryGuess(i, "");
            if (dir == null || dir.isFile()) continue;
            try {
                mappings = MCPRemapper.parseConfDir(dir);
            }
            catch (Exception e) {
                if (i < 4) continue;
                e.printStackTrace();
                continue;
            }
            ConfigHelper.getConfigContainer("llibrary").getConfiguration().get("general", "mappingDir", "").set(dir.getPath());
            return mappings;
        }
        throw new RuntimeException("Failed to select mappings directory, set it manually in the config");
    }

    public static File confDirectoryGuess(int i, String tag) {
        File mcDir = (File)FMLInjectionData.data()[6];
        switch (i) {
            case 0: {
                return tag != "" ? new File(tag) : null;
            }
            case 1: {
                return new File(mcDir, "../conf");
            }
            case 2: {
                return new File(mcDir, "../build/unpacked/conf");
            }
            case 3: {
                return new File(System.getProperty("user.home"), ".gradle/caches/minecraft/net/minecraftforge/forge/" + FMLInjectionData.data()[4] + "-" + ForgeVersion.getVersion() + "/unpacked/conf");
            }
        }
        JFileChooser fc = new JFileChooser(mcDir);
        fc.setFileSelectionMode(1);
        fc.setDialogTitle("Select an mcp conf dir for the deobfuscator.");
        int ret = fc.showDialog(null, "Select");
        return ret == 0 ? fc.getSelectedFile() : null;
    }

    public static File[] parseConfDir(File confDir) {
        File methods;
        File srgs;
        File srgDir = new File(confDir, "conf");
        if (!srgDir.exists()) {
            srgDir = confDir;
        }
        if (!(srgs = new File(srgDir, "packaged.srg")).exists()) {
            srgs = new File(srgDir, "joined.srg");
        }
        if (!srgs.exists()) {
            throw new RuntimeException("Could not find packaged.srg or joined.srg");
        }
        File mapDir = new File(confDir, "mappings");
        if (!mapDir.exists()) {
            mapDir = confDir;
        }
        if (!(methods = new File(mapDir, "methods.csv")).exists()) {
            throw new RuntimeException("Could not find methods.csv");
        }
        File fields = new File(mapDir, "fields.csv");
        if (!fields.exists()) {
            throw new RuntimeException("Could not find fields.csv");
        }
        return new File[]{srgs, methods, fields};
    }
}

