/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.model.qubble;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;

public class QubbleCuboid
implements INBTSerializable<NBTTagCompound> {
    private String name;
    private List<QubbleCuboid> children = new ArrayList<QubbleCuboid>();
    private int dimensionX = 1;
    private int dimensionY = 1;
    private int dimensionZ = 1;
    private float positionX;
    private float positionY;
    private float positionZ;
    private float offsetX;
    private float offsetY;
    private float offsetZ;
    private float rotationX;
    private float rotationY;
    private float rotationZ;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float scaleZ = 1.0f;
    private int textureX;
    private int textureY;
    private boolean textureMirrored;
    private float opacity;

    private QubbleCuboid() {
    }

    public static QubbleCuboid create(String name) {
        QubbleCuboid cuboid = new QubbleCuboid();
        cuboid.setName(name);
        return cuboid;
    }

    public static QubbleCuboid deserialize(NBTTagCompound compound) {
        QubbleCuboid cuboid = new QubbleCuboid();
        cuboid.deserializeNBT(compound);
        return cuboid;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("name", this.name);
        NBTTagList childrenTag = new NBTTagList();
        for (QubbleCuboid cuboid : this.children) {
            childrenTag.func_74742_a((NBTBase)cuboid.serializeNBT());
        }
        compound.func_74782_a("children", (NBTBase)childrenTag);
        if (this.dimensionX != 1 || this.dimensionY != 1 || this.dimensionZ != 1) {
            NBTTagCompound dimensionTag = new NBTTagCompound();
            dimensionTag.func_74768_a("x", this.dimensionX);
            dimensionTag.func_74768_a("y", this.dimensionY);
            dimensionTag.func_74768_a("z", this.dimensionZ);
            compound.func_74782_a("dimension", (NBTBase)dimensionTag);
        }
        if (this.positionX != 0.0f || this.positionY != 0.0f || this.positionZ != 0.0f) {
            NBTTagCompound positionTag = new NBTTagCompound();
            positionTag.func_74776_a("x", this.positionX);
            positionTag.func_74776_a("y", this.positionY);
            positionTag.func_74776_a("z", this.positionZ);
            compound.func_74782_a("position", (NBTBase)positionTag);
        }
        if (this.offsetX != 0.0f || this.offsetY != 0.0f || this.offsetZ != 0.0f) {
            NBTTagCompound offsetTag = new NBTTagCompound();
            offsetTag.func_74776_a("x", this.offsetX);
            offsetTag.func_74776_a("y", this.offsetY);
            offsetTag.func_74776_a("z", this.offsetZ);
            compound.func_74782_a("offset", (NBTBase)offsetTag);
        }
        if (this.rotationX != 0.0f || this.rotationY != 0.0f || this.rotationZ != 0.0f) {
            NBTTagCompound rotationTag = new NBTTagCompound();
            rotationTag.func_74776_a("x", this.rotationX);
            rotationTag.func_74776_a("y", this.rotationY);
            rotationTag.func_74776_a("z", this.rotationZ);
            compound.func_74782_a("rotation", (NBTBase)rotationTag);
        }
        if (this.scaleX != 1.0f || this.scaleY != 1.0f || this.scaleZ != 1.0f) {
            NBTTagCompound scaleTag = new NBTTagCompound();
            scaleTag.func_74776_a("x", this.scaleX);
            scaleTag.func_74776_a("y", this.scaleY);
            scaleTag.func_74776_a("z", this.scaleZ);
            compound.func_74782_a("scale", (NBTBase)scaleTag);
        }
        if (this.textureX != 0 || this.textureY != 0 || this.textureMirrored) {
            NBTTagCompound textureTag = new NBTTagCompound();
            textureTag.func_74768_a("x", this.textureX);
            textureTag.func_74768_a("y", this.textureY);
            textureTag.func_74757_a("mirrored", this.textureMirrored);
            compound.func_74782_a("texture", (NBTBase)textureTag);
        }
        compound.func_74776_a("opacity", this.opacity);
        return compound;
    }

    public void deserializeNBT(NBTTagCompound compound) {
        this.name = compound.func_74779_i("name");
        this.children = new ArrayList<QubbleCuboid>();
        NBTTagList childrenTag = compound.func_150295_c("children", 10);
        for (int i = 0; i < childrenTag.func_74745_c(); ++i) {
            QubbleCuboid cuboid = new QubbleCuboid();
            cuboid.deserializeNBT(childrenTag.func_150305_b(i));
            this.children.add(cuboid);
        }
        if (compound.func_74764_b("dimension")) {
            NBTTagCompound dimensionTag = compound.func_74775_l("dimension");
            this.dimensionX = dimensionTag.func_74762_e("x");
            this.dimensionY = dimensionTag.func_74762_e("y");
            this.dimensionZ = dimensionTag.func_74762_e("z");
        }
        if (compound.func_74764_b("position")) {
            NBTTagCompound positionTag = compound.func_74775_l("position");
            this.positionX = positionTag.func_74760_g("x");
            this.positionY = positionTag.func_74760_g("y");
            this.positionZ = positionTag.func_74760_g("z");
        }
        if (compound.func_74764_b("offset")) {
            NBTTagCompound offsetTag = compound.func_74775_l("offset");
            this.offsetX = offsetTag.func_74760_g("x");
            this.offsetY = offsetTag.func_74760_g("y");
            this.offsetZ = offsetTag.func_74760_g("z");
        }
        if (compound.func_74764_b("rotation")) {
            NBTTagCompound rotationTag = compound.func_74775_l("rotation");
            this.rotationX = rotationTag.func_74760_g("x");
            this.rotationY = rotationTag.func_74760_g("y");
            this.rotationZ = rotationTag.func_74760_g("z");
        }
        if (compound.func_74764_b("scale")) {
            NBTTagCompound scaleTag = compound.func_74775_l("scale");
            this.scaleX = scaleTag.func_74760_g("x");
            this.scaleY = scaleTag.func_74760_g("y");
            this.scaleZ = scaleTag.func_74760_g("z");
        }
        if (compound.func_74764_b("texture")) {
            NBTTagCompound textureTag = compound.func_74775_l("texture");
            this.textureX = textureTag.func_74762_e("x");
            this.textureY = textureTag.func_74762_e("y");
            this.textureMirrored = textureTag.func_74767_n("mirrored");
        }
        this.opacity = compound.func_74760_g("opacity");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<QubbleCuboid> getChildren() {
        return this.children;
    }

    public int getDimensionX() {
        return this.dimensionX;
    }

    public int getDimensionY() {
        return this.dimensionY;
    }

    public int getDimensionZ() {
        return this.dimensionZ;
    }

    public float getPositionX() {
        return this.positionX;
    }

    public float getPositionY() {
        return this.positionY;
    }

    public float getPositionZ() {
        return this.positionZ;
    }

    public float getOffsetX() {
        return this.offsetX;
    }

    public float getOffsetY() {
        return this.offsetY;
    }

    public float getOffsetZ() {
        return this.offsetZ;
    }

    public float getRotationX() {
        return this.rotationX;
    }

    public float getRotationY() {
        return this.rotationY;
    }

    public float getRotationZ() {
        return this.rotationZ;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public float getScaleZ() {
        return this.scaleZ;
    }

    public int getTextureX() {
        return this.textureX;
    }

    public int getTextureY() {
        return this.textureY;
    }

    public boolean isTextureMirrored() {
        return this.textureMirrored;
    }

    public void setTextureMirrored(boolean textureMirrored) {
        this.textureMirrored = textureMirrored;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setOpacity(float opacity) {
        this.opacity = opacity;
    }

    public void setTexture(int x, int y) {
        this.textureX = x;
        this.textureY = y;
    }

    public void setPosition(float x, float y, float z) {
        this.positionX = x;
        this.positionY = y;
        this.positionZ = z;
    }

    public void setOffset(float x, float y, float z) {
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
    }

    public void setDimensions(int x, int y, int z) {
        this.dimensionX = x;
        this.dimensionY = y;
        this.dimensionZ = z;
    }

    public void setRotation(float x, float y, float z) {
        this.rotationX = x;
        this.rotationY = y;
        this.rotationZ = z;
    }

    public void setScale(float x, float y, float z) {
        this.scaleX = x;
        this.scaleY = y;
        this.scaleZ = z;
    }

    public QubbleCuboid copy() {
        QubbleCuboid cuboid = QubbleCuboid.create(this.getName());
        cuboid.getChildren().addAll(this.getChildren().stream().map(QubbleCuboid::copy).collect(Collectors.toList()));
        cuboid.setDimensions(this.getDimensionX(), this.getDimensionY(), this.getDimensionZ());
        cuboid.setPosition(this.getPositionX(), this.getPositionY(), this.getPositionZ());
        cuboid.setOffset(this.getOffsetX(), this.getOffsetY(), this.getOffsetZ());
        cuboid.setRotation(this.getRotationX(), this.getRotationY(), this.getRotationZ());
        cuboid.setScale(this.getScaleX(), this.getScaleY(), this.getScaleZ());
        cuboid.setTexture(this.getTextureX(), this.getTextureY());
        cuboid.setTextureMirrored(this.isTextureMirrored());
        cuboid.setOpacity(this.getOpacity());
        return cuboid;
    }
}

