/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui.popups.version;

import java.util.ArrayList;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import net.minecraft.launcher.OperatingSystem;
import net.minecraft.launcher.ui.popups.version.VersionEditorPopup;
import net.minecraft.launcher.versions.Library;
import net.minecraft.launcher.versions.Rule;
import org.apache.commons.lang3.StringUtils;

public class VersionLibrariesPanel
extends JScrollPane {
    private static final int COLUMN_NAME = 0;
    private static final int COLUMN_RULES = 1;
    private static final int COLUMN_NATIVES = 2;
    private static final int NUM_COLUMNS = 3;
    private final VersionEditorPopup editor;
    private final LibraryDataModel dataModel = new LibraryDataModel();
    private final JTable table = new JTable(this.dataModel);

    public VersionLibrariesPanel(VersionEditorPopup editor) {
        this.editor = editor;
        this.setBorder(BorderFactory.createTitledBorder("Libraries & Natives"));
        this.setViewportView(this.table);
        this.table.getColumn("Library").setMinWidth(250);
    }

    private class LibraryDataModel
    extends AbstractTableModel {
        private LibraryDataModel() {
        }

        @Override
        public int getRowCount() {
            return VersionLibrariesPanel.this.editor.getVersion().getLibraries().size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 2: {
                    return "Has natives?";
                }
                case 1: {
                    return "Has rules?";
                }
                case 0: {
                    return "Library";
                }
            }
            return super.getColumnName(column);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Library library = VersionLibrariesPanel.this.editor.getVersion().getLibraries().get(rowIndex);
            if (columnIndex == 1) {
                Rule rule;
                if (library.getRules() == null || library.getRules().isEmpty()) {
                    return "-";
                }
                ArrayList<Rule> allowedRules = new ArrayList<Rule>();
                for (Rule rule2 : library.getRules()) {
                    if (rule2.getAction() != Rule.Action.ALLOW) continue;
                    allowedRules.add(rule2);
                }
                if (allowedRules.size() == 1 && (rule = (Rule)allowedRules.get(0)).getOs() != null && rule.getOs().getName() != null) {
                    if (StringUtils.isNotEmpty(rule.getOs().getVersion())) {
                        return rule.getOs().getName().getName() + " " + rule.getOs().getVersion() + " only";
                    }
                    return rule.getOs().getName().getName() + " only";
                }
                return "Yes";
            }
            if (columnIndex == 2) {
                if (library.getNatives() == null || library.getNatives().isEmpty()) {
                    return "-";
                }
                StringBuilder result = new StringBuilder();
                for (Map.Entry<OperatingSystem, String> entry : library.getNatives().entrySet()) {
                    if (result.length() > 0) {
                        result.append("/");
                    }
                    result.append((Object)entry.getKey());
                }
                return result;
            }
            return library.getName();
        }
    }
}

