/*
 * Decompiled with CFR 0.152.
 */
package reifnsk.minimap;

import java.awt.Graphics;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lwjgl.opengl.GL11;

public class GLTextureBufferedImage
extends BufferedImage {
    private static final ByteBuffer buffer = azc.c(262144);
    private static final HashMap<Integer, GLTextureBufferedImage> registerImage = new HashMap();
    private static final Lock lock = new ReentrantLock();
    public byte[] data;
    private int register;
    private boolean magFiltering;
    private boolean minFiltering;
    private boolean clampTexture;

    private GLTextureBufferedImage(ColorModel cm2, WritableRaster raster, boolean isRasterPremultiplied, Hashtable<?, ?> properties) {
        super(cm2, raster, isRasterPremultiplied, properties);
        this.data = ((DataBufferByte)raster.getDataBuffer()).getData();
    }

    public static GLTextureBufferedImage create(int w2, int h2) {
        ColorSpace colorspace1 = ColorSpace.getInstance(1000);
        int[] bits = new int[]{8, 8, 8, 8};
        int[] bandOffsets = new int[]{0, 1, 2, 3};
        ComponentColorModel colorModel = new ComponentColorModel(colorspace1, bits, true, false, 3, 0);
        WritableRaster raster = Raster.createInterleavedRaster(0, w2, h2, w2 * 4, 4, bandOffsets, null);
        return new GLTextureBufferedImage(colorModel, raster, false, null);
    }

    public static GLTextureBufferedImage create(BufferedImage image) {
        GLTextureBufferedImage img = GLTextureBufferedImage.create(image.getWidth(), image.getHeight());
        Graphics g2 = img.getGraphics();
        g2.drawImage(image, 0, 0, null);
        g2.dispose();
        return img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int register() {
        lock.lock();
        try {
            if (this.register != 0) {
                GL11.glBindTexture((int)3553, (int)this.register);
                GL11.glTexParameteri((int)3553, (int)10241, (int)(this.minFiltering ? 9729 : 9728));
                GL11.glTexParameteri((int)3553, (int)10240, (int)(this.magFiltering ? 9729 : 9728));
                int clamp = this.clampTexture ? 10496 : 10497;
                GL11.glTexParameteri((int)3553, (int)10242, (int)clamp);
                GL11.glTexParameteri((int)3553, (int)10243, (int)clamp);
                buffer.clear();
                buffer.put(this.data);
                buffer.flip();
                GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)this.getWidth(), (int)this.getHeight(), (int)6408, (int)5121, (ByteBuffer)buffer);
                int n2 = this.register;
                return n2;
            }
            this.register = GL11.glGenTextures();
            GL11.glBindTexture((int)3553, (int)this.register);
            GL11.glTexParameteri((int)3553, (int)10241, (int)(this.minFiltering ? 9729 : 9728));
            GL11.glTexParameteri((int)3553, (int)10240, (int)(this.magFiltering ? 9729 : 9728));
            int clamp = this.clampTexture ? 10496 : 10497;
            GL11.glTexParameteri((int)3553, (int)10242, (int)clamp);
            GL11.glTexParameteri((int)3553, (int)10243, (int)clamp);
            buffer.clear();
            buffer.put(this.data);
            buffer.flip();
            GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.getWidth(), (int)this.getHeight(), (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
            registerImage.put(this.register, this);
            int n3 = this.register;
            return n3;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bind() {
        lock.lock();
        try {
            if (this.register != 0) {
                GL11.glBindTexture((int)3553, (int)this.register);
                boolean bl2 = true;
                return bl2;
            }
            boolean bl3 = false;
            return bl3;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister() {
        lock.lock();
        try {
            if (this.register == 0) {
                return;
            }
            GL11.glDeleteTextures((int)this.register);
            this.register = 0;
            registerImage.remove(this.register);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(int id2) {
        lock.lock();
        try {
            GLTextureBufferedImage image = registerImage.get(id2);
            if (image != null) {
                image.unregister();
            }
        }
        finally {
            lock.unlock();
        }
    }

    public void setMagFilter(boolean b2) {
        this.magFiltering = b2;
    }

    public void setMinFilter(boolean b2) {
        this.minFiltering = b2;
    }

    public int getId() {
        return this.register;
    }

    public boolean getMagFilter() {
        return this.magFiltering;
    }

    public boolean getMinFilter() {
        return this.minFiltering;
    }

    public void setClampTexture(boolean b2) {
        this.clampTexture = b2;
    }

    public boolean isClampTexture() {
        return this.clampTexture;
    }

    public void setRGBA(int x2, int y2, byte r2, byte g2, byte b2, byte a2) {
        int i2 = (y2 * this.getWidth() + x2) * 4;
        this.data[i2++] = r2;
        this.data[i2++] = g2;
        this.data[i2++] = b2;
        this.data[i2] = a2;
    }

    public void setRGB(int x2, int y2, byte r2, byte g2, byte b2) {
        int i2 = (y2 * this.getWidth() + x2) * 4;
        this.data[i2++] = r2;
        this.data[i2++] = g2;
        this.data[i2++] = b2;
        this.data[i2] = -1;
    }

    @Override
    public void setRGB(int x2, int y2, int rgb) {
        int i2 = (y2 * this.getWidth() + x2) * 4;
        this.data[i2++] = (byte)(rgb >> 16);
        this.data[i2++] = (byte)(rgb >> 8);
        this.data[i2++] = (byte)(rgb >> 0);
        this.data[i2] = (byte)(rgb >> 24);
    }

    public static void createTexture(int[] data, int w2, int h2, int name, boolean blur, boolean clamp) {
        byte[] bs2 = new byte[w2 * h2 * 4];
        int j2 = data.length;
        int k2 = 0;
        for (int i2 = 0; i2 < j2; ++i2) {
            int pixel = data[i2];
            bs2[k2++] = (byte)(pixel >> 16);
            bs2[k2++] = (byte)(pixel >> 8);
            bs2[k2++] = (byte)(pixel >> 0);
            bs2[k2++] = (byte)(pixel >> 24);
        }
        GLTextureBufferedImage.createTexture(bs2, w2, h2, name, blur, clamp);
    }

    public static void createTexture(byte[] data, int w2, int h2, int name, boolean blur, boolean clamp) {
        GL11.glBindTexture((int)3553, (int)name);
        GL11.glTexParameteri((int)3553, (int)10241, (int)(blur ? 9729 : 9728));
        GL11.glTexParameteri((int)3553, (int)10240, (int)(blur ? 9729 : 9728));
        GL11.glTexParameteri((int)3553, (int)10242, (int)(clamp ? 10496 : 10497));
        GL11.glTexParameteri((int)3553, (int)10243, (int)(clamp ? 10496 : 10497));
        buffer.clear();
        buffer.put(data);
        buffer.flip();
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)w2, (int)h2, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
    }
}

