/*
 * Decompiled with CFR 0.152.
 */
package reifnsk.minimap;

import reifnsk.minimap.IChunkData;

enum BlockType {
    NORMAL,
    AIR,
    GRASS{

        @Override
        int getColorMultiplayer(Data data, int i2) {
            return data.smoothGrassColors[i2];
        }
    }
    ,
    FOLIAGE{

        @Override
        int getColorMultiplayer(Data data, int i2) {
            return data.smoothFoliageColors[i2];
        }
    }
    ,
    FOLIAGE_PINE{

        @Override
        int getColorMultiplayer(Data data, int i2) {
            return data.foliageColorPine;
        }
    }
    ,
    FOLIAGE_BIRCH{

        @Override
        int getColorMultiplayer(Data data, int i2) {
            return data.foliageColorBirch;
        }
    }
    ,
    WATER(true){

        @Override
        int getColorMultiplayer(Data data, int i2) {
            return data.smoothWaterColors[i2];
        }
    }
    ,
    ICE(true),
    GLASS,
    SIMPLE_GRASS{

        @Override
        int getColorMultiplayer(Data data, int i2) {
            return data.grassColors[i2];
        }
    }
    ,
    SIMPLE_FOLIAGE{

        @Override
        int getColorMultiplayer(Data data, int i2) {
            return data.foliageColors[i2];
        }
    }
    ,
    SIMPLE_WATER{

        @Override
        int getColorMultiplayer(Data data, int i2) {
            return data.waterColors[i2];
        }
    }
    ,
    END_PORTAL_FRAME,
    END_PORTAL_FRAME_EYE,
    EX_WATER(true);

    final boolean water;

    private BlockType() {
        this.water = false;
    }

    private BlockType(boolean water) {
        this.water = water;
    }

    int getColorMultiplayer(Data data, int i2) {
        return 0xFFFFFF;
    }

    static final class Data {
        final int[] foliageColors;
        final int[] grassColors;
        final int[] waterColors;
        final int[] smoothFoliageColors;
        final int[] smoothGrassColors;
        final int[] smoothWaterColors;
        final int foliageColorBirch = afj.b();
        final int foliageColorPine = afj.a();

        public Data(IChunkData chunkData) {
            this.foliageColors = chunkData.getFoliageColors();
            this.grassColors = chunkData.getGrassColors();
            this.waterColors = chunkData.getWaterColors();
            this.smoothFoliageColors = chunkData.getSmoothFoliageColors();
            this.smoothGrassColors = chunkData.getSmoothGrassColors();
            this.smoothWaterColors = chunkData.getSmoothWaterColors();
        }
    }
}

