/*
 * Decompiled with CFR 0.152.
 */
package idv.jlchntoz;

import idv.jlchntoz.CustomSkinLoaderGUI;
import idv.jlchntoz.MainLogger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CustomSkinLoader {
    public static final String VERSION = "12.3";
    public static final String DefaultSkinURL = "http://skins.minecraft.net/MinecraftSkins/*.png";
    public static final String DefaultCloakURL = "http://skins.minecraft.net/MinecraftCloaks/*.png";
    private static final Pattern newResPattern = Pattern.compile("^http://textures.minecraft.net/texture/(.*?)?(Skin|Cloak)=(.*?)$");
    private static final Pattern newURLPattern = Pattern.compile("^http://skins.minecraft.net/Minecraft(Skin|Cloak)s/(.*?).png$");
    private static final Pattern oldURLPattern = Pattern.compile("^http://s3.amazonaws.com/Minecraft(Skin|Cloak)s/(.*?).png$");
    private static final Pattern optifineCapeURLPattern = Pattern.compile("^http://s.optifine.net/capes/(.*?).png$");
    private static final File DATA_DIR = new File(azd.A().w, "CustomSkinLoader");
    private static final File SKIN_DIR = new File(DATA_DIR, "skins");
    private static final File CLOAK_DIR = new File(DATA_DIR, "cloaks");
    private static final MainLogger logger = new MainLogger(new File(DATA_DIR, "CustomSkinLoader.log"));
    private static String[] cloakURLs = null;
    private static String[] skinURLs = null;
    private HttpURLConnection C = null;
    private boolean loadFromCache = false;
    private boolean cacheSelfOnly = false;

    public InputStream getPlayerSkinStream(String path) {
        if (!DATA_DIR.exists()) {
            DATA_DIR.mkdir();
        }
        logger.info("Get a request: " + path);
        Matcher m2 = newURLPattern.matcher(path);
        if (!m2.matches()) {
            m2 = oldURLPattern.matcher(path);
        }
        if (m2.matches()) {
            if (m2.group(1).contains("Skin")) {
                return this.getPlayerSkinStream(false, m2.group(2));
            }
            if (m2.group(1).contains("Cloak")) {
                return this.getPlayerSkinStream(true, m2.group(2));
            }
        } else {
            m2 = newResPattern.matcher(path);
            if (m2.matches()) {
                if (m2.group(2).contains("Skin")) {
                    return this.getPlayerSkinStream(false, m2.group(3));
                }
                if (m2.group(2).contains("Cloak")) {
                    return this.getPlayerSkinStream(true, m2.group(3));
                }
            } else {
                m2 = optifineCapeURLPattern.matcher(path);
                if (m2.matches()) {
                    return null;
                }
            }
        }
        return this.getStream(path, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public InputStream getPlayerSkinStream(Boolean isCloak, String playerName) {
        block28: {
            InputStream S;
            block31: {
                File temp;
                block30: {
                    if (skinURLs == null || cloakURLs == null || skinURLs.length <= 0 || cloakURLs.length <= 0) {
                        CustomSkinLoader.refreshSkinURL();
                    }
                    S = null;
                    temp = null;
                    temp = isCloak != false ? new File(CLOAK_DIR, playerName + ".png") : new File(SKIN_DIR, playerName + ".png");
                    for (String l2 : isCloak != false ? cloakURLs : skinURLs) {
                        if (l2 == null || l2.equalsIgnoreCase("")) continue;
                        String loc = CustomSkinLoader.str_replace("*", playerName, l2);
                        logger.log(Level.INFO, "Try to load " + (isCloak != false ? "cloak" : "skin") + " in " + loc);
                        long last = 0L;
                        if (temp.exists() && temp.length() > 0L) {
                            last = temp.lastModified();
                        }
                        S = this.getStream(loc, true, last);
                        if (this.loadFromCache) {
                            logger.info("" + (isCloak != false ? "Cloak" : "Skin") + " in " + loc + " will be load from cache.");
                            break;
                        }
                        if (S == null) {
                            logger.log(Level.INFO, "No " + (isCloak != false ? "cloak" : "skin") + " found in " + loc);
                            continue;
                        }
                        logger.info("Succeessfully load " + (isCloak != false ? "cloak" : "skin") + " in " + loc);
                        break;
                    }
                    if (S != null) break block30;
                    try {
                        if (temp.exists() && temp.length() > 1L) {
                            logger.info("Try load local " + (isCloak != false ? "cloak" : "skin") + " in " + temp.getAbsolutePath());
                            FileInputStream in2 = new FileInputStream(temp);
                            BufferedInputStream bis2 = new BufferedInputStream(in2);
                            if (bis2.available() <= 0) {
                                logger.info("Cannot load local " + (isCloak != false ? "cloak" : "skin") + " in " + temp.getAbsolutePath());
                                break block28;
                            }
                            logger.info("Successfully load " + (isCloak != false ? "cloak" : "skin") + " in " + temp.getAbsolutePath());
                            return bis2;
                        }
                        logger.info("No local " + (isCloak != false ? "cloak" : "skin") + " found in " + temp.getAbsolutePath());
                    }
                    catch (Exception e2) {
                        logger.log(Level.WARNING, e2.getMessage());
                    }
                    break block28;
                }
                String user = azd.A().L().c();
                if (!this.cacheSelfOnly || user.equalsIgnoreCase(playerName)) {
                    int times;
                    FileOutputStream fs2;
                    block29: {
                        logger.info("Try save local " + (isCloak != false ? "cloak" : "skin") + " to " + temp.getAbsolutePath());
                        fs2 = null;
                        times = 0;
                        if (!temp.getParentFile().exists()) {
                            temp.getParentFile().mkdir();
                        } else if (temp.exists()) {
                            temp.delete();
                        }
                        fs2 = new FileOutputStream(temp);
                        int byteRead = 0;
                        byte[] buffer = new byte[1024];
                        while ((byteRead = S.read(buffer)) != -1) {
                            fs2.write(buffer, 0, byteRead);
                            if ((times += byteRead) < this.C.getContentLength()) continue;
                            logger.info(times + " " + this.C.getContentLength());
                            break;
                        }
                        if (temp.length() > 1L) {
                            logger.info("Successfully save " + (isCloak != false ? "cloak" : "skin") + " to " + temp.getAbsolutePath());
                            break block29;
                        }
                        temp.delete();
                        logger.info("Cannot save local " + (isCloak != false ? "cloak" : "skin") + " to " + temp.getAbsolutePath());
                    }
                    try {
                        if (fs2 != null) {
                            fs2.close();
                        }
                        S.reset();
                        logger.info((isCloak != false ? "Cloak" : "Skin") + " size : " + S.available());
                    }
                    catch (IOException e3) {
                        logger.warning(e3);
                    }
                    break block31;
                    catch (Exception e4) {
                        try {
                            e4.printStackTrace();
                            logger.info(times + "");
                            logger.warning(e4);
                        }
                        catch (Throwable throwable) {
                            try {
                                if (fs2 != null) {
                                    fs2.close();
                                }
                                S.reset();
                                logger.info((isCloak != false ? "Cloak" : "Skin") + " size : " + S.available());
                            }
                            catch (IOException e5) {
                                logger.warning(e5);
                            }
                            throw throwable;
                        }
                        try {
                            if (fs2 != null) {
                                fs2.close();
                            }
                            S.reset();
                            logger.info((isCloak != false ? "Cloak" : "Skin") + " size : " + S.available());
                        }
                        catch (IOException e6) {
                            logger.warning(e6);
                        }
                    }
                }
            }
            return S;
        }
        logger.log(Level.INFO, "Try to load skin in default URL instead.");
        return this.getStream(CustomSkinLoader.str_replace("*", playerName, isCloak != false ? DefaultCloakURL : DefaultSkinURL), true);
    }

    private InputStream getStream(String URL2, Boolean CheckPNG) {
        return this.getStream(URL2, CheckPNG, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getStream(String URL2, Boolean CheckPNG, long last) {
        boolean success = false;
        try {
            URL U = new URL(URL2);
            this.C = (HttpURLConnection)U.openConnection();
            this.C.setDoInput(true);
            this.C.setDoOutput(false);
            if (last > 0L) {
                this.C.setIfModifiedSince(last);
            }
            this.C.connect();
            logger.info("RC: " + this.C.getResponseCode());
            int respcode = this.C.getResponseCode() / 100;
            if (respcode != 4 && respcode != 5) {
                if (this.C.getResponseCode() == 304) {
                    logger.info("Not Modified!");
                    this.loadFromCache = true;
                    InputStream inputStream = null;
                    return inputStream;
                }
                if (this.C.getContentLength() <= 0) {
                    InputStream inputStream = null;
                    return inputStream;
                }
                BufferedInputStream IS = new BufferedInputStream(this.C.getInputStream());
                if (!CheckPNG.booleanValue()) {
                    success = true;
                    BufferedInputStream bufferedInputStream = IS;
                    return bufferedInputStream;
                }
                ((InputStream)IS).mark(this.C.getContentLength() + 10);
                byte[] ib2 = new byte[4];
                ((InputStream)IS).read(ib2);
                if (ib2[1] == 80 && ib2[2] == 78 && ib2[3] == 71) {
                    ((InputStream)IS).reset();
                    success = true;
                    BufferedInputStream bufferedInputStream = IS;
                    return bufferedInputStream;
                }
            }
        }
        catch (Exception ex2) {
            success = false;
            logger.log(Level.WARNING, ex2.getMessage());
        }
        finally {
            if (!success) {
                this.disconnect();
            }
        }
        return null;
    }

    public void disconnect() {
        if (this.C != null) {
            this.C.disconnect();
        }
    }

    private static void refreshSkinURL() {
        try {
            skinURLs = CustomSkinLoader.readAllLines(DATA_DIR, "skinurls.txt");
            cloakURLs = CustomSkinLoader.readAllLines(DATA_DIR, "capeurls.txt");
        }
        catch (Exception ex2) {
            logger.log(Level.WARNING, ex2.getMessage());
        }
        finally {
            if (skinURLs.length == 0 && cloakURLs.length == 0) {
                logger.info("No skinURLs and cloak URLS found, try to show GUI.");
                CustomSkinLoader.showGUI();
            } else {
                logger.log(Level.INFO, "Skin URLs Refreshed. Skin count = " + skinURLs.length + ",  Cloak count = " + cloakURLs.length);
            }
        }
    }

    private static String[] readAllLines(File dir, String path) {
        try {
            File F = new File(dir, path);
            logger.log(Level.INFO, "Config file: " + F.getAbsolutePath());
            if (!F.exists()) {
                logger.log(Level.INFO, "Config file not found.");
                return new String[0];
            }
            if (F.length() <= 0L) {
                logger.log(Level.INFO, "Config file is blank, skipped.");
                return new String[0];
            }
            byte[] b2 = new byte[(int)F.length()];
            BufferedInputStream S = new BufferedInputStream(new FileInputStream(F));
            S.read(b2);
            S.close();
            logger.log(Level.INFO, "Config file loaded.");
            String[] re2 = CustomSkinLoader.str_replace("\r", "\n", CustomSkinLoader.str_replace("\r\n", "\n", new String(b2))).split("\n");
            block2: for (int i2 = 0; i2 < re2.length; ++i2) {
                if (re2[i2].startsWith("#")) {
                    re2[i2] = null;
                    continue;
                }
                for (int g2 = 0; g2 < re2.length; ++g2) {
                    if (i2 == g2 || !re2[i2].equalsIgnoreCase(re2[g2])) continue;
                    re2[i2] = null;
                    continue block2;
                }
            }
            return re2;
        }
        catch (Exception ex2) {
            logger.log(Level.WARNING, ex2.getMessage());
            return new String[0];
        }
    }

    private static String str_replace(String search, String replace, String subject) {
        int pos;
        StringBuffer result = new StringBuffer(subject);
        while ((pos = result.indexOf(search)) != -1) {
            result.replace(pos, pos + search.length(), replace);
        }
        return result.toString();
    }

    public static void showGUI() {
        try {
            Class<?> clazz = Class.forName("idv.jlchntoz.CustomSkinLoaderGUI");
            String[] arg = new String[]{"f", VERSION, "in"};
            CustomSkinLoaderGUI.main(arg);
            return;
        }
        catch (Exception e2) {
            logger.warning(e2.getMessage());
            File a2 = new File(DATA_DIR, "CustomSkinLoaderGUI.jar");
            if (!a2.exists() || a2.length() < 1L) {
                a2.delete();
                logger.info("No GUI file found, try to download one to " + a2.getAbsolutePath());
                CustomSkinLoader.downloadFile("https://raw.githubusercontent.com/JLChnToZ/MCCustomSkinLoader/GUI/CustomSkinLoaderGUI.jar", a2);
            }
            try {
                String toRun = "java -jar \"" + a2.getAbsolutePath() + "\" f " + VERSION;
                logger.info("Run: " + toRun);
                Runtime.getRuntime().exec(toRun);
            }
            catch (Exception e3) {
                logger.warning(e3.getMessage());
            }
            return;
        }
    }

    public static boolean downloadFile(String remote, File local) {
        try {
            File LCK = new File(local.getParentFile(), "download.lck");
            if (LCK.exists() && LCK.lastModified() >= System.currentTimeMillis() - 10000L) {
                logger.info("'download.lck' found! Download will not start.");
                return false;
            }
            LCK.createNewFile();
            logger.info("Downloading " + remote + " to " + local.getAbsolutePath());
            URL url = new URL(remote);
            URLConnection conn = url.openConnection();
            InputStream inStream = conn.getInputStream();
            FileOutputStream fs2 = new FileOutputStream(local);
            int byteRead = 0;
            byte[] buffer = new byte[1024];
            while ((byteRead = inStream.read(buffer)) != -1) {
                fs2.write(buffer, 0, byteRead);
            }
            fs2.close();
            LCK.delete();
            logger.info("Download successfully!");
            return local.exists();
        }
        catch (Exception e2) {
            logger.warning(e2.getMessage());
            return false;
        }
    }
}

