/*
 * Decompiled with CFR 0.152.
 */
package weather2.weathersystem;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import weather2.ClientTickHandler;
import weather2.Weather;
import weather2.entity.EntityLightningBolt;
import weather2.volcano.VolcanoObject;
import weather2.weathersystem.WeatherManagerBase;
import weather2.weathersystem.storm.StormObject;

@SideOnly(value=Side.CLIENT)
public class WeatherManagerClient
extends WeatherManagerBase {
    public WeatherManagerClient(int parDim) {
        super(parDim);
    }

    @Override
    public World getWorld() {
        return FMLClientHandler.instance().getClient().field_71441_e;
    }

    @Override
    public void tick() {
        super.tick();
    }

    public void nbtSyncFromServer(NBTTagCompound parNBT) {
        String command = parNBT.func_74779_i("command");
        if (command.equals("syncStormNew")) {
            NBTTagCompound stormNBT = parNBT.func_74775_l("data");
            StormObject so = new StormObject(ClientTickHandler.weatherManager);
            so.nbtSyncFromServer(stormNBT);
            this.addStormObject(so);
        } else if (command.equals("syncStormRemove")) {
            NBTTagCompound stormNBT = parNBT.func_74775_l("data");
            long ID = stormNBT.func_74763_f("ID");
            StormObject so = (StormObject)this.lookupStormObjectsByID.get(ID);
            if (so != null) {
                this.removeStormObject(ID);
            } else {
                Weather.dbg("error removing storm, cant find by ID: " + ID);
            }
        } else if (command.equals("syncStormUpdate")) {
            NBTTagCompound stormNBT = parNBT.func_74775_l("data");
            long ID = stormNBT.func_74763_f("ID");
            StormObject so = (StormObject)this.lookupStormObjectsByID.get(ID);
            if (so != null) {
                so.nbtSyncFromServer(stormNBT);
            } else {
                Weather.dbg("error syncing storm, cant find by ID: " + ID);
            }
        } else if (command.equals("syncVolcanoNew")) {
            Weather.dbg("creating client side volcano");
            NBTTagCompound stormNBT = parNBT.func_74775_l("data");
            VolcanoObject so = new VolcanoObject(ClientTickHandler.weatherManager);
            so.nbtSyncFromServer(stormNBT);
            this.addVolcanoObject(so);
        } else if (command.equals("syncVolcanoRemove")) {
            Weather.dbg("removing client side volcano");
            NBTTagCompound stormNBT = parNBT.func_74775_l("data");
            long ID = stormNBT.func_74763_f("ID");
            VolcanoObject so = (VolcanoObject)this.lookupVolcanoes.get(ID);
            if (so != null) {
                this.removeVolcanoObject(ID);
            }
        } else if (command.equals("syncVolcanoUpdate")) {
            Weather.dbg("updating client side volcano");
            NBTTagCompound stormNBT = parNBT.func_74775_l("data");
            long ID = stormNBT.func_74763_f("ID");
            VolcanoObject so = (VolcanoObject)this.lookupVolcanoes.get(ID);
            if (so != null) {
                so.nbtSyncFromServer(stormNBT);
            } else {
                Weather.dbg("error syncing volcano, cant find by ID: " + ID);
            }
        } else if (command.equals("syncWindUpdate")) {
            NBTTagCompound nbt = parNBT.func_74775_l("data");
            this.windMan.nbtSyncFromServer(nbt);
        } else if (command.equals("syncLightningNew")) {
            NBTTagCompound nbt = parNBT.func_74775_l("data");
            int posXS = nbt.func_74762_e("posX");
            int posYS = nbt.func_74762_e("posY");
            int posZS = nbt.func_74762_e("posZ");
            double posX = posXS;
            double posY = posYS;
            double posZ = posZS;
            EntityLightningBolt ent = new EntityLightningBolt(this.getWorld(), posX, posY, posZ);
            ent.field_70118_ct = posXS;
            ent.field_70117_cu = posYS;
            ent.field_70116_cv = posZS;
            ent.field_70177_z = 0.0f;
            ent.field_70125_A = 0.0f;
            ent.func_145769_d(nbt.func_74762_e("entityID"));
            this.getWorld().func_72942_c((Entity)ent);
        } else if (command.equals("syncWeatherUpdate")) {
            this.isVanillaRainActiveOnServer = parNBT.func_74767_n("isVanillaRainActiveOnServer");
        }
    }
}

