/*
 * Decompiled with CFR 0.152.
 */
package weather2;

import CoroUtil.util.CoroUtilFile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.NetworkRegistry;
import modconfig.ConfigMod;
import modconfig.IConfigCategory;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import weather2.CommandWeather2;
import weather2.CommonProxy;
import weather2.EventHandlerFML;
import weather2.EventHandlerForge;
import weather2.EventHandlerPacket;
import weather2.ServerTickHandler;
import weather2.config.ConfigMisc;
import weather2.player.PlayerData;
import weather2.util.WeatherUtilConfig;

@Mod(modid="weather2", name="weather2", version="v2.3.4")
public class Weather {
    @Mod.Instance(value="weather2")
    public static Weather instance;
    public static String modID;
    public static long lastWorldTime;
    public Configuration preInitConfig;
    @SidedProxy(clientSide="weather2.ClientProxy", serverSide="weather2.CommonProxy")
    public static CommonProxy proxy;
    public static boolean initProperNeededForWorld;
    public static String eventChannelName;
    public static final FMLEventChannel eventChannel;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        eventChannel.register((Object)new EventHandlerPacket());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerForge());
        FMLCommonHandler.instance().bus().register((Object)new EventHandlerFML());
        ConfigMod.addConfigFile((FMLPreInitializationEvent)event, (String)"weather2Misc", (IConfigCategory)new ConfigMisc());
        WeatherUtilConfig.nbtLoadDataAll();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        proxy.init();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandWeather2());
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartedEvent event) {
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppedEvent event) {
        Weather.writeOutData(true);
        Weather.resetStates();
        initProperNeededForWorld = true;
    }

    public static void initTry() {
        if (initProperNeededForWorld) {
            System.out.println("Weather2 being reinitialized");
            initProperNeededForWorld = false;
            CoroUtilFile.getWorldFolderName();
            ServerTickHandler.initialize();
        }
    }

    public static void resetStates() {
        ServerTickHandler.reset();
    }

    public static void writeOutData(boolean unloadInstances) {
        try {
            ServerTickHandler.lookupDimToWeatherMan.get(0).writeToFile();
            PlayerData.writeAllPlayerNBT(unloadInstances);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void dbg(Object obj) {
        if (ConfigMisc.consoleDebug) {
            System.out.println(obj);
        }
    }

    static {
        modID = "weather2";
        initProperNeededForWorld = true;
        eventChannelName = "weather2";
        eventChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(eventChannelName);
    }
}

