/*
 * Decompiled with CFR 0.152.
 */
package enviromine.world.features.mineshaft.designers;

import enviromine.world.features.mineshaft.MineSegmentNormal;
import enviromine.world.features.mineshaft.MineshaftBuilder;
import enviromine.world.features.mineshaft.designers.MineDesigner;

public class MineDesignerRandomized
extends MineDesigner {
    @Override
    public void StartDesign(MineshaftBuilder builder, int size, int depth, int auxSpacing) {
        int[][] segMap = new int[size][size];
        int maxAttempts = size * size * 10;
        int rooms = size / 2 * (size / 2);
        segMap[size / 2][size / 2] = 1;
        for (int attempts = 0; attempts < maxAttempts && rooms > 0; ++attempts) {
            int y;
            int x = builder.rand.nextInt(size);
            if (segMap[x][y = builder.rand.nextInt(size)] != 0 || this.GetNeighbours(segMap, x, y) != 1) continue;
            segMap[x][y] = 1;
            --rooms;
        }
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                if (segMap[i][j] != 1) continue;
                int posX = (i - size / 2) * 4;
                int posZ = (j - size / 2) * 4;
                MineSegmentNormal segment = new MineSegmentNormal(builder.world, builder.xOffset(posX, posZ), depth, builder.zOffset(posX, posZ), builder.rot, builder, true);
                segment.setDecay(builder.decayAmount);
                segment.linkChunksToBuilder();
            }
        }
    }

    public int GetNeighbours(int[][] map, int posX, int posY) {
        int count = 0;
        count += posX + 1 >= map.length ? 0 : map[posX + 1][posY];
        count += posX - 1 < 0 ? 0 : map[posX - 1][posY];
        count += posY + 1 >= map[posX].length ? 0 : map[posX][posY + 1];
        return count += posY - 1 < 0 ? 0 : map[posX][posY - 1];
    }
}

