/*
 * Decompiled with CFR 0.152.
 */
package enviromine.world.features;

import cpw.mods.fml.common.IWorldGenerator;
import enviromine.blocks.tiles.TileEntityGas;
import enviromine.core.EM_Settings;
import enviromine.gases.EnviroGasDictionary;
import enviromine.handlers.ObjectHandler;
import enviromine.trackers.properties.DimensionProperties;
import enviromine.world.features.mineshaft.MineshaftBuilder;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.oredict.OreDictionary;

public class WorldFeatureGenerator
implements IWorldGenerator {
    public static ArrayList<int[]> pendingMines = new ArrayList();
    public static boolean disableMineScan = false;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int i;
        if (world.field_72995_K) {
            return;
        }
        DimensionProperties dimensionProp = null;
        boolean allowMines = true;
        if (EM_Settings.dimensionProperties.containsKey(world.field_73011_w.field_76574_g)) {
            dimensionProp = EM_Settings.dimensionProperties.get(world.field_73011_w.field_76574_g);
            allowMines = dimensionProp.mineshaftGen;
        }
        if (allowMines && EM_Settings.oldMineGen) {
            if (!disableMineScan) {
                MineshaftBuilder.scanGrids(world, chunkX, chunkZ, random);
            }
            for (i = MineshaftBuilder.pendingBuilders.size() - 1; i >= 0; --i) {
                MineshaftBuilder builder = MineshaftBuilder.pendingBuilders.get(i);
                if (!builder.checkAndBuildSegments(chunkX, chunkZ)) continue;
                MineshaftBuilder.pendingBuilders.remove(i);
                if (!MineshaftBuilder.scannedGrids.containsKey("" + chunkX / 64 + "," + chunkZ / 64 + "," + world.field_73011_w.field_76574_g)) continue;
                int remBuilders = MineshaftBuilder.scannedGrids.get("" + chunkX / 64 + "," + chunkZ / 64 + "," + world.field_73011_w.field_76574_g);
                MineshaftBuilder.scannedGrids.put("" + chunkX / 64 + "," + chunkZ / 64 + "," + world.field_73011_w.field_76574_g, remBuilders - 1);
            }
        }
        this.ReplaceCoal(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
        if (EM_Settings.gasGen && !EM_Settings.noGases) {
            for (i = 4; i >= 0; --i) {
                this.GenGasPocket(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
            }
        }
    }

    public void ReplaceCoal(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        DimensionProperties dProps = EM_Settings.dimensionProperties.get(world.field_73011_w.field_76574_g);
        int xOff = chunkX * 16;
        int zOff = chunkZ * 16;
        block0: for (int i = 0; i < 16; ++i) {
            int j = 0;
            while (true) {
                float f = j;
                float f2 = dProps != null ? (float)dProps.sealevel : 64.0f;
                if (!(f < f2 * 0.75f)) continue block0;
                for (int k = 0; k < 16; ++k) {
                    Item item = Item.func_150898_a((Block)world.func_147439_a(i + xOff, j, k + zOff));
                    if (world.func_147439_a(i + xOff, j, k + zOff) != Blocks.field_150365_q && (item == null || !this.SameOre(new ItemStack(item), "oreCoal"))) continue;
                    world.func_147449_b(i + xOff, j, k + zOff, ObjectHandler.flammableCoal);
                }
                ++j;
            }
        }
    }

    public boolean SameOre(ItemStack item, String oreName) {
        int[] oreIds = OreDictionary.getOreIDs((ItemStack)item);
        int findId = OreDictionary.getOreID((String)oreName);
        for (int id : oreIds) {
            if (id != findId) continue;
            return true;
        }
        return false;
    }

    public void GenGasPocket(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int rY;
        int rX = chunkX * 16 + random.nextInt(16);
        int rZ = chunkZ * 16 + random.nextInt(16);
        for (rY = 1 + random.nextInt(32); world.func_147439_a(rX, rY - 1, rZ) == Blocks.field_150350_a && rY > 1; --rY) {
        }
        if (world.func_72972_b(EnumSkyBlock.Sky, rX, rY, rZ) > 1) {
            return;
        }
        if (world.func_147439_a(rX, rY, rZ) == Blocks.field_150350_a) {
            Block bBlock = world.func_147439_a(rX, rY - 1, rZ);
            if (rY < 16 && rY > 0 || world.field_73011_w.field_76575_d) {
                if (bBlock.func_149688_o() == Material.field_151586_h) {
                    world.func_147465_d(rX, rY, rZ, ObjectHandler.gasBlock, 0, 2);
                    TileEntity tile = world.func_147438_o(rX, rY, rZ);
                    if (tile instanceof TileEntityGas) {
                        TileEntityGas gasTile = (TileEntityGas)tile;
                        gasTile.addGas(EnviroGasDictionary.hydrogenSulfide.gasID, 10);
                    }
                } else if (bBlock.func_149688_o() == Material.field_151587_i || bBlock.func_149688_o() == Material.field_151581_o) {
                    world.func_147465_d(rX, rY, rZ, ObjectHandler.gasBlock, 0, 2);
                    TileEntity tile = world.func_147438_o(rX, rY, rZ);
                    if (tile instanceof TileEntityGas) {
                        TileEntityGas gasTile = (TileEntityGas)tile;
                        gasTile.addGas(EnviroGasDictionary.carbonMonoxide.gasID, 25);
                        gasTile.addGas(EnviroGasDictionary.sulfurDioxide.gasID, 25);
                    }
                } else {
                    world.func_147465_d(rX, rY, rZ, ObjectHandler.gasBlock, 0, 2);
                    TileEntity tile = world.func_147438_o(rX, rY, rZ);
                    if (tile instanceof TileEntityGas) {
                        TileEntityGas gasTile = (TileEntityGas)tile;
                        gasTile.addGas(EnviroGasDictionary.sulfurDioxide.gasID, 20);
                        gasTile.addGas(EnviroGasDictionary.carbonDioxide.gasID, 30);
                    }
                }
            } else {
                world.func_147465_d(rX, rY, rZ, ObjectHandler.gasBlock, 0, 2);
                TileEntity tile = world.func_147438_o(rX, rY, rZ);
                if (tile instanceof TileEntityGas) {
                    TileEntityGas gasTile = (TileEntityGas)tile;
                    gasTile.addGas(EnviroGasDictionary.carbonDioxide.gasID, 50);
                }
            }
        }
    }

    public void SavePendingMines() {
    }

    public void LoadPendingMines() {
    }
}

