/*
 * Decompiled with CFR 0.152.
 */
package enviromine.world;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import enviromine.world.Earthquake;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class ClientQuake
extends Earthquake {
    int dimensionID;
    long duration;

    public ClientQuake(int d, int i, int k, int l, int w, float a) {
        super(null, i, k, l, w, a, false);
        clientQuakes.add(this);
        this.duration = Minecraft.func_71410_x().field_71441_e.func_82737_E();
    }

    public static void UpdateQuakeHeight(int d, int x, int z, int l, int w, float a, int height) {
        for (int i = 0; i < clientQuakes.size(); ++i) {
            ClientQuake quake = (ClientQuake)clientQuakes.get(i);
            if (quake.posX != x || quake.posZ != z) continue;
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("enviromine:earthquake"), (float)(new Random().nextFloat() * 0.25f + 0.75f)));
            quake.passY = height;
            quake.duration = Minecraft.func_71410_x().field_71441_e.func_82737_E();
            return;
        }
        ClientQuake newQuake = new ClientQuake(d, x, z, l, w, a);
        newQuake.passY = height;
    }

    public static void RemoveQuake(int x, int z) {
        for (int i = 0; i < clientQuakes.size(); ++i) {
            ClientQuake quake = (ClientQuake)clientQuakes.get(i);
            if (quake.posX != x || quake.posZ != z) continue;
            clientQuakes.remove(i);
            return;
        }
    }

    public static float GetQuakeShake(World world, Entity entity) {
        float dist = 128.0f;
        if (clientQuakes.size() > 0) {
            for (int i = clientQuakes.size() - 1; i >= 0; --i) {
                int size;
                ClientQuake quake = (ClientQuake)clientQuakes.get(i);
                if (entity.field_71093_bK != quake.dimensionID) continue;
                int n = size = quake.length > quake.width ? quake.length / 2 : quake.width / 2;
                if (entity.func_70011_f((double)quake.posX, (double)quake.passY, (double)quake.posZ) < (double)(dist + (float)size)) {
                    dist = (float)entity.func_70011_f((double)quake.posX, (double)quake.passY, (double)quake.posZ) - (float)size;
                    float f = dist = dist < 0.0f ? 0.0f : dist;
                }
                if (!(entity.func_70011_f((double)quake.posX, (double)quake.passY, (double)quake.posZ) > (double)(256 + size)) && Minecraft.func_71410_x().field_71441_e.func_72820_D() - quake.duration <= 3000L) continue;
                clientQuakes.remove(i);
            }
        }
        return 1.0f - dist / 128.0f;
    }
}

