/*
 * Decompiled with CFR 0.152.
 */
package enviromine.trackers.properties;

import enviromine.core.EM_ConfigHandler;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import enviromine.handlers.ObjectHandler;
import enviromine.trackers.properties.helpers.PropertyBase;
import enviromine.trackers.properties.helpers.SerialisableProperty;
import enviromine.utils.EnviroUtils;
import java.io.File;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;

public class RotProperties
implements SerialisableProperty,
PropertyBase {
    public static final RotProperties base = new RotProperties();
    static String[] RPName = new String[5];
    public String name;
    public int meta;
    public String rotID;
    public int rotMeta;
    public int days;
    public String loadedFrom;

    public RotProperties(NBTTagCompound tags) {
        this.ReadFromNBT(tags);
    }

    public RotProperties() {
        if (base != null && base != this) {
            throw new IllegalStateException();
        }
    }

    public RotProperties(String name, int meta, String rotID, int rotMeta, int days, String fileName) {
        this.name = name;
        this.meta = meta;
        this.rotID = rotID;
        this.rotMeta = rotMeta;
        this.days = days;
        this.loadedFrom = fileName;
    }

    @Override
    public NBTTagCompound WriteToNBT() {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74778_a("name", this.name);
        tags.func_74768_a("meta", this.meta);
        tags.func_74778_a("rotID", this.rotID);
        tags.func_74768_a("rotMeta", this.rotMeta);
        tags.func_74768_a("days", this.days);
        return tags;
    }

    @Override
    public void ReadFromNBT(NBTTagCompound tags) {
        this.name = tags.func_74779_i("name");
        this.meta = tags.func_74762_e("meta");
        this.rotID = tags.func_74779_i("rotID");
        this.rotMeta = tags.func_74762_e("rotMeta");
        this.days = tags.func_74762_e("days");
    }

    @Override
    public String categoryName() {
        return "spoiling";
    }

    @Override
    public String categoryDescription() {
        return "Set the properties of spoliable items";
    }

    @Override
    public void LoadProperty(Configuration config, String category) {
        config.addCustomCategoryComment(this.categoryName(), this.categoryDescription());
        String name = config.get(category, RPName[0], "").getString();
        int meta = config.get(category, RPName[1], -1).getInt(-1);
        String rotID = config.get(category, RPName[2], "", "Set blank to rot into nothing").getString();
        int rotMeta = config.get(category, RPName[3], 0).getInt(0);
        int DTR = config.get(category, RPName[4], 0, "Set this to -1 to disable rotting on this item").getInt(0);
        String filename = config.getConfigFile().getName();
        RotProperties entry = new RotProperties(name, meta, rotID, rotMeta, DTR, filename);
        if (meta < 0) {
            if (EM_Settings.rotProperties.containsKey("" + name) && !EM_ConfigHandler.loadedConfigs.contains(filename)) {
                EnviroMine.logger.log(Level.ERROR, "CONFIG DUPLICATE: Spoiling/Rot -" + name.toUpperCase() + " was already added from " + EM_Settings.rotProperties.get((Object)name).loadedFrom.toUpperCase() + " and will be overriden by " + filename.toUpperCase());
            }
            EM_Settings.rotProperties.put("" + name, entry);
        } else {
            if (EM_Settings.rotProperties.containsKey("" + name + "," + meta) && !EM_ConfigHandler.loadedConfigs.contains(filename)) {
                EnviroMine.logger.log(Level.ERROR, "CONFIG DUPLICATE: Spoiling/Rot -" + name.toUpperCase() + " - Meta:" + meta + " was already added from " + EM_Settings.rotProperties.get((Object)name).loadedFrom.toUpperCase() + " and will be overriden by " + filename.toUpperCase());
            }
            EM_Settings.rotProperties.put("" + name + "," + meta, entry);
        }
    }

    @Override
    public void SaveProperty(Configuration config, String category) {
        config.get(category, RPName[0], this.name).getString();
        config.get(category, RPName[1], this.meta).getInt(-1);
        config.get(category, RPName[2], this.rotID, "Set blank to rot into nothing").getString();
        config.get(category, RPName[3], this.rotMeta).getInt(0);
        config.get(category, RPName[4], this.days, "Set this to -1 to disable rotting on this item").getInt(7);
    }

    @Override
    public void GenDefaults() {
        for (Item item : Item.field_150901_e) {
            if (item == null) continue;
            String[] regName = Item.field_150901_e.func_148750_c((Object)item).split(":");
            if (regName.length <= 0) {
                EnviroMine.logger.log(Level.ERROR, "Failed to get correctly formatted object name for " + item.func_77658_a() + "_" + regName[1]);
                continue;
            }
            File itemFile = new File(EM_ConfigHandler.loadedProfile + EM_ConfigHandler.customPath + EnviroUtils.SafeFilename(regName[0]) + ".cfg");
            if (!itemFile.exists()) {
                try {
                    itemFile.createNewFile();
                }
                catch (Exception e) {
                    EnviroMine.logger.log(Level.ERROR, "Failed to create file for " + item.func_77658_a() + "_" + regName[1], (Throwable)e);
                    continue;
                }
            }
            Configuration config = new Configuration(itemFile, true);
            String category = this.categoryName() + "." + EnviroUtils.replaceULN(item.func_77658_a() + "_" + regName[1]);
            config.load();
            if (item == Items.field_151078_bh || item == ObjectHandler.rottenFood) {
                config.get(category, RPName[0], Item.field_150901_e.func_148750_c((Object)item)).getString();
                config.get(category, RPName[1], -1).getInt(-1);
                config.get(category, RPName[2], "", "Set blank to rot into nothing").getString();
                config.get(category, RPName[3], 0).getInt(0);
                config.get(category, RPName[4], -1, "Set this to -1 to disable rotting on this item").getInt(-1);
            } else if (item == Items.field_151117_aB) {
                config.get(category, RPName[0], Item.field_150901_e.func_148750_c((Object)item)).getString();
                config.get(category, RPName[1], -1).getInt(-1);
                config.get(category, RPName[2], Item.field_150901_e.func_148750_c((Object)ObjectHandler.spoiledMilk), "Set blank to rot into nothing").getString();
                config.get(category, RPName[3], 0).getInt(0);
                config.get(category, RPName[4], 7, "Set this to -1 to disable rotting on this item").getInt(7);
            } else if (item == Items.field_151070_bp) {
                config.get(category, RPName[0], Item.field_150901_e.func_148750_c((Object)item)).getString();
                config.get(category, RPName[1], -1).getInt(-1);
                config.get(category, RPName[2], Item.field_150901_e.func_148750_c((Object)Items.field_151071_bq), "Set blank to rot into nothing").getString();
                config.get(category, RPName[3], 0).getInt(0);
                config.get(category, RPName[4], 7, "Set this to -1 to disable rotting on this item").getInt(7);
            } else if (item == Items.field_151071_bq || item == Items.field_151082_bd || item == Items.field_151076_bf || item == Items.field_151147_al || item == Items.field_151115_aP || item == Items.field_151083_be || item == Items.field_151077_bg || item == Items.field_151157_am || item == Items.field_151101_aQ) {
                config.get(category, RPName[0], Item.field_150901_e.func_148750_c((Object)item)).getString();
                config.get(category, RPName[1], -1).getInt(-1);
                config.get(category, RPName[2], Item.field_150901_e.func_148750_c((Object)Items.field_151078_bh), "Set blank to rot into nothing").getString();
                config.get(category, RPName[3], 0).getInt(0);
                config.get(category, RPName[4], 7, "Set this to -1 to disable rotting on this item").getInt(7);
            } else if (item instanceof ItemFood && (regName[0].equals("minecraft") || EM_Settings.genConfigs)) {
                config.get(category, RPName[0], Item.field_150901_e.func_148750_c((Object)item)).getString();
                config.get(category, RPName[1], -1).getInt(-1);
                config.get(category, RPName[2], Item.field_150901_e.func_148750_c((Object)ObjectHandler.rottenFood), "Set blank to rot into nothing").getString();
                config.get(category, RPName[3], 0).getInt(0);
                config.get(category, RPName[4], 7, "Set this to -1 to disable rotting on this item").getInt(7);
            }
            config.save();
        }
    }

    @Override
    public File GetDefaultFile() {
        return new File(EM_ConfigHandler.loadedProfile + EM_ConfigHandler.customPath + "Spoiling.cfg");
    }

    @Override
    public void generateEmpty(Configuration config, Object obj) {
        if (obj == null || !(obj instanceof Item)) {
            EnviroMine.logger.log(Level.ERROR, "Tried to register config with non item object!", (Throwable)new Exception());
            return;
        }
        Item item = (Item)obj;
        String[] regName = Item.field_150901_e.func_148750_c((Object)item).split(":");
        if (regName.length <= 0) {
            EnviroMine.logger.log(Level.ERROR, "Failed to get correctly formatted object name for " + item.func_77658_a() + "_" + regName[1]);
            return;
        }
        String category = this.categoryName() + "." + EnviroUtils.replaceULN(item.func_77658_a() + "_" + regName[1]);
        config.get(category, RPName[0], Item.field_150901_e.func_148750_c((Object)item)).getString();
        config.get(category, RPName[1], -1).getInt(-1);
        config.get(category, RPName[2], Item.field_150901_e.func_148750_c((Object)ObjectHandler.rottenFood), "Set blank to rot into nothing").getString();
        config.get(category, RPName[3], 0).getInt(0);
        config.get(category, RPName[4], 7, "Set this to -1 to disable rotting on this item").getInt(7);
    }

    @Override
    public boolean useCustomConfigs() {
        return true;
    }

    @Override
    public void customLoad() {
    }

    static {
        RotProperties.RPName[0] = "01.ID";
        RotProperties.RPName[1] = "02.Damage";
        RotProperties.RPName[2] = "03.Rotten ID";
        RotProperties.RPName[3] = "04.Rotten Damage";
        RotProperties.RPName[4] = "05.Days To Rot";
    }
}

