/*
 * Decompiled with CFR 0.152.
 */
package enviromine.trackers.properties;

import enviromine.core.EM_ConfigHandler;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import enviromine.trackers.properties.helpers.PropertyBase;
import enviromine.utils.EnviroUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.entity.EntityList;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;

public class CaveSpawnProperties
implements PropertyBase {
    public static final CaveSpawnProperties base = new CaveSpawnProperties();
    static String[] CGPNames;
    public int id;
    public int weight;
    public int minGroup;
    public int maxGroup;

    public CaveSpawnProperties() {
        if (base != null && base != this) {
            throw new IllegalStateException();
        }
    }

    public CaveSpawnProperties(int id, int weight, int minGroup, int maxGroup) {
        this.id = id;
        this.weight = weight;
        this.minGroup = minGroup;
        this.maxGroup = maxGroup;
    }

    @Override
    public String categoryName() {
        return "Cave Entities";
    }

    @Override
    public String categoryDescription() {
        return "Changes what entities can spawn in the cave dimension";
    }

    @Override
    public void LoadProperty(Configuration config, String category) {
        config.setCategoryComment(this.categoryName(), this.categoryDescription());
        int nID = config.get(category, CGPNames[0], 0).getInt(0);
        int nWeight = config.get(category, CGPNames[1], 100).getInt(100);
        int nMin = config.get(category, CGPNames[2], 4).getInt(4);
        int nMax = config.get(category, CGPNames[3], 4).getInt(4);
        CaveSpawnProperties entry = new CaveSpawnProperties(nID, nWeight, nMin, nMax);
        EM_Settings.caveSpawnProperties.put(nID, entry);
    }

    @Override
    public void SaveProperty(Configuration config, String category) {
        config.get(category, CGPNames[0], this.id);
        config.get(category, CGPNames[1], this.weight);
        config.get(category, CGPNames[2], this.minGroup);
        config.get(category, CGPNames[3], this.maxGroup);
    }

    @Override
    public void GenDefaults() {
        String catName;
        File file = this.GetDefaultFile();
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                EnviroMine.logger.log(Level.ERROR, "Failed to create file for Cave Ores", (Throwable)e);
                return;
            }
        }
        Configuration config = new Configuration(file, true);
        config.load();
        if (config.hasCategory(this.categoryName())) {
            config.save();
            return;
        }
        if (!config.hasCategory(this.categoryName() + ".Bat")) {
            catName = this.categoryName() + ".Bat";
            config.get(catName, CGPNames[0], 65);
            config.get(catName, CGPNames[1], 100);
            config.get(catName, CGPNames[2], 4);
            config.get(catName, CGPNames[3], 8);
        }
        if (!config.hasCategory(this.categoryName() + ".Creeper")) {
            catName = this.categoryName() + ".Creeper";
            config.get(catName, CGPNames[0], 50);
            config.get(catName, CGPNames[1], 1);
            config.get(catName, CGPNames[2], 1);
            config.get(catName, CGPNames[3], 1);
        }
        if (!config.hasCategory(this.categoryName() + ".Silverfish")) {
            catName = this.categoryName() + ".Silverfish";
            config.get(catName, CGPNames[0], 50);
            config.get(catName, CGPNames[1], 100);
            config.get(catName, CGPNames[2], 1);
            config.get(catName, CGPNames[3], 4);
        }
        config.save();
    }

    @Override
    public File GetDefaultFile() {
        return new File(EM_ConfigHandler.configPath + "CaveDimension.cfg");
    }

    @Override
    public void generateEmpty(Configuration config, Object obj) {
        if (obj == null || !(obj instanceof Integer)) {
            EnviroMine.logger.log(Level.ERROR, "Tried to register config with non entity object!", (Throwable)new Exception());
            return;
        }
        int eID = (Integer)obj;
        String catName = this.categoryName() + "." + EnviroUtils.replaceULN(EntityList.func_75617_a((int)eID));
        config.get(catName, CGPNames[0], eID);
        config.get(catName, CGPNames[1], 100);
        config.get(catName, CGPNames[2], 4);
        config.get(catName, CGPNames[3], 4);
    }

    @Override
    public boolean useCustomConfigs() {
        return false;
    }

    @Override
    public void customLoad() {
        Configuration config;
        try {
            config = new Configuration(this.GetDefaultFile(), true);
        }
        catch (Exception e) {
            EnviroMine.logger.log(Level.ERROR, "Failed to load custom configuration for " + this.getClass().getSimpleName(), (Throwable)e);
            return;
        }
        config.load();
        ArrayList<String> entries = EM_ConfigHandler.getSubCategories(config, this.categoryName());
        Iterator<String> iterator = entries.iterator();
        while (iterator.hasNext()) {
            this.LoadProperty(config, iterator.next());
        }
        config.save();
    }

    static {
        EM_Settings.caveSpawnProperties = new HashMap();
        CGPNames = new String[8];
        CaveSpawnProperties.CGPNames[0] = "01.Entity ID";
        CaveSpawnProperties.CGPNames[1] = "02.Spawn Weight";
        CaveSpawnProperties.CGPNames[2] = "03.Min Group Size";
        CaveSpawnProperties.CGPNames[3] = "04.Max Group Size";
    }
}

