/*
 * Decompiled with CFR 0.152.
 */
package enviromine.trackers.properties;

import enviromine.core.EM_ConfigHandler;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import enviromine.handlers.ObjectHandler;
import enviromine.trackers.properties.StabilityType;
import enviromine.trackers.properties.helpers.PropertyBase;
import enviromine.trackers.properties.helpers.SerialisableProperty;
import enviromine.utils.EnviroUtils;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;

public class BlockProperties
implements SerialisableProperty,
PropertyBase {
    public static final BlockProperties base = new BlockProperties();
    static String[] BPName = new String[12];
    public boolean hasPhys;
    public String name;
    public int meta;
    public String stability;
    public int minFall;
    public int maxFall;
    public int supportDist;
    public String dropName;
    public int dropMeta;
    public int dropNum;
    public boolean enableTemp;
    public float temp;
    public float air;
    public float sanity;
    public boolean holdsOthers;
    public boolean slides;
    public boolean canHang;
    public boolean wetSlide;
    public String loadedFrom;

    public BlockProperties(NBTTagCompound tags) {
        this.ReadFromNBT(tags);
    }

    public BlockProperties() {
        if (base != null && base != this) {
            throw new IllegalStateException();
        }
    }

    public BlockProperties(String name, int meta, boolean hasPhys, int minFall, int maxFall, int supportDist, String dropName, int dropMeta, int dropNum, boolean enableTemp, float temp, float air, float sanity, boolean holdOther, boolean slides, boolean canHang, boolean wetSlide, String stability, String fileName) {
        this.name = name;
        this.meta = meta;
        this.hasPhys = hasPhys;
        this.minFall = minFall;
        this.maxFall = maxFall;
        this.supportDist = supportDist;
        this.dropName = dropName;
        this.dropMeta = dropMeta;
        this.dropNum = dropNum;
        this.enableTemp = enableTemp;
        this.temp = temp;
        this.air = air;
        this.sanity = sanity;
        this.holdsOthers = holdOther;
        this.slides = slides;
        this.canHang = canHang;
        this.wetSlide = wetSlide;
        this.stability = stability;
        this.loadedFrom = fileName;
    }

    public boolean hasProperty(Block block, int meta) {
        return EM_Settings.blockProperties.containsKey("" + Block.field_149771_c.func_148750_c((Object)block) + "," + meta) || EM_Settings.blockProperties.containsKey("" + Block.field_149771_c.func_148750_c((Object)block));
    }

    public BlockProperties getProperty(Block block, int meta) {
        BlockProperties blockProps = null;
        blockProps = EM_Settings.blockProperties.containsKey("" + Block.field_149771_c.func_148750_c((Object)block) + "," + meta) ? EM_Settings.blockProperties.get("" + Block.field_149771_c.func_148750_c((Object)block) + "," + meta) : EM_Settings.blockProperties.get("" + Block.field_149771_c.func_148750_c((Object)block));
        return blockProps;
    }

    @Override
    public NBTTagCompound WriteToNBT() {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74778_a("name", this.name);
        tags.func_74768_a("metaData", this.meta);
        tags.func_74778_a("dropName", this.dropName);
        tags.func_74768_a("dropMeta", this.dropMeta);
        tags.func_74768_a("dropNum", this.dropNum);
        tags.func_74757_a("enableTemp", this.enableTemp);
        tags.func_74776_a("temp", this.temp);
        tags.func_74776_a("air", this.air);
        tags.func_74776_a("sanity", this.sanity);
        tags.func_74757_a("holdsOthers", this.holdsOthers);
        tags.func_74757_a("slides", this.slides);
        tags.func_74757_a("canHang", this.canHang);
        tags.func_74757_a("wetSlide", this.wetSlide);
        return tags;
    }

    @Override
    public void ReadFromNBT(NBTTagCompound tags) {
        this.name = tags.func_74779_i("name");
        this.meta = tags.func_74762_e("metaData");
        this.dropName = tags.func_74779_i("dropName");
        this.dropMeta = tags.func_74762_e("dropMeta");
        this.dropNum = tags.func_74762_e("dropNum");
        this.enableTemp = tags.func_74767_n("enableTemp");
        this.temp = tags.func_74760_g("temp");
        this.air = tags.func_74760_g("air");
        this.sanity = tags.func_74760_g("sanity");
        this.holdsOthers = tags.func_74767_n("holdsOthers");
        this.slides = tags.func_74767_n("slides");
        this.canHang = tags.func_74767_n("canHang");
        this.wetSlide = tags.func_74767_n("wetSlide");
    }

    @Override
    public String categoryName() {
        return "blocks";
    }

    @Override
    public String categoryDescription() {
        return "Customise the physical properties and environmental effects of blocks";
    }

    @Override
    public void LoadProperty(Configuration config, String category) {
        config.setCategoryComment(this.categoryName(), this.categoryDescription());
        String name = config.get(category, BPName[0], "").getString();
        int metaData = config.get(category, BPName[1], 0).getInt(0);
        String dropName = config.get(category, BPName[2], "").getString();
        int dropMeta = config.get(category, BPName[3], 0).getInt(0);
        int dropNum = config.get(category, BPName[4], -1).getInt(-1);
        boolean enableTemp = config.get(category, BPName[5], false).getBoolean(false);
        float temperature = (float)config.get(category, BPName[6], 0.0).getDouble(0.0);
        float airQuality = (float)config.get(category, BPName[7], 0.0).getDouble(0.0);
        float sanity = (float)config.get(category, BPName[8], 0.0).getDouble(0.0);
        String stability = config.get(category, BPName[9], EM_Settings.defaultStability).getString();
        boolean slides = config.get(category, BPName[10], false).getBoolean(false);
        boolean wetSlides = config.get(category, BPName[11], false).getBoolean(false);
        String filename = config.getConfigFile().getName();
        int minFall = 99;
        int maxFall = 99;
        int supportDist = 5;
        boolean holdOther = false;
        boolean canHang = true;
        boolean hasPhys = false;
        if (EM_Settings.stabilityTypes.containsKey(stability)) {
            StabilityType stabType = EM_Settings.stabilityTypes.get(stability);
            minFall = stabType.minFall;
            maxFall = stabType.maxFall;
            supportDist = stabType.supportDist;
            hasPhys = stabType.enablePhysics;
            holdOther = stabType.holdOther;
            canHang = stabType.canHang;
        } else {
            EnviroMine.logger.log(Level.WARN, "Stability type '" + stability + "' not found.");
            minFall = 99;
            maxFall = 99;
            supportDist = 9;
            hasPhys = false;
            holdOther = false;
            canHang = true;
        }
        BlockProperties entry = new BlockProperties(name, metaData, hasPhys, minFall, maxFall, supportDist, dropName, dropMeta, dropNum, enableTemp, temperature, airQuality, sanity, holdOther, slides, canHang, wetSlides, stability, filename);
        if (metaData < 0) {
            if (EM_Settings.blockProperties.containsKey("" + name) && !EM_ConfigHandler.loadedConfigs.contains(filename)) {
                EnviroMine.logger.log(Level.ERROR, "CONFIG DUPLICATE: Block - " + name.toUpperCase() + " was already added from " + EM_Settings.blockProperties.get((Object)name).loadedFrom.toUpperCase() + " and will be overriden by " + filename.toUpperCase());
            }
            EM_Settings.blockProperties.put("" + name, entry);
        } else {
            if (EM_Settings.blockProperties.containsKey("" + name + "," + metaData) && !EM_ConfigHandler.loadedConfigs.contains(filename)) {
                EnviroMine.logger.log(Level.ERROR, "CONFIG DUPLICATE: Block - " + name.toUpperCase() + " - Meta:" + this.meta + "  was already added from " + EM_Settings.blockProperties.get((Object)name).loadedFrom.toUpperCase() + " and will be overriden by " + filename.toUpperCase());
            }
            EM_Settings.blockProperties.put("" + name + "," + metaData, entry);
        }
    }

    @Override
    public void SaveProperty(Configuration config, String category) {
        config.get(category, BPName[0], this.name).getString();
        config.get(category, BPName[1], this.meta).getInt(0);
        config.get(category, BPName[2], this.dropName).getString();
        config.get(category, BPName[3], this.dropMeta).getInt(0);
        config.get(category, BPName[4], this.dropNum).getInt(-1);
        config.get(category, BPName[5], this.enableTemp).getBoolean(false);
        config.get(category, BPName[6], (double)this.temp).getDouble(0.0);
        config.get(category, BPName[7], (double)this.air).getDouble(0.0);
        config.get(category, BPName[8], (double)this.sanity).getDouble(0.0);
        config.get(category, BPName[9], this.stability).getString();
        config.get(category, BPName[10], this.slides).getBoolean(false);
        config.get(category, BPName[11], this.wetSlide).getBoolean(false);
    }

    @Override
    public void GenDefaults() {
        for (Block block : Block.field_149771_c) {
            if (block == null || block == Blocks.field_150350_a) continue;
            String[] regName = Block.field_149771_c.func_148750_c((Object)block).split(":");
            if (regName.length <= 0) {
                EnviroMine.logger.log(Level.ERROR, "Failed to get correctly formatted object name for " + block.func_149739_a());
                continue;
            }
            File blockFile = new File(EM_ConfigHandler.loadedProfile + EM_ConfigHandler.customPath + EnviroUtils.SafeFilename(regName[0]) + ".cfg");
            if (!blockFile.exists()) {
                try {
                    blockFile.createNewFile();
                }
                catch (Exception e) {
                    EnviroMine.logger.log(Level.ERROR, "Failed to create file for " + regName[1], (Throwable)e);
                    continue;
                }
            }
            Configuration config = new Configuration(blockFile, true);
            config.load();
            String category = this.categoryName() + "." + EnviroUtils.replaceULN(block.func_149739_a() + "_" + regName[1]);
            StabilityType defStability = EnviroUtils.getDefaultStabilityType(block);
            if (block == Blocks.field_150353_l || block == Blocks.field_150356_k || block == ObjectHandler.fireGasBlock || EM_Settings.genConfigs && block.func_149688_o() == Material.field_151587_i) {
                config.get(category, BPName[0], Block.field_149771_c.func_148750_c((Object)block)).getString();
                config.get(category, BPName[1], -1).getInt(-1);
                config.get(category, BPName[2], "").getString();
                config.get(category, BPName[3], -1).getInt(-1);
                config.get(category, BPName[4], -1).getInt(-1);
                config.get(category, BPName[5], true).getBoolean(true);
                config.get(category, BPName[6], 200.0).getDouble(200.0);
                config.get(category, BPName[7], -1.0).getDouble(-1.0);
                config.get(category, BPName[8], 0.0).getDouble(0.0);
                config.get(category, BPName[9], defStability.name).getString();
                config.get(category, BPName[10], false).getBoolean(false);
                config.get(category, BPName[11], false).getBoolean(false);
            } else if (block == Blocks.field_150480_ab || block == ObjectHandler.burningCoal || block == ObjectHandler.fireTorch || EM_Settings.genConfigs && block.func_149688_o() == Material.field_151581_o) {
                config.get(category, BPName[0], Block.field_149771_c.func_148750_c((Object)block)).getString();
                config.get(category, BPName[1], -1).getInt(-1);
                config.get(category, BPName[2], "").getString();
                config.get(category, BPName[3], -1).getInt(-1);
                config.get(category, BPName[4], -1).getInt(-1);
                config.get(category, BPName[5], true).getBoolean(true);
                config.get(category, BPName[6], 75.0).getDouble(75.0);
                config.get(category, BPName[7], -0.25).getDouble(-0.25);
                config.get(category, BPName[8], 0.0).getDouble(0.0);
                config.get(category, BPName[9], defStability.name).getString();
                config.get(category, BPName[10], false).getBoolean(false);
                config.get(category, BPName[11], false).getBoolean(false);
            } else if (block == Blocks.field_150478_aa || block == Blocks.field_150470_am || block == ObjectHandler.fireTorch) {
                config.get(category, BPName[0], Block.field_149771_c.func_148750_c((Object)block)).getString();
                config.get(category, BPName[1], -1).getInt(-1);
                config.get(category, BPName[2], "").getString();
                config.get(category, BPName[3], -1).getInt(-1);
                config.get(category, BPName[4], -1).getInt(-1);
                config.get(category, BPName[5], true).getBoolean(true);
                config.get(category, BPName[6], 75.0).getDouble(75.0);
                config.get(category, BPName[7], -0.25).getDouble(-0.25);
                config.get(category, BPName[8], 0.0).getDouble(0.0);
                config.get(category, BPName[9], defStability.name).getString();
                config.get(category, BPName[10], false).getBoolean(false);
                config.get(category, BPName[11], false).getBoolean(false);
            } else if (block == Blocks.field_150424_aL || block == Blocks.field_150385_bj || block == Blocks.field_150386_bk || block == Blocks.field_150387_bl) {
                config.get(category, BPName[0], Block.field_149771_c.func_148750_c((Object)block)).getString();
                config.get(category, BPName[1], -1).getInt(-1);
                config.get(category, BPName[2], "").getString();
                config.get(category, BPName[3], -1).getInt(-1);
                config.get(category, BPName[4], -1).getInt(-1);
                config.get(category, BPName[5], true).getBoolean(true);
                config.get(category, BPName[6], 50.0).getDouble(50.0);
                config.get(category, BPName[7], 0.0).getDouble(0.0);
                config.get(category, BPName[8], 0.0).getDouble(0.0);
                config.get(category, BPName[9], defStability.name).getString();
                config.get(category, BPName[10], false).getBoolean(false);
                config.get(category, BPName[11], false).getBoolean(false);
            } else if ((block == Blocks.field_150457_bL || block == Blocks.field_150349_c || block instanceof BlockLeavesBase || block instanceof BlockFlower || block instanceof BlockBush || block.func_149688_o() == Material.field_151577_b || block.func_149688_o() == Material.field_151584_j || block.func_149688_o() == Material.field_151582_l || block.func_149688_o() == Material.field_151585_k) && (regName[0].equals("minecraft") || EM_Settings.genConfigs)) {
                config.get(category, BPName[0], Block.field_149771_c.func_148750_c((Object)block)).getString();
                config.get(category, BPName[1], -1).getInt(-1);
                config.get(category, BPName[2], block == Blocks.field_150349_c ? Block.field_149771_c.func_148750_c((Object)Blocks.field_150346_d) : "").getString();
                config.get(category, BPName[3], -1).getInt(-1);
                config.get(category, BPName[4], -1).getInt(-1);
                config.get(category, BPName[5], false).getBoolean(false);
                config.get(category, BPName[6], 0.0).getDouble(0.0);
                config.get(category, BPName[7], 1.0).getDouble(1.0);
                config.get(category, BPName[8], 0.1).getDouble(0.1);
                config.get(category, BPName[9], defStability.name).getString();
                config.get(category, BPName[10], false).getBoolean(false);
                config.get(category, BPName[11], false).getBoolean(false);
            } else if ((block.func_149688_o() == Material.field_151597_y || block.func_149688_o() == Material.field_151588_w || block.func_149688_o() == Material.field_151598_x) && (regName[0].equals("minecraft") || EM_Settings.genConfigs)) {
                config.get(category, BPName[0], Block.field_149771_c.func_148750_c((Object)block)).getString();
                config.get(category, BPName[1], -1).getInt(-1);
                config.get(category, BPName[2], "").getString();
                config.get(category, BPName[3], -1).getInt(-1);
                config.get(category, BPName[4], -1).getInt(-1);
                config.get(category, BPName[5], true).getBoolean(true);
                config.get(category, BPName[6], -0.02).getDouble(-0.02);
                config.get(category, BPName[7], 0.0).getDouble(0.0);
                config.get(category, BPName[8], 0.0).getDouble(0.0);
                config.get(category, BPName[9], defStability.name).getString();
                config.get(category, BPName[10], false).getBoolean(false);
                config.get(category, BPName[11], block == Blocks.field_150433_aE || block == Blocks.field_150431_aC).getBoolean(block == Blocks.field_150433_aE || block == Blocks.field_150431_aC);
            } else if ((block == Blocks.field_150465_bP || block == Blocks.field_150425_aM) && (regName[0].equals("minecraft") || EM_Settings.genConfigs)) {
                config.get(category, BPName[0], Block.field_149771_c.func_148750_c((Object)block)).getString();
                config.get(category, BPName[1], -1).getInt(-1);
                config.get(category, BPName[2], "").getString();
                config.get(category, BPName[3], -1).getInt(-1);
                config.get(category, BPName[4], -1).getInt(-1);
                config.get(category, BPName[5], false).getBoolean(false);
                config.get(category, BPName[6], 0.0).getDouble(0.0);
                config.get(category, BPName[7], 0.0).getDouble(0.0);
                config.get(category, BPName[8], -0.1).getDouble(-0.1);
                config.get(category, BPName[9], defStability.name).getString();
                config.get(category, BPName[10], false).getBoolean(false);
                config.get(category, BPName[11], false).getBoolean(false);
            } else if (block.func_149688_o() == Material.field_151569_G && (regName[0].equals("minecraft") || EM_Settings.genConfigs)) {
                config.get(category, BPName[0], Block.field_149771_c.func_148750_c((Object)block)).getString();
                config.get(category, BPName[1], -1).getInt(-1);
                config.get(category, BPName[2], "").getString();
                config.get(category, BPName[3], -1).getInt(-1);
                config.get(category, BPName[4], -1).getInt(-1);
                config.get(category, BPName[5], false).getBoolean(false);
                config.get(category, BPName[6], 0.0).getDouble(0.0);
                config.get(category, BPName[7], 0.0).getDouble(0.0);
                config.get(category, BPName[8], -0.01).getDouble(-0.01);
                config.get(category, BPName[9], defStability.name).getString();
                config.get(category, BPName[10], false).getBoolean(false);
                config.get(category, BPName[11], false).getBoolean(false);
            } else if (block.func_149688_o() == Material.field_151566_D && (regName[0].equals("minecraft") || EM_Settings.genConfigs)) {
                config.get(category, BPName[0], Block.field_149771_c.func_148750_c((Object)block)).getString();
                config.get(category, BPName[1], -1).getInt(-1);
                config.get(category, BPName[2], "").getString();
                config.get(category, BPName[3], -1).getInt(-1);
                config.get(category, BPName[4], -1).getInt(-1);
                config.get(category, BPName[5], false).getBoolean(false);
                config.get(category, BPName[6], 0.0).getDouble(0.0);
                config.get(category, BPName[7], 0.0).getDouble(0.0);
                config.get(category, BPName[8], 1.0).getDouble(1.0);
                config.get(category, BPName[9], defStability.name).getString();
                config.get(category, BPName[10], false).getBoolean(false);
                config.get(category, BPName[11], false).getBoolean(false);
            } else if (block instanceof BlockFalling && (regName[0].equals("minecraft") || EM_Settings.genConfigs)) {
                config.get(category, BPName[0], Block.field_149771_c.func_148750_c((Object)block)).getString();
                config.get(category, BPName[1], -1).getInt(-1);
                config.get(category, BPName[2], "").getString();
                config.get(category, BPName[3], -1).getInt(-1);
                config.get(category, BPName[4], -1).getInt(-1);
                config.get(category, BPName[5], false).getBoolean(false);
                config.get(category, BPName[6], 0.0).getDouble(0.0);
                config.get(category, BPName[7], 0.0).getDouble(0.0);
                config.get(category, BPName[8], 0.0).getDouble(0.0);
                config.get(category, BPName[9], defStability.name).getString();
                config.get(category, BPName[10], true).getBoolean(true);
                config.get(category, BPName[11], false).getBoolean(false);
            } else if (block == Blocks.field_150346_d) {
                config.get(category, BPName[0], Block.field_149771_c.func_148750_c((Object)block)).getString();
                config.get(category, BPName[1], -1).getInt(-1);
                config.get(category, BPName[2], "").getString();
                config.get(category, BPName[3], -1).getInt(-1);
                config.get(category, BPName[4], -1).getInt(-1);
                config.get(category, BPName[5], false).getBoolean(false);
                config.get(category, BPName[6], 0.0).getDouble(0.0);
                config.get(category, BPName[7], 0.0).getDouble(0.0);
                config.get(category, BPName[8], 0.0).getDouble(0.0);
                config.get(category, BPName[9], defStability.name).getString();
                config.get(category, BPName[10], false).getBoolean(false);
                config.get(category, BPName[11], true).getBoolean(true);
            } else if (EM_Settings.genConfigs) {
                this.generateEmpty(config, block);
            }
            config.save();
        }
    }

    @Override
    public File GetDefaultFile() {
        return new File(EM_ConfigHandler.loadedProfile + EM_ConfigHandler.customPath + "Blocks.cfg");
    }

    @Override
    public void generateEmpty(Configuration config, Object obj) {
        if (obj == null || !(obj instanceof Block)) {
            EnviroMine.logger.log(Level.ERROR, "Tried to register config with non block object!", (Throwable)new Exception());
            return;
        }
        Block block = (Block)obj;
        String[] regName = Block.field_149771_c.func_148750_c((Object)block).split(":");
        if (regName.length <= 0) {
            EnviroMine.logger.log(Level.ERROR, "Failed to get correctly formatted object name for " + block.func_149739_a() + "_" + regName[1]);
            return;
        }
        String category = this.categoryName() + "." + EnviroUtils.replaceULN(block.func_149739_a() + "_" + regName[1]);
        StabilityType defStability = EnviroUtils.getDefaultStabilityType(block);
        config.get(category, BPName[0], Block.field_149771_c.func_148750_c((Object)block)).getString();
        config.get(category, BPName[1], -1).getInt(0);
        config.get(category, BPName[2], block == Blocks.field_150348_b ? Block.field_149771_c.func_148750_c((Object)Blocks.field_150347_e) : (block == Blocks.field_150349_c ? Block.field_149771_c.func_148750_c((Object)Blocks.field_150346_d) : "")).getString();
        config.get(category, BPName[3], -1).getInt(0);
        config.get(category, BPName[4], -1).getInt(0);
        config.get(category, BPName[5], false).getBoolean(false);
        config.get(category, BPName[6], 0.0).getDouble(0.0);
        config.get(category, BPName[7], 0.0).getDouble(0.0);
        config.get(category, BPName[8], 0.0).getDouble(0.0);
        config.get(category, BPName[9], defStability.name).getString();
        config.get(category, BPName[10], false).getBoolean(false);
        config.get(category, BPName[11], false).getBoolean(false);
    }

    @Override
    public boolean useCustomConfigs() {
        return true;
    }

    @Override
    public void customLoad() {
    }

    static {
        BlockProperties.BPName[0] = "01.Name";
        BlockProperties.BPName[1] = "02.MetaID";
        BlockProperties.BPName[2] = "03.DropName";
        BlockProperties.BPName[3] = "04.DropMetaID";
        BlockProperties.BPName[4] = "05.DropNumber";
        BlockProperties.BPName[5] = "06.Enable Temperature";
        BlockProperties.BPName[6] = "07.Temperature";
        BlockProperties.BPName[7] = "08.Air Quality";
        BlockProperties.BPName[8] = "09.Sanity";
        BlockProperties.BPName[9] = "10.Stability";
        BlockProperties.BPName[10] = "11.Slides";
        BlockProperties.BPName[11] = "12.Slides When Wet";
    }
}

