/*
 * Decompiled with CFR 0.152.
 */
package enviromine.trackers.properties;

import enviromine.core.EM_ConfigHandler;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import enviromine.trackers.properties.helpers.PropertyBase;
import enviromine.trackers.properties.helpers.SerialisableProperty;
import enviromine.utils.EnviroUtils;
import enviromine.utils.ModIdentification;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;

public class BiomeProperties
implements SerialisableProperty,
PropertyBase {
    public static final BiomeProperties base = new BiomeProperties();
    static String[] BOName = new String[8];
    public int id;
    public boolean biomeOveride;
    public String waterQuality;
    public float ambientTemp;
    public float tempRate;
    public float sanityRate;
    public float dehydrateRate;
    public float airRate;
    public String loadedFrom;

    public BiomeProperties(NBTTagCompound tags) {
        this.ReadFromNBT(tags);
    }

    public BiomeProperties() {
        if (base != null && base != this) {
            throw new IllegalStateException();
        }
    }

    public BiomeProperties(int id, boolean biomeOveride, String waterQuality, float ambientTemp, float tempRate, float sanityRate, float dehydrateRate, float airRate, String filename) {
        this.id = id;
        this.biomeOveride = biomeOveride;
        this.waterQuality = waterQuality;
        this.ambientTemp = ambientTemp;
        this.tempRate = tempRate;
        this.sanityRate = sanityRate;
        this.dehydrateRate = dehydrateRate;
        this.airRate = airRate;
        this.loadedFrom = filename;
    }

    public boolean hasProperty(BiomeGenBase biome) {
        return EM_Settings.biomeProperties.containsKey(biome.field_76756_M);
    }

    public BiomeProperties getProperty(BiomeGenBase biome) {
        return EM_Settings.biomeProperties.get(biome.field_76756_M);
    }

    public int getWaterQualityId() {
        if (this.waterQuality.trim().equalsIgnoreCase("dirty")) {
            return 1;
        }
        if (this.waterQuality.trim().equalsIgnoreCase("salty")) {
            return 2;
        }
        if (this.waterQuality.trim().equalsIgnoreCase("cold")) {
            return 3;
        }
        if (this.waterQuality.trim().equalsIgnoreCase("clean")) {
            return 0;
        }
        return -1;
    }

    @Override
    public NBTTagCompound WriteToNBT() {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74768_a("id", this.id);
        tags.func_74757_a("biomeOveride", this.biomeOveride);
        tags.func_74778_a("waterQuality", this.waterQuality);
        tags.func_74776_a("ambientTemp", this.ambientTemp);
        tags.func_74776_a("tempRate", this.tempRate);
        tags.func_74776_a("sanityRate", this.sanityRate);
        tags.func_74776_a("dehydrateRate", this.dehydrateRate);
        return tags;
    }

    @Override
    public void ReadFromNBT(NBTTagCompound tags) {
        this.id = tags.func_74762_e("id");
        this.biomeOveride = tags.func_74767_n("biomeOveride");
        this.waterQuality = tags.func_74779_i("waterQuality");
        this.ambientTemp = tags.func_74760_g("ambientTemp");
        this.tempRate = tags.func_74760_g("tempRate");
        this.sanityRate = tags.func_74760_g("sanityRate");
        this.dehydrateRate = tags.func_74760_g("dehydrateRate");
    }

    @Override
    public String categoryName() {
        return "biomes";
    }

    @Override
    public String categoryDescription() {
        return "Manually change the environmental properties of each biome";
    }

    @Override
    public void LoadProperty(Configuration config, String category) {
        config.setCategoryComment(this.categoryName(), this.categoryDescription());
        int id = config.get(category, BOName[0], 0).getInt(0);
        boolean biomeOveride = config.get(category, BOName[1], false).getBoolean(false);
        String waterQ = config.get(category, BOName[2], "clean", "Water Quality: dirty, salty, cold, clean").getString();
        float ambTemp = (float)config.get(category, BOName[3], 25.0, "Biome temperature in celsius (Player body temp is offset by + 12C)").getDouble(25.0);
        float tempRate = (float)config.get(category, BOName[4], 0.0).getDouble(0.0);
        float sanRate = (float)config.get(category, BOName[5], 0.0).getDouble(0.0);
        float dehyRate = (float)config.get(category, BOName[6], 0.0).getDouble(0.0);
        float airRate = (float)config.get(category, BOName[7], 0.0).getDouble(0.0);
        String filename = config.getConfigFile().getName();
        BiomeProperties entry = new BiomeProperties(id, biomeOveride, waterQ, ambTemp, tempRate, sanRate, dehyRate, airRate, filename);
        if (EM_Settings.biomeProperties.containsKey(id) && !EM_ConfigHandler.loadedConfigs.contains(filename)) {
            EnviroMine.logger.log(Level.ERROR, "CONFIG DUPLICATE: Biome ID " + id + " was already added from " + EM_Settings.biomeProperties.get((Object)Integer.valueOf((int)id)).loadedFrom.toUpperCase() + " and will be overriden by " + filename.toUpperCase());
        }
        EM_Settings.biomeProperties.put(id, entry);
    }

    @Override
    public void SaveProperty(Configuration config, String category) {
        config.get(category, BOName[0], this.id).getInt(0);
        config.get(category, BOName[1], this.biomeOveride).getBoolean(this.biomeOveride);
        config.get(category, BOName[2], this.waterQuality, "Water Quality: dirty, salty, cold, clean").getString();
        config.get(category, BOName[3], (double)this.ambientTemp, "Biome temperature in celsius (Player body temp is offset by + 12C)").getDouble((double)this.ambientTemp);
        config.get(category, BOName[4], (double)this.tempRate).getDouble((double)this.tempRate);
        config.get(category, BOName[5], (double)this.sanityRate).getDouble((double)this.sanityRate);
        config.get(category, BOName[6], (double)this.dehydrateRate).getDouble((double)this.dehydrateRate);
        config.get(category, BOName[7], (double)this.airRate).getDouble((double)this.airRate);
    }

    @Override
    public void GenDefaults() {
        BiomeGenBase[] biomeArray = BiomeGenBase.func_150565_n();
        for (int p = 0; p < biomeArray.length; ++p) {
            BiomeGenBase biome = biomeArray[p];
            if (biome == null) continue;
            String modID = ModIdentification.idFromObject(biome);
            File file = new File(EM_ConfigHandler.loadedProfile + EM_ConfigHandler.customPath + EnviroUtils.SafeFilename(modID) + ".cfg");
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (Exception e) {
                    EnviroMine.logger.log(Level.ERROR, "Failed to create file for biome '" + biome.field_76791_y + "'", (Throwable)e);
                    continue;
                }
            }
            Configuration config = new Configuration(file, true);
            config.load();
            this.generateEmpty(config, biome);
            config.save();
        }
    }

    @Override
    public File GetDefaultFile() {
        return new File(EM_ConfigHandler.loadedProfile + EM_ConfigHandler.customPath + "Biomes.cfg");
    }

    @Override
    public void generateEmpty(Configuration config, Object obj) {
        if (obj == null || !(obj instanceof BiomeGenBase)) {
            EnviroMine.logger.log(Level.ERROR, "Tried to register config with non biome object!", (Throwable)new Exception());
            return;
        }
        BiomeGenBase biome = (BiomeGenBase)obj;
        ArrayList<BiomeDictionary.Type> typeList = new ArrayList<BiomeDictionary.Type>();
        BiomeDictionary.Type[] typeArray = BiomeDictionary.getTypesForBiome((BiomeGenBase)biome);
        for (int i = 0; i < typeArray.length; ++i) {
            typeList.add(typeArray[i]);
        }
        double air = typeList.contains(BiomeDictionary.Type.NETHER) ? -0.1 : 0.0;
        double sanity = typeList.contains(BiomeDictionary.Type.NETHER) ? -0.1 : 0.0;
        double water = typeList.contains(BiomeDictionary.Type.NETHER) || typeList.contains(BiomeDictionary.Type.DRY) ? 0.05 : 0.0;
        double temp = typeList.contains(BiomeDictionary.Type.NETHER) || typeList.contains(BiomeDictionary.Type.DRY) ? 0.005 : 0.0;
        String catName = this.categoryName() + "." + biome.field_76791_y;
        config.get(catName, BOName[0], biome.field_76756_M).getInt(biome.field_76756_M);
        config.get(catName, BOName[1], false).getBoolean(false);
        config.get(catName, BOName[2], EnviroUtils.getBiomeWater(biome), "Water Quality: dirty, salty, cold, clean").getString();
        config.get(catName, BOName[3], EnviroUtils.getBiomeTemp(biome), "Biome temperature in celsius (Player body temp is offset by + 12C)").getDouble(25.0);
        config.get(catName, BOName[4], temp).getDouble(temp);
        config.get(catName, BOName[5], sanity).getDouble(sanity);
        config.get(catName, BOName[6], water).getDouble(water);
        config.get(catName, BOName[7], air).getDouble(air);
    }

    @Override
    public boolean useCustomConfigs() {
        return true;
    }

    @Override
    public void customLoad() {
    }

    static {
        BiomeProperties.BOName[0] = "01.Biome ID";
        BiomeProperties.BOName[1] = "02.Allow Config Override";
        BiomeProperties.BOName[2] = "03.Water Quality";
        BiomeProperties.BOName[3] = "04.Ambient Temperature";
        BiomeProperties.BOName[4] = "05.Temp Rate";
        BiomeProperties.BOName[5] = "06.Sanity Rate";
        BiomeProperties.BOName[6] = "07.Dehydrate Rate";
        BiomeProperties.BOName[7] = "08.Air Quality Rate";
    }
}

